/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.ui.tables;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.Utils;

public class TableCellRefresher {
    private static TableCellRefresher instance = null;
    private AEThread2 refresher;
    private List cells = new ArrayList();
    private long iterationNumber;

    private TableCellRefresher() {
        this.refresher = new AEThread2("Cell Refresher", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TableCellRefresher.this.iterationNumber = 0L;
                    while (true) {
                        ArrayList cellsCopy;
                        List list = TableCellRefresher.this.cells;
                        synchronized (list) {
                            cellsCopy = new ArrayList(TableCellRefresher.this.cells.size());
                            cellsCopy.addAll(TableCellRefresher.this.cells);
                            TableCellRefresher.this.cells.clear();
                        }
                        for (int i = 0; i < cellsCopy.size(); ++i) {
                            final ColumnCell cc = (ColumnCell)cellsCopy.get(i);
                            try {
                                if (!(cc.column instanceof TableCellRefreshListener)) continue;
                                Utils.execSWTThread(new Runnable(){

                                    public void run() {
                                        ((TableCellRefreshListener)((Object)cc.column)).refresh(cc.cell);
                                    }
                                });
                                continue;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        Thread.sleep(100L);
                        TableCellRefresher.this.iterationNumber++;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        this.refresher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addColumnCell(TableColumn column, TableCell cell) {
        ColumnCell cc = new ColumnCell();
        cc.column = column;
        cc.cell = cell;
        List list = this.cells;
        synchronized (list) {
            this.cells.add(cc);
        }
    }

    private int _getRefreshIndex(int refreshEvery100ms, int nbIndices) {
        if (refreshEvery100ms <= 0) {
            return 1;
        }
        if (nbIndices <= 0) {
            return 1;
        }
        return (int)(this.iterationNumber / (long)refreshEvery100ms % (long)nbIndices);
    }

    private static synchronized TableCellRefresher getInstance() {
        if (instance == null) {
            instance = new TableCellRefresher();
        }
        return instance;
    }

    public static void addCell(TableColumn column, TableCell cell) {
        TableCellRefresher.getInstance()._addColumnCell(column, cell);
    }

    public static int getRefreshIndex(int refreshEvery100ms, int nbIndices) {
        return TableCellRefresher.getInstance()._getRefreshIndex(refreshEvery100ms, nbIndices);
    }

    private class ColumnCell {
        TableColumn column;
        TableCell cell;

        private ColumnCell() {
        }
    }
}

