/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.clientid;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ClientIDManagerImpl
implements ClientIDManager {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected static ClientIDManagerImpl singleton = new ClientIDManagerImpl();
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private ClientIDGenerator generator_user_accessor;
    private boolean use_filter;
    private boolean filter_override;
    private ThreadPool thread_pool;
    private int filter_port;

    public static ClientIDManagerImpl getSingleton() {
        return singleton;
    }

    public void setGenerator(ClientIDGenerator _generator, boolean _use_filter) {
        this.checkGenerator(_generator);
        this.generator_user_accessor = _generator;
        this.use_filter = _use_filter;
        if (!this.use_filter) {
            String http_proxy = System.getProperty("http.proxyHost");
            String socks_proxy = System.getProperty("socksProxyHost");
            InetAddress bindIP = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
            if (!(http_proxy != null && http_proxy.trim().length() != 0 || socks_proxy != null && socks_proxy.trim().length() != 0 || bindIP == null || bindIP.isAnyLocalAddress())) {
                int ips = 0;
                try {
                    Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                    while (nis.hasMoreElements()) {
                        NetworkInterface ni = nis.nextElement();
                        Enumeration<InetAddress> addresses = ni.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress address = addresses.nextElement();
                            if (address.isLoopbackAddress()) continue;
                            ++ips;
                        }
                    }
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LOGID, "", e));
                }
                if (ips > 1) {
                    this.filter_override = true;
                    this.use_filter = true;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "ClientIDManager: overriding filter option to support local bind IP"));
                    }
                }
            }
        }
        if (this.use_filter) {
            try {
                this.thread_pool = new ThreadPool("ClientIDManager", 32);
                String connect_timeout = System.getProperty("sun.net.client.defaultConnectTimeout");
                String read_timeout = System.getProperty("sun.net.client.defaultReadTimeout");
                int timeout = Integer.parseInt(connect_timeout) + Integer.parseInt(read_timeout);
                this.thread_pool.setExecutionLimit(timeout);
                final ServerSocket ss = new ServerSocket(0, 1024, InetAddress.getByName("127.0.0.1"));
                this.filter_port = ss.getLocalPort();
                ss.setReuseAddress(true);
                AEThread accept_thread = new AEThread("ClientIDManager::filterloop"){

                    public void runSupport() {
                        long successfull_accepts = 0L;
                        long failed_accepts = 0L;
                        while (true) {
                            try {
                                while (true) {
                                    Socket socket = ss.accept();
                                    ++successfull_accepts;
                                    ClientIDManagerImpl.this.thread_pool.run(new httpFilter(socket));
                                }
                            }
                            catch (Throwable e) {
                                ++failed_accepts;
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + ClientIDManagerImpl.this.filter_port, e));
                                if (failed_accepts <= 100L || successfull_accepts != 0L) continue;
                                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + ClientIDManagerImpl.this.filter_port, "TCP"});
                                ClientIDManagerImpl.this.use_filter = false;
                                return;
                            }
                            break;
                        }
                    }
                };
                accept_thread.setDaemon(true);
                accept_thread.start();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener established on port " + this.filter_port));
                }
            }
            catch (Throwable e) {
                Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.filter_port});
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + this.filter_port, e));
                }
                this.use_filter = false;
            }
        }
    }

    public ClientIDGenerator getGenerator() {
        this.checkGenerator(this.generator_user_accessor);
        return this.generator_user_accessor;
    }

    protected void checkGenerator(ClientIDGenerator gen) {
        ClassLoader cl = gen.getClass().getClassLoader();
        if (cl != null && cl != ClientIDManager.class.getClassLoader()) {
            Debug.out("Generator isn't trusted - " + gen);
            throw new RuntimeException("Generator isn't trusted");
        }
    }

    public byte[] generatePeerID(TOTorrent torrent, boolean for_tracker) throws ClientIDException {
        return this.getGenerator().generatePeerID(new TorrentImpl(torrent), for_tracker);
    }

    public void generateHTTPProperties(Properties properties) throws ClientIDException {
        if (this.use_filter) {
            URL url = (URL)properties.get("URL");
            if (!url.getProtocol().toLowerCase().equals("http")) {
                Logger.log(new LogAlert(false, 3, "ClientIDManager only supports filtering of http, not https"));
                return;
            }
            try {
                String url_str = url.toString();
                String target_host = url.getHost();
                int target_port = url.getPort();
                if (target_port == -1) {
                    target_port = url.getDefaultPort();
                }
                int host_pos = url_str.indexOf(target_host);
                String new_url = url_str.substring(0, host_pos) + "127.0.0.1:" + this.filter_port;
                String rem = url_str.substring(host_pos + target_host.length());
                if (rem.charAt(0) == ':') {
                    rem = rem.substring(("" + target_port).length() + 1);
                }
                int q_pos = rem.indexOf(63);
                new_url = new_url + rem.substring(0, q_pos + 1) + "cid=" + target_host + ":" + target_port + "&" + rem.substring(q_pos + 1);
                properties.put("URL", new URL(new_url));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        } else {
            this.getGenerator().generateHTTPProperties(properties);
        }
    }

    protected class httpFilter
    extends ThreadPoolTask {
        private Socket socket;

        protected httpFilter(Socket _socket) {
            this.socket = _socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSupport() {
            String report_error = null;
            int written = 0;
            try {
                int len;
                String[] lines_out;
                int len2;
                this.setTaskState("reading header");
                InputStream is = this.socket.getInputStream();
                byte[] buffer = new byte[1024];
                String header = "";
                while ((len2 = is.read(buffer)) != -1 && !(header = header + new String(buffer, 0, len2, "ISO-8859-1")).endsWith("\r\n\r\n") && header.indexOf("\r\n\r\n") == -1) {
                }
                ArrayList<String> lines = new ArrayList<String>();
                int pos = 0;
                while (true) {
                    int p1;
                    String line = (p1 = header.indexOf(ClientIDManagerImpl.NL, pos)) == -1 ? header.substring(pos) : header.substring(pos, p1);
                    if ((line = line.trim()).length() > 0) {
                        lines.add(line);
                    }
                    if (p1 == -1) break;
                    pos = p1 + 2;
                }
                String[] lines_in = new String[lines.size()];
                lines.toArray(lines_in);
                String get = lines_in[0];
                int p1 = get.indexOf("?cid=");
                int p2 = get.indexOf("&", p1);
                String cid = get.substring(p1 + 5, p2);
                int p3 = cid.indexOf(":");
                String target_host = cid.substring(0, p3);
                int target_port = Integer.parseInt(cid.substring(p3 + 1));
                for (int i = 1; i < lines_in.length; ++i) {
                    String line = lines_in[i];
                    if (line.toLowerCase().indexOf("host:") == -1) continue;
                    lines_in[i] = "Host: " + target_host + ":" + target_port;
                    break;
                }
                lines_in[0] = get = get.substring(0, p1 + 1) + get.substring(p2 + 1);
                if (ClientIDManagerImpl.this.filter_override) {
                    lines_out = lines_in;
                    Properties p = new Properties();
                    ClientIDManagerImpl.this.getGenerator().generateHTTPProperties(p);
                    String agent = p.getProperty("User-Agent");
                    if (agent != null) {
                        for (int i = 0; i < lines_out.length; ++i) {
                            if (!lines_out[i].toLowerCase().startsWith("user-agent")) continue;
                            lines_out[i] = "User-Agent: " + agent;
                        }
                    }
                } else {
                    lines_out = ClientIDManagerImpl.this.getGenerator().filterHTTP(lines_in);
                }
                String header_out = "";
                for (int i = 0; i < lines_out.length; ++i) {
                    header_out = header_out + lines_out[i] + ClientIDManagerImpl.NL;
                }
                header_out = header_out + ClientIDManagerImpl.NL;
                Socket target = new Socket();
                InetAddress bindIP = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                if (bindIP != null) {
                    target.bind(new InetSocketAddress(bindIP, 0));
                }
                target.connect(new InetSocketAddress(target_host, target_port));
                target.getOutputStream().write(header_out.getBytes("ISO-8859-1"));
                target.getOutputStream().flush();
                InputStream target_is = target.getInputStream();
                while ((len = target_is.read(buffer)) != -1) {
                    this.socket.getOutputStream().write(buffer, 0, len);
                    written += len;
                }
            }
            catch (ClientIDException e) {
                report_error = e.getMessage();
            }
            catch (UnknownHostException e) {
                report_error = "Unknown host '" + e.getMessage() + "'";
            }
            catch (Throwable e) {
            }
            finally {
                if (report_error != null && written == 0) {
                    HashMap<String, String> failure = new HashMap<String, String>();
                    failure.put("failure reason", report_error);
                    try {
                        byte[] x = BEncoder.encode(failure);
                        this.socket.getOutputStream().write(x);
                    }
                    catch (Throwable f) {
                        Debug.printStackTrace(f);
                    }
                }
                try {
                    this.socket.getOutputStream().flush();
                    this.socket.close();
                }
                catch (Throwable f) {}
            }
        }

        public void interruptTask() {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

