/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;

public abstract class InstallablePluginImpl
implements InstallablePlugin {
    private PluginInstallerImpl installer;

    protected InstallablePluginImpl(PluginInstallerImpl _installer) {
        this.installer = _installer;
    }

    public boolean isAlreadyInstalled() {
        PluginInterface pi = this.getAlreadyInstalledPlugin();
        if (pi == null) {
            return false;
        }
        String version = this.getVersion();
        if (version == null || version.length() == 0) {
            return false;
        }
        return Constants.compareVersions(pi.getPluginVersion(), version) >= 0;
    }

    public PluginInterface getAlreadyInstalledPlugin() {
        return this.installer.getAlreadyInstalledPlugin(this.getId());
    }

    public void install(boolean shared) throws PluginException {
        this.installer.install(this, shared);
    }

    public void install(boolean shared, boolean low_noise, final boolean wait_until_done) throws PluginException {
        final AESemaphore sem = new AESemaphore("FPI");
        final PluginException[] error = new PluginException[]{null};
        this.installer.install(new InstallablePlugin[]{this}, shared, low_noise, new PluginInstallerImpl.installListener(){

            public void done() {
                sem.release();
            }

            public void failed(PluginException e) {
                error[0] = e;
                sem.release();
                if (!wait_until_done) {
                    Debug.out("Install failed", e);
                }
            }
        });
        if (wait_until_done) {
            sem.reserve();
            if (error[0] != null) {
                throw error[0];
            }
        }
    }

    public void uninstall() throws PluginException {
        this.installer.uninstall(this);
    }

    public PluginInstaller getInstaller() {
        return this.installer;
    }

    public abstract void addUpdate(UpdateCheckInstance var1, PluginUpdatePlugin var2, Plugin var3, PluginInterface var4);
}

