/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportCipher;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStreamCipher;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransportHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.plugins.messaging.MessageStreamDecoder;
import org.gudy.azureus2.plugins.messaging.MessageStreamEncoder;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.network.TransportException;
import org.gudy.azureus2.plugins.network.TransportFilter;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageStreamDecoderAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageStreamEncoderAdapter;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportCipherImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportFilterImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportImpl;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static ConnectionManagerImpl instance;
    private AzureusCore azureus_core;

    public static synchronized ConnectionManagerImpl getSingleton(AzureusCore core) {
        if (instance == null) {
            instance = new ConnectionManagerImpl(core);
        }
        return instance;
    }

    private ConnectionManagerImpl(AzureusCore _core) {
        this.azureus_core = _core;
    }

    public Connection createConnection(InetSocketAddress remote_address, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        ConnectionEndpoint connection_endpoint = new ConnectionEndpoint(remote_address);
        connection_endpoint.addProtocol(new ProtocolEndpointTCP(remote_address));
        NetworkConnection core_conn = NetworkManager.getSingleton().createConnection(connection_endpoint, new MessageStreamEncoderAdapter(encoder), new MessageStreamDecoderAdapter(decoder), false, false, null);
        return new ConnectionImpl(core_conn, false);
    }

    public int getNATStatus() {
        return this.azureus_core.getGlobalManager().getNATStatus();
    }

    public org.gudy.azureus2.plugins.network.TransportCipher createTransportCipher(String algorithm, int mode, SecretKeySpec key_spec, AlgorithmParameterSpec params) throws TransportException {
        try {
            TransportCipher cipher = new TransportCipher(algorithm, mode, key_spec, params);
            return new TransportCipherImpl(cipher);
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TransportFilter createTransportFilter(Connection connection, org.gudy.azureus2.plugins.network.TransportCipher read_cipher, org.gudy.azureus2.plugins.network.TransportCipher write_cipher) throws TransportException {
        TransportHelper helper;
        TransportHelperFilter hfilter;
        Transport core_transport;
        org.gudy.azureus2.plugins.network.Transport transport = connection.getTransport();
        try {
            core_transport = ((TransportImpl)transport).coreTransport();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        if (core_transport instanceof TCPTransportImpl) {
            hfilter = ((TCPTransportImpl)core_transport).getFilter();
            helper = hfilter != null ? hfilter.getHelper() : new TCPTransportHelper(((TCPTransportImpl)core_transport).getSocketChannel());
        } else {
            if (!(core_transport instanceof UDPTransport)) throw new TransportException("transport type not supported - " + core_transport);
            hfilter = ((UDPTransport)core_transport).getFilter();
            if (hfilter != null) {
                helper = hfilter.getHelper();
            } else {
                helper = ((UDPTransport)core_transport).getFilter().getHelper();
                InetSocketAddress addr = core_transport.getTransportEndpoint().getProtocolEndpoint().getConnectionEndpoint().getNotionalAddress();
                if (connection.isIncoming()) throw new TransportException("udp incoming transport type not supported - " + core_transport);
                try {
                    helper = new UDPTransportHelper(UDPNetworkManager.getSingleton().getConnectionManager(), addr, (UDPTransport)core_transport);
                }
                catch (IOException ioe) {
                    throw new TransportException(ioe);
                }
            }
        }
        TransportHelperFilterStreamCipher core_filter = new TransportHelperFilterStreamCipher(helper, ((TransportCipherImpl)read_cipher).cipher, ((TransportCipherImpl)write_cipher).cipher);
        return new TransportFilterImpl(core_filter);
    }
}

