/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class IntParameterImpl
extends ParameterImpl
implements IntParameter {
    private int defaultValue;
    private boolean limited;
    private int min_value;
    private int max_value;

    public IntParameterImpl(PluginConfigImpl config, String key, String label, int defaultValue) {
        super(config, key, label);
        config.notifyParamExists(this.getKey());
        COConfigurationManager.setIntDefault(this.getKey(), defaultValue);
        this.defaultValue = defaultValue;
        this.limited = false;
    }

    public IntParameterImpl(PluginConfigImpl config, String key, String label, int defaultValue, int min_value, int max_value) {
        this(config, key, label, defaultValue);
        this.min_value = min_value;
        this.max_value = max_value;
        this.limited = true;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public int getValue() {
        return this.config.getUnsafeIntParameter(this.getKey(), this.getDefaultValue());
    }

    public void setValue(int b) {
        this.config.setUnsafeIntParameter(this.getKey(), b);
    }

    public boolean isLimited() {
        return this.limited;
    }

    public int getMinValue() {
        return this.min_value;
    }

    public int getMaxValue() {
        return this.max_value;
    }
}

