/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerDecisionListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateImpl;

public class UpdateCheckInstanceImpl
implements UpdateCheckInstance {
    private static final LogIDs LOGID = LogIDs.CORE;
    private List listeners = new ArrayList();
    private List updates = new ArrayList();
    private List decision_listeners = new ArrayList();
    private AESemaphore sem = new AESemaphore("UpdateCheckInstance");
    private UpdateManager manager;
    private int check_type;
    private String name;
    private UpdatableComponentImpl[] components;
    private UpdateCheckerImpl[] checkers;
    private boolean completed;
    private boolean cancelled;
    private boolean automatic = true;
    private boolean low_noise = false;
    protected AEMonitor this_mon = new AEMonitor("UpdateCheckInstance");

    protected UpdateCheckInstanceImpl(UpdateManager _manager, int _check_type, String _name, UpdatableComponentImpl[] _components) {
        this.manager = _manager;
        this.check_type = _check_type;
        this.name = _name;
        this.components = _components;
        this.checkers = new UpdateCheckerImpl[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            UpdatableComponentImpl comp2 = this.components[i];
            this.checkers[i] = new UpdateCheckerImpl(this, comp2, this.sem);
        }
    }

    public int getType() {
        return this.check_type;
    }

    public String getName() {
        return this.name;
    }

    public void addUpdatableComponent(UpdatableComponent component, boolean mandatory) {
        UpdatableComponentImpl comp2 = new UpdatableComponentImpl(component, mandatory);
        UpdatableComponentImpl[] new_comps = new UpdatableComponentImpl[this.components.length + 1];
        System.arraycopy(this.components, 0, new_comps, 0, this.components.length);
        new_comps[this.components.length] = comp2;
        this.components = new_comps;
        UpdateCheckerImpl checker = new UpdateCheckerImpl(this, comp2, this.sem);
        UpdateCheckerImpl[] new_checkers = new UpdateCheckerImpl[this.checkers.length + 1];
        System.arraycopy(this.checkers, 0, new_checkers, 0, this.checkers.length);
        new_checkers[this.checkers.length] = checker;
        this.checkers = new_checkers;
    }

    public void setAutomatic(boolean a) {
        this.automatic = a;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setLowNoise(boolean a) {
        this.low_noise = a;
    }

    public boolean isLowNoise() {
        return this.low_noise;
    }

    public void start() {
        for (int i = 0; i < this.components.length; ++i) {
            final UpdateCheckerImpl checker = this.checkers[i];
            new AEThread2("UpdatableComponent Checker:" + i, true){

                public void run() {
                    try {
                        checker.getComponent().checkForUpdate(checker);
                    }
                    catch (Throwable e) {
                        checker.reportProgress("Update check failed: " + Debug.getNestedExceptionMessage(e));
                        e.printStackTrace();
                        checker.failed();
                    }
                }
            }.start();
        }
        new AEThread2("UpdatableComponent Completion Waiter", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int i = 0; i < UpdateCheckInstanceImpl.this.components.length; ++i) {
                    UpdateCheckInstanceImpl.this.sem.reserve();
                }
                try {
                    UpdateCheckInstanceImpl.this.this_mon.enter();
                    if (UpdateCheckInstanceImpl.this.cancelled) {
                        return;
                    }
                    UpdateCheckInstanceImpl.this.completed = true;
                }
                finally {
                    UpdateCheckInstanceImpl.this.this_mon.exit();
                }
                boolean mandatory_failed = false;
                for (int i = 0; i < UpdateCheckInstanceImpl.this.checkers.length; ++i) {
                    if (!UpdateCheckInstanceImpl.this.components[i].isMandatory() || !UpdateCheckInstanceImpl.this.checkers[i].getFailed()) continue;
                    mandatory_failed = true;
                    break;
                }
                ArrayList<UpdateImpl> target_updates = new ArrayList<UpdateImpl>();
                if (mandatory_failed) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 3, "Dropping all updates as a mandatory update check failed"));
                    }
                } else {
                    UpdateImpl update;
                    int i;
                    boolean mandatory_only = false;
                    for (i = 0; i < UpdateCheckInstanceImpl.this.updates.size(); ++i) {
                        update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i);
                        if (!update.isMandatory()) continue;
                        mandatory_only = true;
                        break;
                    }
                    for (i = 0; i < UpdateCheckInstanceImpl.this.updates.size(); ++i) {
                        update = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(i);
                        if (update.isMandatory() || !mandatory_only) {
                            target_updates.add(update);
                            continue;
                        }
                        if (!Logger.isEnabled()) continue;
                        Logger.log(new LogEvent(LOGID, 3, "Dropping update '" + update.getName() + "' as non-mandatory and " + "mandatory updates found"));
                    }
                }
                UpdateCheckInstanceImpl.this.updates = target_updates;
                for (int i = 0; i < UpdateCheckInstanceImpl.this.listeners.size(); ++i) {
                    try {
                        ((UpdateCheckInstanceListener)UpdateCheckInstanceImpl.this.listeners.get(i)).complete(UpdateCheckInstanceImpl.this);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateImpl addUpdate(UpdatableComponentImpl comp2, String update_name, String[] desc, String new_version, ResourceDownloader[] downloaders, int restart_required) {
        try {
            this.this_mon.enter();
            UpdateImpl update = new UpdateImpl(this, update_name, desc, new_version, downloaders, comp2.isMandatory(), restart_required);
            this.updates.add(update);
            if (this.cancelled) {
                update.cancel();
            }
            UpdateImpl updateImpl = update;
            return updateImpl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Update[] getUpdates() {
        try {
            this.this_mon.enter();
            Update[] res = new Update[this.updates.size()];
            this.updates.toArray(res);
            Update[] updateArray = res;
            return updateArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public UpdateChecker[] getCheckers() {
        return this.checkers;
    }

    public UpdateInstaller createInstaller() throws UpdateException {
        return this.manager.createInstaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        int i;
        boolean just_do_updates = false;
        try {
            this.this_mon.enter();
            if (this.completed) {
                just_do_updates = true;
            }
            this.cancelled = true;
        }
        finally {
            this.this_mon.exit();
        }
        for (i = 0; i < this.updates.size(); ++i) {
            ((UpdateImpl)this.updates.get(i)).cancel();
        }
        if (!just_do_updates) {
            for (i = 0; i < this.checkers.length; ++i) {
                if (this.checkers[i] == null) continue;
                this.checkers[i].cancel();
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((UpdateCheckInstanceListener)this.listeners.get(i)).cancelled(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public UpdateManager getManager() {
        return this.manager;
    }

    protected Object getDecision(Update update, int decision_type, String decision_name, String decision_description, Object decision_data) {
        for (int i = 0; i < this.decision_listeners.size(); ++i) {
            Object res = ((UpdateManagerDecisionListener)this.decision_listeners.get(i)).decide(update, decision_type, decision_name, decision_description, decision_data);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void addDecisionListener(UpdateManagerDecisionListener l) {
        this.decision_listeners.add(l);
    }

    public void removeDecisionListener(UpdateManagerDecisionListener l) {
        this.decision_listeners.remove(l);
    }

    public void addListener(UpdateCheckInstanceListener l) {
        this.listeners.add(l);
        if (this.completed) {
            l.complete(this);
        } else if (this.cancelled) {
            l.cancelled(this);
        }
    }

    public void removeListener(UpdateCheckInstanceListener l) {
        this.listeners.remove(l);
    }
}

