/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderAlternateImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    protected ResourceDownloader[] delegates;
    protected int max_to_try;
    protected boolean random;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected int current_index;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDAlternate");
    protected long size = -2L;

    public ResourceDownloaderAlternateImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader[] _delegates, int _max_to_try, boolean _random) {
        super(_parent);
        this.delegates = _delegates;
        this.max_to_try = _max_to_try;
        this.random = _random;
        for (int i = 0; i < this.delegates.length; ++i) {
            ((ResourceDownloaderBaseImpl)this.delegates[i]).setParent(this);
        }
        this.max_to_try = this.max_to_try < 0 ? this.delegates.length : Math.min(this.max_to_try, this.delegates.length);
        if (this.random) {
            ArrayList<ResourceDownloader> l = new ArrayList<ResourceDownloader>(Arrays.asList(this.delegates));
            this.delegates = new ResourceDownloader[this.delegates.length];
            for (int i = 0; i < this.delegates.length; ++i) {
                this.delegates[i] = (ResourceDownloader)l.remove((int)(Math.random() * (double)l.size()));
            }
        }
    }

    public String getName() {
        String res = "[";
        for (int i = 0; i < this.delegates.length; ++i) {
            res = res + (i == 0 ? "" : ",") + this.delegates[i].getName();
        }
        return res + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.delegates.length == 0) {
            ResourceDownloaderException error = new ResourceDownloaderException("Alternate download fails - 0 alteratives");
            this.informFailed(error);
            throw error;
        }
        if (this.size != -2L) {
            return this.size;
        }
        try {
            for (int i = 0; i < this.max_to_try; ++i) {
                try {
                    ResourceDownloaderBaseImpl c = ((ResourceDownloaderBaseImpl)this.delegates[i]).getClone(this);
                    this.addReportListener(c);
                    this.size = c.getSize();
                    this.setProperties(c);
                    break;
                }
                catch (ResourceDownloaderException e) {
                    if (i != this.delegates.length - 1) continue;
                    throw e;
                }
            }
        }
        finally {
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            for (int i = 0; i < this.delegates.length; ++i) {
                ((ResourceDownloaderBaseImpl)this.delegates[i]).setSize(this.size);
            }
        }
    }

    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
        for (int i = 0; i < this.delegates.length; ++i) {
            ((ResourceDownloaderBaseImpl)this.delegates[i]).setProperty(name, value);
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloader[] clones = new ResourceDownloader[this.delegates.length];
        for (int i = 0; i < this.delegates.length; ++i) {
            clones[i] = ((ResourceDownloaderBaseImpl)this.delegates[i]).getClone(this);
        }
        ResourceDownloaderAlternateImpl c = new ResourceDownloaderAlternateImpl(parent, clones, this.max_to_try, this.random);
        c.setSize(this.size);
        c.setProperties(this);
        return c;
    }

    public InputStream download() throws ResourceDownloaderException {
        if (this.delegates.length == 0) {
            ResourceDownloaderException error = new ResourceDownloaderException("Alternate download fails - 0 alteratives");
            this.informFailed(error);
            throw error;
        }
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.current_index == this.max_to_try || this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else {
                this.current_downloader = ((ResourceDownloaderBaseImpl)this.delegates[this.current_index]).getClone(this);
                this.informActivity(this.getLogIndent() + "Downloading: " + this.getName());
                ++this.current_index;
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException();
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        if (this.informComplete(data)) {
            this.result = data;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.asyncDownload();
    }
}

