/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.security;

import java.util.Arrays;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;

public class SEPublicKeyImpl
implements SEPublicKey {
    private int type;
    private byte[] encoded;
    private int hashcode;

    public static SEPublicKey decode(byte[] encoded) {
        int type = encoded[0] & 0xFF;
        byte[] x = new byte[encoded.length - 1];
        System.arraycopy(encoded, 1, x, 0, x.length);
        return new SEPublicKeyImpl(type, x);
    }

    protected SEPublicKeyImpl(int _type, byte[] _encoded) {
        this.type = _type;
        this.encoded = _encoded;
        this.hashcode = new HashWrapper(this.encoded).hashCode();
    }

    public int getType() {
        return this.type;
    }

    public byte[] encodePublicKey() {
        byte[] res = new byte[this.encoded.length + 1];
        res[0] = (byte)this.type;
        System.arraycopy(this.encoded, 0, res, 1, this.encoded.length);
        return res;
    }

    public byte[] encodeRawPublicKey() {
        byte[] res = new byte[this.encoded.length];
        System.arraycopy(this.encoded, 0, res, 0, this.encoded.length);
        return res;
    }

    public boolean equals(Object other) {
        if (other instanceof SEPublicKeyImpl) {
            return Arrays.equals(this.encoded, ((SEPublicKeyImpl)other).encoded);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

