/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIInputValidator;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.ControlUtils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.pluginsimpl.AbstractUISWTInputReceiver;

public class SimpleTextEntryWindow
extends AbstractUISWTInputReceiver {
    private Display display;

    public SimpleTextEntryWindow(Display display) {
        this.display = display;
    }

    protected void promptForInput() {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                SimpleTextEntryWindow.this.promptForInput0();
            }
        }, false);
    }

    private void promptForInput0() {
        Combo text_entry;
        Text text_entry_text;
        Combo text_entry_combo;
        int text_entry_flags;
        final Shell shell = ShellFactory.createShell(Utils.findAnyShell(), 67680);
        if (this.title != null) {
            shell.setText(this.title);
        }
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        int width_hint = this.width_hint == -1 ? 330 : this.width_hint;
        Label label = null;
        GridData gridData = null;
        for (int i = 0; i < this.messages.length; ++i) {
            label = new Label((Composite)shell, 0);
            label.setText(this.messages[i]);
            gridData = new GridData();
            gridData.widthHint = width_hint;
            label.setLayoutData((Object)gridData);
        }
        if (this.choices != null) {
            text_entry_flags = 4;
            if (!this.choices_allow_edit) {
                text_entry_flags |= 8;
            }
            text_entry_combo = new Combo((Composite)shell, text_entry_flags);
            text_entry_combo.setItems(this.choices);
            text_entry_text = null;
            text_entry = text_entry_combo;
        } else {
            text_entry_flags = 2048;
            text_entry_flags = this.multiline_mode ? (text_entry_flags |= 0x242) : (text_entry_flags |= 4);
            text_entry_text = new Text((Composite)shell, text_entry_flags);
            text_entry_combo = null;
            text_entry = text_entry_text;
        }
        if (this.preentered_text != null) {
            if (text_entry_text != null) {
                text_entry_text.setText(this.preentered_text);
                if (this.select_preentered_text) {
                    text_entry_text.selectAll();
                }
            } else if (text_entry_combo != null) {
                text_entry_combo.setText(this.preentered_text);
            }
        }
        text_entry.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        int line_height = this.line_height;
        if (line_height == -1) {
            line_height = this.multiline_mode ? 3 : 1;
        }
        gridData = new GridData();
        gridData.widthHint = width_hint;
        if (text_entry_text != null) {
            gridData.minimumHeight = text_entry_text.getLineHeight() * line_height;
        }
        gridData.heightHint = gridData.minimumHeight;
        text_entry.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)shell, 0);
        RowLayout rLayout = new RowLayout();
        rLayout.marginTop = 0;
        rLayout.marginLeft = 0;
        rLayout.marginBottom = 0;
        rLayout.marginRight = 0;
        try {
            rLayout.fill = true;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        rLayout.spacing = ControlUtils.getButtonMargin();
        panel.setLayout((Layout)rLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = Constants.isOSX ? 0x1000008 : 0x1000000;
        panel.setLayoutData((Object)gridData);
        Button ok = SimpleTextEntryWindow.createAlertButton(panel, "Button.ok");
        Button cancel = SimpleTextEntryWindow.createAlertButton(panel, "Button.cancel");
        ok.addListener(13, new Listener(){

            private void showError(String text) {
                String error_title = SimpleTextEntryWindow.this.title;
                if (error_title == null) {
                    error_title = "";
                }
                MessageBox mb = new MessageBox(shell, 33);
                mb.setText(error_title);
                mb.setMessage(text);
                mb.open();
            }

            public void handleEvent(Event event2) {
                try {
                    String validate_result;
                    String entered_data = "";
                    if (text_entry_text != null) {
                        entered_data = text_entry_text.getText();
                    } else if (text_entry_combo != null) {
                        entered_data = text_entry_combo.getText();
                    }
                    if (!SimpleTextEntryWindow.this.maintain_whitespace) {
                        entered_data = entered_data.trim();
                    }
                    if (!SimpleTextEntryWindow.this.allow_empty_input && entered_data.length() == 0) {
                        this.showError(MessageText.getString("UI.cannot_submit_blank_text"));
                        return;
                    }
                    UIInputValidator validator = SimpleTextEntryWindow.this.validator;
                    if (validator != null && (validate_result = validator.validate(entered_data)) != null) {
                        this.showError(MessageText.getString(validate_result));
                        return;
                    }
                    SimpleTextEntryWindow.this.recordUserInput(entered_data);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    SimpleTextEntryWindow.this.recordUserAbort();
                }
                shell.dispose();
            }
        });
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SimpleTextEntryWindow.this.recordUserAbort();
                shell.dispose();
            }
        });
        shell.setDefaultButton(ok);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    SimpleTextEntryWindow.this.recordUserAbort();
                    shell.dispose();
                }
            }
        });
        shell.pack();
        if (text_entry_text != null) {
            Utils.createURLDropTarget((Composite)shell, text_entry_text);
        }
        Utils.centreWindow(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private static Button createAlertButton(Composite panel, String localizationKey) {
        Button button = new Button(panel, 8);
        button.setText(MessageText.getString(localizationKey));
        RowData rData = new RowData();
        rData.width = Math.max(ControlUtils.getDialogButtonMinWidth(), button.computeSize((int)-1, (int)-1).x);
        button.setLayoutData((Object)rData);
        return button;
    }
}

