/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class TrayWindow
implements GlobalManagerListener,
UIUpdatable {
    private static final String ID = "DownloadBasket/TrayWindow";
    GlobalManager globalManager;
    List managers;
    protected AEMonitor managers_mon = new AEMonitor("DownloadBasket/TrayWindow");
    MainWindow main;
    Display display;
    Shell minimized;
    Label label;
    private Menu menu;
    private Rectangle screen;
    private int xPressed;
    private int yPressed;
    private boolean moving;

    public TrayWindow(MainWindow _main) {
        this.managers = new ArrayList();
        this.main = _main;
        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
        Shell mainShell = uif == null ? Utils.findAnyShell() : uif.getMainShell();
        this.display = mainShell.getDisplay();
        this.minimized = ShellFactory.createShell(mainShell, 16384);
        this.minimized.setText("Vuze");
        this.label = new Label((Composite)this.minimized, 0);
        Image img = ImageRepository.getImage("tray");
        this.label.setImage(img);
        final Rectangle bounds = img.getBounds();
        this.label.setSize(bounds.width, bounds.height);
        this.minimized.setSize(bounds.width + 2, bounds.height + 2);
        this.screen = this.display.getClientArea();
        if (!Constants.isOSX) {
            this.minimized.setLocation(this.screen.x + this.screen.width - bounds.width - 2, this.screen.y + this.screen.height - bounds.height - 2);
        } else {
            this.minimized.setLocation(20, 20);
        }
        this.minimized.layout();
        this.minimized.setVisible(false);
        MouseAdapter mListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TrayWindow.this.xPressed = e.x;
                TrayWindow.this.yPressed = e.y;
                TrayWindow.this.moving = true;
            }

            public void mouseUp(MouseEvent e) {
                TrayWindow.this.moving = false;
            }

            public void mouseDoubleClick(MouseEvent e) {
                TrayWindow.this.restore();
            }
        };
        MouseMoveListener mMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (TrayWindow.this.moving) {
                    int dX = TrayWindow.this.xPressed - e.x;
                    int dY = TrayWindow.this.yPressed - e.y;
                    Point currentLoc = TrayWindow.this.minimized.getLocation();
                    int x = currentLoc.x - dX;
                    int y = currentLoc.y - dY;
                    if (x < 10) {
                        x = 0;
                    }
                    if (x > ((TrayWindow)TrayWindow.this).screen.width - (bounds.width + 12)) {
                        x = ((TrayWindow)TrayWindow.this).screen.width - (bounds.width + 2);
                    }
                    if (y < 10) {
                        y = 0;
                    }
                    if (y > ((TrayWindow)TrayWindow.this).screen.height - (bounds.height + 12)) {
                        y = ((TrayWindow)TrayWindow.this).screen.height - (bounds.height + 2);
                    }
                    TrayWindow.this.minimized.setLocation(x, y);
                }
            }
        };
        this.label.addMouseListener((MouseListener)mListener);
        this.label.addMouseMoveListener(mMoveListener);
        this.menu = new Menu((Decorations)this.minimized, 64);
        this.label.setMenu(this.menu);
        MenuItem file_show = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_show, "TrayWindow.menu.show");
        this.menu.setDefaultItem(file_show);
        file_show.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TrayWindow.this.restore();
            }
        });
        new MenuItem(this.menu, 2);
        MenuFactory.addCloseDownloadBarsToMenu(this.menu);
        new MenuItem(this.menu, 2);
        MenuItem file_startalldownloads = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_startalldownloads, "TrayWindow.menu.startalldownloads");
        file_startalldownloads.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TrayWindow.this.globalManager.startAllDownloads();
            }
        });
        MenuItem file_stopalldownloads = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_stopalldownloads, "TrayWindow.menu.stopalldownloads");
        file_stopalldownloads.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.asyncStopAll();
            }
        });
        new MenuItem(this.menu, 2);
        MenuItem file_close = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_close, "TrayWindow.menu.close");
        file_close.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                COConfigurationManager.setParameter("Show Download Basket", false);
            }
        });
        MenuItem file_exit = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)file_exit, "TrayWindow.menu.exit");
        file_exit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TrayWindow.this.main.dispose(false, false);
            }
        });
        Utils.createTorrentDropTarget((Composite)this.minimized, false);
        try {
            this.globalManager = AzureusCoreFactory.getSingleton().getGlobalManager();
            this.globalManager.addListener(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void setVisible(boolean visible) {
        if (visible || !COConfigurationManager.getBooleanParameter("Show Download Basket")) {
            this.minimized.setVisible(visible);
            if (!visible) {
                this.moving = false;
            }
        }
        try {
            if (visible) {
                UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
            } else {
                UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(this);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void dispose() {
        this.minimized.dispose();
    }

    public void restore() {
        UIFunctionsSWT functionsSWT;
        if (!COConfigurationManager.getBooleanParameter("Show Download Basket")) {
            this.minimized.setVisible(false);
        }
        if ((functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
            functionsSWT.bringToFront();
        }
        this.moving = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI() {
        if (this.minimized.isDisposed() || !this.minimized.isVisible()) {
            return;
        }
        StringBuffer toolTip = new StringBuffer();
        String separator = "";
        try {
            this.managers_mon.enter();
            for (int i = 0; i < this.managers.size(); ++i) {
                DownloadManager manager = (DownloadManager)this.managers.get(i);
                DownloadManagerStats stats = manager.getStats();
                String name = manager.getDisplayName();
                String completed = DisplayFormatters.formatPercentFromThousands(stats.getCompleted());
                toolTip.append(separator);
                toolTip.append(name);
                toolTip.append(" -- C: ");
                toolTip.append(completed);
                toolTip.append(", D : ");
                toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataReceiveRate(), stats.getProtocolReceiveRate()));
                toolTip.append(", U : ");
                toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataSendRate(), stats.getProtocolSendRate()));
                separator = "\n";
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadManagerAdded(DownloadManager created) {
        try {
            this.managers_mon.enter();
            this.managers.add(created);
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadManagerRemoved(DownloadManager removed) {
        try {
            this.managers_mon.enter();
            this.managers.remove(removed);
        }
        finally {
            this.managers_mon.exit();
        }
    }

    public void destroyed() {
    }

    public void destroyInitiated() {
    }

    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    public void updateLanguage() {
        MenuFactory.updateMenuText(this.menu);
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public String getUpdateUIName() {
        return ID;
    }
}

