/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.help;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.util.Properties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;

public class AboutWindow {
    static Image image;
    static AEMonitor class_mon;
    private static Shell instance;
    private static Image imgSrc;

    public static void show(final Display display) {
        int w;
        if (instance != null) {
            instance.open();
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(AboutWindow.class.getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/swt/about.properties"));
        }
        catch (Exception e1) {
            Debug.printStackTrace(e1);
            return;
        }
        final Shell window = ShellFactory.createMainShell(Constants.isOSX ? 2144 : 67680);
        Utils.setShellIcon(window);
        window.setText(MessageText.getString("MainWindow.about.title") + " " + "4.0.0.4");
        window.setLayout((Layout)new GridLayout(3, false));
        image = ImageRepository.getImage("azureus_splash");
        int ow = w = AboutWindow.image.getBounds().width;
        if (w > 350) {
            w = 350;
        }
        int h = AboutWindow.image.getBounds().height;
        h = 220;
        imgSrc = new Image((Device)display, w, h);
        GC gc = new GC((Drawable)imgSrc);
        gc.drawImage(image, (w - ow) / 2, 0);
        gc.dispose();
        Image imgGray = new Image((Device)display, ImageRepository.getImage("azureus_splash"), 2);
        gc = new GC((Drawable)imgGray);
        if (Constants.isOSX) {
            gc.drawImage(imgGray, (w - ow) / 2, 0);
        } else {
            gc.copyArea(0, 0, ow, h, (w - ow) / 2, 0);
        }
        gc.dispose();
        Image image2 = new Image((Device)display, w, h);
        gc = new GC((Drawable)image2);
        gc.setBackground(Colors.black);
        gc.fillRectangle(image2.getBounds());
        gc.dispose();
        image = Utils.renderTransparency(display, image2, imgGray, new Point(0, 0), 180);
        image2.dispose();
        imgGray.dispose();
        Group gDevelopers = new Group((Composite)window, 0);
        gDevelopers.setLayout((Layout)new GridLayout());
        Messages.setLanguageText((Widget)gDevelopers, "MainWindow.about.section.developers");
        GridData gridData = new GridData(272);
        gDevelopers.setLayoutData((Object)gridData);
        Label label = new Label((Composite)gDevelopers, 16384);
        label.setText(properties.getProperty("developers"));
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        final Label labelImage = new Label((Composite)window, 0);
        labelImage.setImage(image);
        gridData = new GridData(64);
        labelImage.setLayoutData((Object)gridData);
        Group gTranslators = new Group((Composite)window, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 0;
        gTranslators.setLayout((Layout)gl);
        Messages.setLanguageText((Widget)gTranslators, "MainWindow.about.section.translators");
        gridData = new GridData(272);
        gTranslators.setLayoutData((Object)gridData);
        Text txtTrans = new Text((Composite)gTranslators, 524362);
        txtTrans.setText(properties.getProperty("translators"));
        gridData = new GridData(1808);
        gridData.heightHint = txtTrans.computeSize((int)-1, (int)-1).y + 10;
        txtTrans.setLayoutData((Object)gridData);
        txtTrans.setBackground(display.getSystemColor(22));
        Group gInternet = new Group((Composite)window, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gInternet.setLayout((Layout)gridLayout);
        Messages.setLanguageText((Widget)gInternet, "MainWindow.about.section.internet");
        gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        gInternet.setLayoutData((Object)gridData);
        Group gSys = new Group((Composite)window, 0);
        gSys.setLayout((Layout)new GridLayout());
        Messages.setLanguageText((Widget)gSys, "MainWindow.about.section.system");
        gridData = new GridData(272);
        gridData.verticalSpan = 1;
        gSys.setLayoutData((Object)gridData);
        Text txtSysInfo = new Text((Composite)gSys, 74);
        txtSysInfo.setBackground(display.getSystemColor(22));
        txtSysInfo.setText("Java " + System.getProperty("java.version") + "\n " + System.getProperty("java.vendor") + "\n" + "SWT v" + SWT.getVersion() + ", " + SWT.getPlatform() + "\n" + System.getProperty("os.name") + " v" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + "\n" + Constants.APP_NAME.charAt(0) + "4.0.0.4" + " " + VersionCheckClient.azconst_avail + " " + COConfigurationManager.getStringParameter("ui"));
        gridData = new GridData(1808);
        txtSysInfo.setLayoutData((Object)gridData);
        if (window.getCaret() != null) {
            window.getCaret().setVisible(false);
        }
        String[][] link = new String[][]{{"homepage", "sourceforge", "sourceforgedownloads", "bugreports", "forumdiscussion", "wiki"}, {"http://www.vuze.com", "http://sourceforge.net/projects/azureus/", "http://sourceforge.net/project/showfiles.php?group_id=84122", Constants.isCVSVersion() ? "http://forum.vuze.com/forum.jspa?forumID=4" : "http://sourceforge.net/tracker/?atid=575154&group_id=84122&func=browse", "http://forum.vuze.com/index.jspa", "http://www.azureuswiki.com/index.php/"}};
        for (int i = 0; i < link[0].length; ++i) {
            CLabel linkLabel = new CLabel((Composite)gInternet, 0);
            linkLabel.setText(MessageText.getString("MainWindow.about.internet." + link[0][i]));
            linkLabel.setData((Object)link[1][i]);
            linkLabel.setCursor(Cursors.handCursor);
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            linkLabel.setLayoutData((Object)gridData);
            linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }

                public void mouseDown(MouseEvent arg0) {
                    Utils.launch((String)((CLabel)arg0.widget).getData());
                }
            });
        }
        Listener keyListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        };
        window.addListener(2, keyListener);
        window.pack();
        txtSysInfo.setFocus();
        Utils.centreWindow(window);
        window.open();
        instance = window;
        window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                instance = null;
                AboutWindow.disposeImage();
            }
        });
        AEThread updater = new AEThread("Splash Screen Updater"){

            public void runSupport() {
                if (image == null || image.isDisposed()) {
                    return;
                }
                final boolean[] finished = new boolean[1];
                final int[] x = new int[1];
                final int maxX = AboutWindow.image.getBounds().width;
                final int maxY = AboutWindow.image.getBounds().height;
                while (!finished[0]) {
                    if (image == null || image.isDisposed()) {
                        finished[0] = true;
                        break;
                    }
                    if (display.isDisposed()) {
                        finished[0] = true;
                        break;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (labelImage.isDisposed()) {
                                return;
                            }
                            GC gcImage = new GC((Drawable)labelImage);
                            gcImage.setClipping(x[0], 0, 1, maxY);
                            gcImage.drawImage(imgSrc, 0, 0);
                            gcImage.dispose();
                            x[0] = x[0] + 1;
                            if (x[0] >= maxX) {
                                finished[0] = true;
                                labelImage.setImage(imgSrc);
                            }
                        }
                    });
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        };
        updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeImage() {
        try {
            class_mon.enter();
            ImageRepository.unloadImage("azureus_splash");
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            image = null;
            if (imgSrc != null && !imgSrc.isDisposed()) {
                imgSrc.dispose();
            }
            imgSrc = null;
        }
        finally {
            class_mon.exit();
        }
    }

    static {
        class_mon = new AEMonitor("AboutWindow");
    }
}

