/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.launcher.Launcher;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.utils.UIMagnetHandler;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.ui.common.util.UserAlerts;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.LocaleUtilSWT;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.UIConfigDefaultsSWT;
import org.gudy.azureus2.ui.swt.UISwitcherUtil;
import org.gudy.azureus2.ui.swt.auth.AuthenticatorWindow;
import org.gudy.azureus2.ui.swt.auth.CertificateTrustWindow;
import org.gudy.azureus2.ui.swt.auth.CryptoWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.ui.swt.mainwindow.SplashWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.networks.SWTNetworkSelection;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.updater2.PreUpdateChecker;
import org.gudy.azureus2.ui.swt.updater2.SWTUpdateChecker;

public class Initializer
implements AzureusCoreListener,
IUIIntializer {
    private static final LogIDs LOGID = LogIDs.GUI;
    private AzureusCore azureus_core;
    private GlobalManager gm;
    private StartServer startServer;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private AEMonitor listeners_mon = new AEMonitor("Initializer:l");
    private String[] args;
    private AESemaphore semFilterLoader = new AESemaphore("filter loader");
    private AESemaphore init_task = new AESemaphore("delayed init");
    private int nbTasks = 1;
    private int currentTask = 0;
    private int currentPercent = 0;
    private int lastTaskPercent = 0;

    public Initializer(AzureusCore _azureus_core, StartServer _server, String[] _args) {
        this.azureus_core = _azureus_core;
        this.startServer = _server;
        this.args = _args;
        AEThread filterLoaderThread = new AEThread("filter loader", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    Initializer.this.azureus_core.getIpFilterManager().getIPFilter();
                }
                finally {
                    Initializer.this.semFilterLoader.releaseForever();
                }
            }
        };
        filterLoaderThread.setPriority(1);
        filterLoaderThread.start();
        try {
            SWTThread.createInstance(this);
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean handleStopRestart(boolean restart) {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT != null) {
            return functionsSWT.dispose(restart, true);
        }
        return false;
    }

    public void run() {
        try {
            String uiMode = UISwitcherUtil.openSwitcherWindow(false);
            if (uiMode.equals("az3")) {
                try {
                    Class<?> az3Class = Class.forName("com.aelitis.azureus.ui.swt.Initializer");
                    Constructor<?> constructor = az3Class.getConstructor(AzureusCore.class, Boolean.TYPE, String[].class);
                    IUIIntializer initializer = (IUIIntializer)constructor.newInstance(this.azureus_core, new Boolean(false), this.args);
                    initializer.run();
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            UtilitiesImpl.DelayedTaskImpl delayed_task = UtilitiesImpl.addDelayedTask("SWT Initialisation", new Runnable(){

                public void run() {
                    Initializer.this.init_task.reserve();
                }
            });
            delayed_task.queue();
            new LocaleUtilSWT(this.azureus_core);
            Display display = SWTThread.getInstance().getDisplay();
            new UIMagnetHandler(this.azureus_core);
            UIConfigDefaultsSWT.initialize();
            ImageRepository.loadImagesForSplashWindow(display);
            if (COConfigurationManager.getBooleanParameter("Show Splash", true)) {
                SplashWindow.create(display, this);
            }
            this.setNbTasks(7);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.firstMessageNoI18N");
            Alerts.init();
            final ArrayList logEvents = new ArrayList();
            ILogEventListener logListener = null;
            if (COConfigurationManager.getBooleanParameter("Open Console", false)) {
                logListener = new ILogEventListener(){

                    public void log(LogEvent event2) {
                        logEvents.add(event2);
                    }
                };
                Logger.addListener(logListener);
            }
            final ILogEventListener finalLogListener = logListener;
            ProgressWindow.register(this.azureus_core);
            new SWTNetworkSelection();
            new AuthenticatorWindow();
            new CryptoWindow();
            new CertificateTrustWindow();
            InstallPluginWizard.register(this.azureus_core, display);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.loadingImages");
            ImageRepository.loadImages(display);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.initializeGM");
            this.azureus_core.addListener(this);
            this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                public void componentCreated(AzureusCore core, AzureusCoreComponent comp2) {
                    if (comp2 instanceof GlobalManager) {
                        Initializer.this.gm = (GlobalManager)comp2;
                        Initializer.this.nextTask();
                        Initializer.this.reportCurrentTask(MessageText.getString("splash.initializePlugins"));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void started(AzureusCore core) {
                    boolean main_window_will_report_complete = false;
                    try {
                        if (Initializer.this.gm == null) {
                            return;
                        }
                        new UserAlerts(Initializer.this.gm);
                        Initializer.this.nextTask();
                        IpFilterManager ipFilterManager = Initializer.this.azureus_core.getIpFilterManager();
                        if (ipFilterManager != null) {
                            String s = MessageText.getString("splash.loadIpFilters");
                            do {
                                Initializer.this.reportCurrentTask(s);
                                s = s + ".";
                            } while (!Initializer.this.semFilterLoader.reserve(3000L));
                        }
                        Initializer.this.nextTask();
                        Initializer.this.reportCurrentTaskByKey("splash.initializeGui");
                        Colors.getInstance();
                        Cursors.init();
                        main_window_will_report_complete = true;
                        new MainWindow(core, Initializer.this, logEvents);
                        if (finalLogListener != null) {
                            Logger.removeListener(finalLogListener);
                        }
                        SWTUpdateChecker.initialize();
                        PreUpdateChecker.initialize(core, COConfigurationManager.getStringParameter("ui"));
                        UpdateMonitor.getSingleton(core);
                        Alerts.initComplete();
                        for (int i = 0; i < Initializer.this.args.length; ++i) {
                            try {
                                TorrentOpener.openTorrent(Initializer.this.args[i]);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    finally {
                        if (!main_window_will_report_complete) {
                            Initializer.this.init_task.release();
                        }
                    }
                }

                public void stopping(AzureusCore core) {
                    Alerts.stopInitiated();
                }

                public void stopped(AzureusCore core) {
                }

                public boolean syncInvokeRequired() {
                    return true;
                }

                public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                    return false;
                }

                public boolean stopRequested(AzureusCore _core) throws AzureusCoreException {
                    return Initializer.handleStopRestart(false);
                }

                public boolean restartRequested(AzureusCore core) {
                    return Initializer.handleStopRestart(true);
                }
            });
            this.azureus_core.start();
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Initialization fails:", e));
            this.init_task.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void reportCurrentTask(AzureusCoreOperation operation, String currentTask) {
        if (operation.getOperationType() == 1) {
            this.reportCurrentTask(currentTask);
        }
    }

    public void reportPercent(AzureusCoreOperation operation, int percent) {
        if (operation.getOperationType() == 1) {
            this.reportPercent(percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCurrentTask(String currentTaskString) {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                try {
                    InitializerListener listener = (InitializerListener)iter.next();
                    listener.reportCurrentTask(currentTaskString);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void initializationComplete() {
        this.azureus_core.getPluginManager().firePluginEvent(6);
        new DelayedEvent("SWTInitComplete:delay", 8500L, new AERunnable(){

            public void runSupport() {
                Initializer.this.init_task.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportPercent(int percent) {
        int overallPercent = this.overallPercent(percent);
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                try {
                    InitializerListener listener = (InitializerListener)iter.next();
                    listener.reportPercent(overallPercent);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (overallPercent > 100) {
                this.listeners.clear();
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt(boolean for_restart, boolean close_already_in_progress) throws AzureusCoreException {
        if (this.azureus_core != null && !close_already_in_progress && for_restart) {
            this.azureus_core.checkRestartSupported();
        }
        try {
            Cursors.dispose();
            SWTThread.getInstance().terminate();
        }
        finally {
            block16: {
                try {
                    if (this.azureus_core == null || close_already_in_progress) break block16;
                    try {
                        if (for_restart) {
                            this.azureus_core.restart();
                            break block16;
                        }
                        this.azureus_core.stop();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                finally {
                    if (this.startServer != null) {
                        this.startServer.stopIt();
                    }
                }
            }
        }
    }

    private void setNbTasks(int _nbTasks) {
        this.currentTask = 0;
        this.nbTasks = _nbTasks;
    }

    public void nextTask() {
        ++this.currentTask;
        this.currentPercent = 100 * this.currentTask / this.nbTasks;
        this.reportPercent(0);
    }

    private int overallPercent(int taskPercent) {
        this.lastTaskPercent = taskPercent;
        return this.currentPercent + taskPercent / this.nbTasks;
    }

    private void reportCurrentTaskByKey(String key) {
        this.reportCurrentTask(MessageText.getString(key));
    }

    public void increaseProgress() {
        if (this.lastTaskPercent < 100) {
            this.reportPercent(this.lastTaskPercent + 1);
        }
    }

    public void abortProgress() {
        this.currentTask = this.nbTasks;
        this.nextTask();
        this.reportPercent(101);
    }

    public static void main(String[] args) {
        if (Launcher.checkAndLaunch(Initializer.class, args)) {
            return;
        }
        System.err.println("Shouldn't you be starting with org.gudy.azureus2.ui.swt.Main?");
        AzureusCore core = AzureusCoreFactory.create();
        new Initializer(core, null, args);
    }
}

