/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.IconBar;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.OpenTorrentWindow;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.TrayWindow;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.associations.AssociationChecker;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateShell;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;
import org.gudy.azureus2.ui.swt.mainwindow.MainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.mainwindow.UIFunctionsImpl;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.sharing.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.DetailedListView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.PeerSuperView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindow
extends AERunnable
implements ParameterListener,
IconBarEnabler,
AEDiagnosticsEvidenceGenerator,
ObfusticateShell,
IMainWindow {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static MainWindow window;
    private Initializer initializer;
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    public static boolean isAlreadyDead;
    public static boolean isDisposeFromListener;
    private Display display;
    private Composite parent;
    private Shell shell;
    private IMainMenu mainMenu;
    private IconBar iconBar;
    private Composite folder;
    private MainStatusBar mainStatusBar;
    private TrayWindow downloadBasket;
    private SystemTraySWT systemTraySWT;
    private HashMap downloadViews;
    private AEMonitor downloadViews_mon = new AEMonitor("MainWindow:dlviews");
    private Item mytorrents;
    private Item detailed_list;
    private Item all_peers;
    private Item my_tracker_tab;
    private Item my_shares_tab;
    private Item stats_tab;
    private Item console;
    private Item multi_options_tab;
    private Item config;
    private ConfigView config_view;
    protected AEMonitor this_mon = new AEMonitor("MainWindow");
    private UISWTInstanceImpl uiSWTInstanceImpl = null;
    private ArrayList events;
    private UIFunctionsSWT uiFunctions;
    private boolean bIconBarEnabled = false;
    private boolean bShowMainWindow;
    private boolean bSettingVisibility = false;
    private Tab mainTabSet;
    Map pluginTabs = new HashMap();

    public MainWindow(AzureusCore _azureus_core, Initializer _initializer, ArrayList events) {
        this.bShowMainWindow = true;
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MainWindow start"));
            }
            AEDiagnostics.addEvidenceGenerator(this);
            this.azureus_core = _azureus_core;
            this.globalManager = this.azureus_core.getGlobalManager();
            this.initializer = _initializer;
            this.display = SWTThread.getInstance().getDisplay();
            window = this;
            this.events = events;
            this.display.asyncExec((Runnable)this);
        }
        catch (AzureusCoreException e) {
            Debug.printStackTrace(e);
        }
    }

    public MainWindow(AzureusCore _azureus_core, Initializer _initializer, Shell shell, Composite parent, UISWTInstanceImpl swtinstance) {
        this.shell = shell;
        this.parent = parent;
        this.bShowMainWindow = true;
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MainWindow start"));
            }
            AEDiagnostics.addEvidenceGenerator(this);
            this.azureus_core = _azureus_core;
            this.globalManager = this.azureus_core.getGlobalManager();
            this.initializer = _initializer;
            this.display = SWTThread.getInstance().getDisplay();
            window = this;
            this.uiSWTInstanceImpl = swtinstance;
        }
        catch (AzureusCoreException e) {
            Debug.printStackTrace(e);
        }
    }

    public MainWindow() {
        this.bShowMainWindow = true;
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MainWindow start"));
            }
            AEDiagnostics.addEvidenceGenerator(this);
            this.azureus_core = AzureusCoreFactory.getSingleton();
            this.globalManager = this.azureus_core.getGlobalManager();
            this.display = SWTThread.getInstance().getDisplay();
            window = this;
        }
        catch (AzureusCoreException e) {
            Debug.printStackTrace(e);
        }
    }

    public void init(Composite parent, UISWTInstanceImpl swtInstance) {
        this.parent = parent;
        this.shell = parent.getShell();
        this.uiSWTInstanceImpl = swtInstance;
    }

    public void setShowMainWindow(boolean b) {
        this.bShowMainWindow = b;
    }

    public void runSupport() {
        try {
            FormData formData;
            this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (this.uiFunctions == null) {
                this.uiFunctions = new UIFunctionsImpl(this);
                UIFunctionsManager.setUIFunctions(this.uiFunctions);
            } else {
                this.uiFunctions = new UIFunctionsImpl(this);
            }
            this.globalManager.loadExistingTorrentsNow(true);
            COConfigurationManager.addParameterListener("config.style.useSIUnits", (ParameterListener)this);
            this.mytorrents = null;
            this.my_tracker_tab = null;
            this.console = null;
            this.config = null;
            this.config_view = null;
            this.downloadViews = new HashMap();
            Label attachToTopOf = null;
            Label controlAboveFolder = null;
            Composite controlBelowFolder = null;
            if (this.shell == null) {
                this.shell = new Shell(this.display, 3280);
                this.shell.setData("class", (Object)this);
                this.shell.setText(Constants.APP_NAME);
                Utils.setShellIcon(this.shell);
                if (this.parent == null) {
                    this.parent = this.shell;
                }
                ShellManager.sharedManager().addWindow(this.shell);
                this.mainMenu = new MainMenu(this.shell);
                FormLayout mainLayout = new FormLayout();
                mainLayout.marginHeight = 0;
                mainLayout.marginWidth = 0;
                try {
                    mainLayout.spacing = 0;
                }
                catch (NoSuchFieldError e) {
                    // empty catch block
                }
                this.shell.setLayout((Layout)mainLayout);
                Utils.linkShellMetricsToConfig(this.shell, "window");
                this.shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event2) {
                        if (!isAlreadyDead) {
                            isDisposeFromListener = true;
                            if (MainWindow.this.shell != null) {
                                MainWindow.this.shell.removeDisposeListener((DisposeListener)this);
                                MainWindow.this.dispose(false, false);
                            }
                            isAlreadyDead = true;
                        }
                    }
                });
                this.shell.addShellListener((ShellListener)new ShellAdapter(){

                    public void shellClosed(ShellEvent event2) {
                        if (MainWindow.this.bSettingVisibility) {
                            return;
                        }
                        if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                            MainWindow.this.minimizeToTray(event2);
                        } else {
                            event2.doit = MainWindow.this.dispose(false, false);
                        }
                    }

                    public void shellIconified(ShellEvent event2) {
                        if (MainWindow.this.bSettingVisibility) {
                            return;
                        }
                        if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray")) {
                            MainWindow.this.minimizeToTray(event2);
                        }
                    }

                    public void shellDeiconified(ShellEvent e) {
                        if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled")) {
                            MainWindow.this.shell.setVisible(false);
                            if (PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                                MainWindow.this.shell.setVisible(true);
                            }
                        }
                    }
                });
                Label separator = new Label(this.parent, 258);
                formData = new FormData();
                formData.top = new FormAttachment(0, 0);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                separator.setLayoutData((Object)formData);
                attachToTopOf = separator;
                this.mainStatusBar = new MainStatusBar();
                Composite statusBar = this.mainStatusBar.initStatusBar(this.azureus_core, this.globalManager, this.display, (Composite)this.shell);
                controlAboveFolder = attachToTopOf;
                controlBelowFolder = statusBar;
            }
            try {
                Utils.createTorrentDropTarget(this.parent, true);
            }
            catch (SWTError e) {
                Logger.log(new LogEvent(LOGID, 1, "Drag and Drop not available: " + e.getMessage()));
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
            }
            this.mainTabSet = new Tab(this);
            this.folder = this.mainTabSet.createFolderWidget(this.parent);
            formData = new FormData();
            formData.top = controlAboveFolder == null ? new FormAttachment(0, 0) : new FormAttachment(controlAboveFolder);
            formData.bottom = controlBelowFolder == null ? new FormAttachment(100, 0) : new FormAttachment(controlBelowFolder);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.folder.setLayoutData((Object)formData);
            this.display.addFilter(1, new Listener(){

                public void handleEvent(Event event2) {
                    Control focus_control = MainWindow.this.display.getFocusControl();
                    if (focus_control != null && focus_control.getShell() != MainWindow.this.shell) {
                        return;
                    }
                    int key = event2.character;
                    if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                        key += 96;
                    }
                    if (key == 108 && (event2.stateMask & SWT.MOD1) != 0) {
                        OpenTorrentWindow.invokeURLPopup(MainWindow.this.shell, MainWindow.this.globalManager);
                        event2.doit = false;
                    }
                }
            });
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Initializing GUI complete"));
            }
            this.globalManager.addListener(new GlobalManagerAdapter(){

                public void downloadManagerAdded(DownloadManager dm) {
                    MainWindow.this.downloadManagerAdded(dm);
                }

                public void downloadManagerRemoved(DownloadManager dm) {
                    MainWindow.this.downloadManagerRemoved(dm);
                }
            });
            PluginManager plugin_manager = this.azureus_core.getPluginManager();
            plugin_manager.firePluginEvent(1);
            if (!COConfigurationManager.getBooleanParameter("Wizard Completed")) {
                new ConfigureWizard(this.getAzureusCore(), true);
            }
            plugin_manager.firePluginEvent(2);
            if (this.uiSWTInstanceImpl == null) {
                TableColumnCreator.initCoreColumns();
                this.uiSWTInstanceImpl = new UISWTInstanceImpl(this.azureus_core);
                this.uiSWTInstanceImpl.init(this.initializer);
                if (isAlreadyDead) {
                    return;
                }
                this.postPluginSetup(0, 50);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.showMainWindow();
    }

    public void postPluginSetup(int delay, int delayInc) {
        if (this.initializer != null) {
            this.initializer.reportCurrentTask(MessageText.getString("splash.openViews"));
            this.initializer.nextTask();
        }
        if (!Constants.isSafeMode && this.azureus_core.getTrackerHost().getTorrents().length > 0) {
            Utils.execSWTThreadLater(delay += delayInc, new Runnable(){

                public void run() {
                    MainWindow.this.showMyTracker();
                }
            });
        }
        PluginManager plugin_manager = this.azureus_core.getPluginManager();
        PluginInterface default_pi = plugin_manager.getDefaultPluginInterface();
        try {
            final ShareManager share_manager = default_pi.getShareManager();
            default_pi.addListener(new PluginListener(){

                public void initializationComplete() {
                }

                public void closedownInitiated() {
                    int share_count = share_manager.getShares().length;
                    if (share_count != COConfigurationManager.getIntParameter("GUI_SWT_share_count_at_close")) {
                        COConfigurationManager.setParameter("GUI_SWT_share_count_at_close", share_count);
                    }
                }

                public void closedownComplete() {
                }
            });
            if (share_manager.getShares().length > 0 || COConfigurationManager.getIntParameter("GUI_SWT_share_count_at_close") > 0) {
                Utils.execSWTThreadLater(delay += delayInc, new Runnable(){

                    public void run() {
                        MainWindow.this.showMyShares();
                    }
                });
            }
        }
        catch (ShareException e) {
            Debug.out(e);
        }
        if (!Constants.isSafeMode && COConfigurationManager.getBooleanParameter("Open MyTorrents")) {
            Utils.execSWTThreadLater(delay += delayInc, new Runnable(){

                public void run() {
                    MainWindow.this.showMyTorrents();
                }
            });
        }
        new ProgressWindow();
        if (!Constants.isSafeMode && COConfigurationManager.getBooleanParameter("Open Console")) {
            Utils.execSWTThreadLater(delay += delayInc, new Runnable(){

                public void run() {
                    MainWindow.this.showConsole();
                }
            });
        }
        this.events = null;
        if (Constants.isSafeMode || COConfigurationManager.getBooleanParameter("Open Config")) {
            Utils.execSWTThreadLater(delay += delayInc, new Runnable(){

                public void run() {
                    MainWindow.this.showConfig();
                }
            });
        }
        if (!Constants.isSafeMode && COConfigurationManager.getBooleanParameter("Open Stats On Start")) {
            Utils.execSWTThreadLater(delay += delayInc, new Runnable(){

                public void run() {
                    MainWindow.this.showStats();
                }
            });
        }
        if (!Constants.isSafeMode && COConfigurationManager.getBooleanParameter("Open Transfer Bar On Start")) {
            Utils.execSWTThreadLater(delay += delayInc, new Runnable(){

                public void run() {
                    MainWindow.this.uiFunctions.showGlobalTransferBar();
                }
            });
        }
        COConfigurationManager.addAndFireParameterListener("IconBar.enabled", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainWindow.this.setIconBarEnabled(COConfigurationManager.getBooleanParameter(parameterName));
            }
        });
        if (this.initializer != null) {
            this.initializer.abortProgress();
        }
    }

    protected boolean getIconBarEnabled() {
        return this.bIconBarEnabled;
    }

    protected void setIconBarEnabled(boolean enabled) {
        if (enabled == this.bIconBarEnabled || this.shell.isDisposed()) {
            return;
        }
        this.bIconBarEnabled = enabled;
        COConfigurationManager.setParameter("IconBar.enabled", this.bIconBarEnabled);
        if (this.bIconBarEnabled) {
            try {
                this.iconBar = new IconBar(this.parent);
                this.iconBar.setCurrentEnabler(this);
                Composite cIconBar = this.iconBar.getComposite();
                FormData folderLayoutData = (FormData)this.folder.getLayoutData();
                FormData formData = new FormData();
                formData.top = folderLayoutData.top != null && folderLayoutData.top.control != null ? new FormAttachment(folderLayoutData.top.control) : new FormAttachment(0, 0);
                folderLayoutData.top = new FormAttachment((Control)cIconBar);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                this.iconBar.setLayoutData(formData);
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Creating Icon Bar", e));
            }
        } else if (this.iconBar != null) {
            try {
                FormData folderLayoutData = (FormData)this.folder.getLayoutData();
                FormData iconBarLayoutData = (FormData)this.iconBar.getComposite().getLayoutData();
                folderLayoutData.top = iconBarLayoutData.top != null && iconBarLayoutData.top.control != null ? new FormAttachment(iconBarLayoutData.top.control) : new FormAttachment(0, 0);
                this.iconBar.delete();
                this.iconBar = null;
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Removing Icon Bar", e));
            }
        }
        this.shell.layout(true, true);
    }

    private void showMainWindow() {
        boolean bStartMinimize;
        COConfigurationManager.addAndFireParameterListener("Show Download Basket", this);
        if (!this.bShowMainWindow) {
            return;
        }
        boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray") && (!Constants.isOSX || SWT.getVersion() > 3300);
        boolean bPassworded = COConfigurationManager.getBooleanParameter("Password enabled");
        boolean bl = bStartMinimize = bEnableTray && (bPassworded || COConfigurationManager.getBooleanParameter("Start Minimized"));
        if (!bStartMinimize) {
            this.shell.layout();
            this.shell.open();
            if (!Constants.isOSX) {
                this.shell.forceActive();
            }
        } else if (Constants.isOSX) {
            this.shell.setMinimized(true);
            this.shell.setVisible(true);
        }
        if (bEnableTray) {
            try {
                this.systemTraySWT = new SystemTraySWT();
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (bStartMinimize) {
                this.minimizeToTray(null);
            } else if (bPassworded) {
                this.minimizeToTray(null);
                this.setVisible(true, true);
            }
        }
        if (this.initializer != null) {
            this.initializer.initializationComplete();
        }
        this.checkForWhatsNewWindow();
        AssociationChecker.checkAssociations();
        this.azureus_core.triggerLifeCycleComponentCreated(this.uiFunctions);
    }

    protected void showMyTracker() {
        if (this.my_tracker_tab == null) {
            this.my_tracker_tab = this.mainTabSet.createTabItem(new MyTrackerView(this.azureus_core), true);
            this.mainTabSet.getView(this.my_tracker_tab).getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.my_tracker_tab = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.my_tracker_tab);
            this.refreshIconBar();
            this.refreshTorrentMenu();
        }
    }

    protected void showMyShares() {
        if (this.my_shares_tab == null) {
            this.my_shares_tab = this.mainTabSet.createTabItem(new MySharesView(this.azureus_core), true);
            this.mainTabSet.getView(this.my_shares_tab).getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.my_shares_tab = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.my_shares_tab);
            this.refreshIconBar();
            this.refreshTorrentMenu();
        }
    }

    protected void showMyTorrents() {
        if (this.mytorrents == null) {
            MyTorrentsSuperView view = new MyTorrentsSuperView(this.azureus_core);
            this.mytorrents = this.mainTabSet.createTabItem(view, true);
            this.mainTabSet.getView(this.mytorrents).getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.mytorrents = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.mytorrents);
        }
        this.refreshIconBar();
        this.refreshTorrentMenu();
    }

    protected void showDetailedListView() {
        if (this.detailed_list == null) {
            DetailedListView view = new DetailedListView(this.azureus_core);
            this.detailed_list = this.mainTabSet.createTabItem(view, true);
            this.mainTabSet.getView(this.detailed_list).getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.detailed_list = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.detailed_list);
        }
        this.refreshIconBar();
        this.refreshTorrentMenu();
    }

    protected void showAllPeersView() {
        if (this.all_peers == null) {
            PeerSuperView view = new PeerSuperView(this.azureus_core.getGlobalManager());
            this.all_peers = this.mainTabSet.createTabItem(view, true);
            this.mainTabSet.getView(this.all_peers).getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.all_peers = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.all_peers);
        }
        this.refreshIconBar();
        this.refreshTorrentMenu();
    }

    protected void showMultiOptionsView(DownloadManager[] managers) {
        if (this.multi_options_tab != null) {
            this.multi_options_tab.dispose();
        }
        TorrentOptionsView view = new TorrentOptionsView(managers);
        this.multi_options_tab = this.mainTabSet.createTabItem(view, true);
        view.getComposite().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MainWindow.this.multi_options_tab = null;
            }
        });
        this.refreshIconBar();
        this.refreshTorrentMenu();
    }

    private void minimizeToTray(ShellEvent event2) {
        if (event2 != null) {
            event2.doit = false;
        }
        COConfigurationManager.setParameter("window.maximized", this.shell.getMaximized());
        this.shell.setVisible(false);
        if (this.downloadBasket != null) {
            this.downloadBasket.setVisible(true);
        }
        MiniBarManager.getManager().setAllVisible(true);
    }

    private void updateComponents() {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.refreshStatusText();
        }
        if (this.mainTabSet != null) {
            this.mainTabSet.update();
        }
    }

    private void downloadManagerAdded(DownloadManager created) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(downloadManager)) {
                this.mainTabSet.setFocus((Item)this.downloadViews.get(downloadManager));
                this.refreshIconBar();
                this.refreshTorrentMenu();
            } else {
                Item tab = this.openPluginView(null, "DMView", new ManagerView(), downloadManager, true, true);
                this.downloadViews.put(downloadManager, tab);
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            this.downloadViews.remove(downloadManager);
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadManagerRemoved(DownloadManager removed) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(removed)) {
                final Item tab = (Item)this.downloadViews.get(removed);
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (MainWindow.this.display == null || MainWindow.this.display.isDisposed()) {
                            return;
                        }
                        MainWindow.this.mainTabSet.dispose(tab);
                    }
                });
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    protected Display getDisplay() {
        return this.display;
    }

    protected Shell getShell() {
        return this.shell;
    }

    public void setVisible(final boolean visible, boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                block17: {
                    MainWindow.this.bSettingVisibility = true;
                    try {
                        int i;
                        Shell[] shells;
                        boolean currentlyVisible;
                        boolean bl = currentlyVisible = MainWindow.this.shell.getVisible() && !MainWindow.this.shell.getMinimized();
                        if (visible && !currentlyVisible && COConfigurationManager.getBooleanParameter("Password enabled", false) && !PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                            MainWindow.this.shell.setVisible(false);
                            return;
                        }
                        ArrayList<Shell> wasVisibleList = null;
                        boolean bHideAndShow = false;
                        if (bHideAndShow) {
                            wasVisibleList = new ArrayList<Shell>();
                            try {
                                MainWindow.this.shell.setMinimized(true);
                                shells = MainWindow.this.shell.getDisplay().getShells();
                                for (i = 0; i < shells.length; ++i) {
                                    if (!shells[i].isVisible()) continue;
                                    wasVisibleList.add(shells[i]);
                                    shells[i].setVisible(false);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (visible) {
                            MainWindow.this.shell.setMinimized(false);
                            if (!currentlyVisible && COConfigurationManager.getBooleanParameter("window.maximized")) {
                                MainWindow.this.shell.setMaximized(true);
                            }
                        } else {
                            COConfigurationManager.setParameter("window.maximized", MainWindow.this.shell.getMaximized());
                        }
                        MainWindow.this.shell.setVisible(visible);
                        if (!visible) break block17;
                        if (MainWindow.this.downloadBasket != null) {
                            MainWindow.this.downloadBasket.setVisible(false);
                            MainWindow.this.downloadBasket.setMoving(false);
                        }
                        MainWindow.this.shell.forceActive();
                        if (!bHideAndShow) break block17;
                        try {
                            shells = MainWindow.this.shell.getDisplay().getShells();
                            for (i = 0; i < shells.length; ++i) {
                                if (shells[i] == MainWindow.this.shell) continue;
                                if (wasVisibleList.contains(shells[i])) {
                                    shells[i].setVisible(visible);
                                }
                                shells[i].setFocus();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    finally {
                        MainWindow.this.bSettingVisibility = false;
                    }
                }
            }
        });
    }

    protected boolean isVisible() {
        return this.shell.isVisible();
    }

    public boolean dispose(final boolean for_restart, final boolean close_already_in_progress) {
        return Utils.execSWTThreadWithBool("MainWindow.dispose", new AERunnableBoolean(){

            public boolean runSupport() {
                return MainWindow.this._dispose(for_restart, close_already_in_progress);
            }
        });
    }

    private boolean _dispose(boolean for_restart, boolean close_already_in_progress) {
        AllTransfersBar transfer_bar;
        if (isAlreadyDead) {
            return true;
        }
        if (!UIExitUtilsSWT.canClose(this.globalManager, for_restart)) {
            return false;
        }
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        if ((transfer_bar = AllTransfersBar.getBarIfOpen(AzureusCoreFactory.getSingleton().getGlobalManager())) != null) {
            transfer_bar.forceSaveLocation();
        }
        this.mainTabSet.closeAllTabs();
        isAlreadyDead = true;
        if (this.initializer != null) {
            this.initializer.stopIt(for_restart, close_already_in_progress);
        }
        if (!this.shell.isDisposed() && !isDisposeFromListener) {
            this.shell.dispose();
        }
        COConfigurationManager.removeParameterListener("config.style.useSIUnits", this);
        COConfigurationManager.removeParameterListener("Show Download Basket", this);
        UIExitUtilsSWT.uiShutdown();
        return true;
    }

    protected GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    protected static MainWindow getWindow() {
        return window;
    }

    protected TrayWindow getTray() {
        return this.downloadBasket;
    }

    protected Item openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus, boolean useCoreDS) {
        UISWTViewImpl view = null;
        try {
            view = new UISWTViewImpl(sParentID, sViewID, l);
        }
        catch (Exception e) {
            Item tab = (Item)this.pluginTabs.get(sViewID);
            if (tab != null) {
                this.mainTabSet.setFocus(tab);
            }
            return tab;
        }
        view.setUseCoreDataSource(useCoreDS);
        view.dataSourceChanged(dataSource);
        Item tab = this.mainTabSet.createTabItem(view, bSetFocus);
        this.pluginTabs.put(sViewID, tab);
        return tab;
    }

    protected void closePluginViews(String sViewID) {
        if (this.mainTabSet != null) {
            this.mainTabSet.closePluginViews(sViewID);
        }
    }

    protected UISWTView[] getPluginViews() {
        IView[] allViews = this.mainTabSet.getAllViews();
        ArrayList<IView> views = new ArrayList<IView>();
        for (int i = 0; i < allViews.length; ++i) {
            IView view = allViews[i];
            if (!(view instanceof UISWTViewImpl)) continue;
            views.add(view);
        }
        return views.toArray(new UISWTView[0]);
    }

    protected void openPluginView(final AbstractIView view, final String name) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Item tab = (Item)MainWindow.this.pluginTabs.get(name);
                if (tab != null) {
                    MainWindow.this.mainTabSet.setFocus(tab);
                } else {
                    tab = MainWindow.this.mainTabSet.createTabItem(view, true);
                    MainWindow.this.pluginTabs.put(name, tab);
                }
            }
        });
    }

    protected void closePluginView(IView view) {
        Item tab = this.mainTabSet.getTab(view);
        if (tab != null) {
            this.mainTabSet.closed(tab);
        }
    }

    public void removeActivePluginView(String view_name) {
        this.pluginTabs.remove(view_name);
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Show Download Basket")) {
            if (COConfigurationManager.getBooleanParameter("Show Download Basket")) {
                if (this.downloadBasket == null) {
                    this.downloadBasket = new TrayWindow(this);
                    this.downloadBasket.setVisible(true);
                }
            } else if (this.downloadBasket != null) {
                this.downloadBasket.setVisible(false);
                this.downloadBasket = null;
            }
        }
        if (parameterName.equals("config.style.useSIUnits")) {
            this.updateComponents();
        }
    }

    public boolean isEnabled(String itemKey) {
        UISWTViewEventListener eventListener;
        if (itemKey.equals("open")) {
            return true;
        }
        if (itemKey.equals("new")) {
            return true;
        }
        IView currentView = this.getCurrentView();
        if (currentView instanceof UISWTViewImpl && (eventListener = ((UISWTViewImpl)currentView).getEventListener()) instanceof IconBarEnabler) {
            return ((IconBarEnabler)((Object)eventListener)).isEnabled(itemKey);
        }
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
        UISWTViewEventListener eventListener;
        if (itemKey.equals("open")) {
            TorrentOpener.openTorrentWindow();
            return;
        }
        if (itemKey.equals("new")) {
            new NewTorrentWizard(this.getAzureusCore(), this.display);
            return;
        }
        IView currentView = this.getCurrentView();
        if (currentView instanceof UISWTViewImpl && (eventListener = ((UISWTViewImpl)currentView).getEventListener()) instanceof IconBarEnabler) {
            ((IconBarEnabler)((Object)eventListener)).itemActivated(itemKey);
            return;
        }
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    IView getCurrentView() {
        if (this.mainTabSet != null) {
            return this.mainTabSet.getCurrentView();
        }
        return null;
    }

    protected void refreshIconBar() {
        if (this.iconBar != null) {
            this.iconBar.setCurrentEnabler(this);
        }
    }

    protected void refreshTorrentMenu() {
        MenuItem torrentItem;
        boolean detailed_view;
        DownloadManager[] dm;
        if (this.mainMenu == null) {
            return;
        }
        TableViewSWT tv = null;
        IView currentView = this.getCurrentView();
        if (currentView instanceof ManagerView) {
            dm = new DownloadManager[]{((ManagerView)((Object)currentView)).getDownload()};
            detailed_view = true;
        } else if (currentView instanceof UISWTView) {
            UISWTView current_swt_view = (UISWTView)((Object)currentView);
            Object core_object = PluginCoreUtils.convert(current_swt_view.getDataSource(), true);
            if (core_object instanceof DownloadManager) {
                dm = new DownloadManager[]{(DownloadManager)core_object};
                detailed_view = "DMView".equals(current_swt_view.getViewID());
            } else {
                dm = null;
                detailed_view = false;
            }
        } else if (currentView instanceof MyTorrentsSuperView) {
            dm = ((MyTorrentsSuperView)this.getCurrentView()).getSelectedDownloads();
            detailed_view = false;
        } else {
            dm = null;
            detailed_view = false;
        }
        if (currentView instanceof TableViewTab) {
            tv = ((TableViewTab)currentView).getTableView();
        }
        if (null != (torrentItem = MenuFactory.findMenuItem(this.mainMenu.getMenu("menu.bar"), "MainWindow.menu.torrent"))) {
            final DownloadManager[] dm_final = dm;
            final TableViewSWT tv_final = tv;
            final boolean detailed_view_final = detailed_view;
            Utils.execSWTThread((Runnable)new AERunnable(){

                public void runSupport() {
                    if (null == dm_final) {
                        torrentItem.setEnabled(false);
                    } else {
                        torrentItem.setData("downloads", (Object)dm_final);
                        torrentItem.setData("TableView", (Object)tv_final);
                        torrentItem.setData("is_detailed_view", (Object)detailed_view_final);
                        torrentItem.setEnabled(true);
                    }
                }
            }, true);
        }
    }

    protected void close() {
        this.getShell().close();
    }

    protected void closeViewOrWindow() {
        if (this.getCurrentView() != null) {
            this.mainTabSet.closeCurrent();
        } else {
            this.close();
        }
    }

    protected ConfigView showConfig() {
        if (this.config == null) {
            this.config_view = new ConfigView(this.azureus_core);
            this.config = this.mainTabSet.createTabItem(this.config_view, true);
            this.config_view.getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.config = null;
                    MainWindow.this.config_view = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.config);
            this.refreshIconBar();
            this.refreshTorrentMenu();
        }
        return this.config_view;
    }

    protected boolean showConfig(String id) {
        boolean has_rebuilt = this.config_view == null;
        this.showConfig();
        if (this.config_view == null) {
            return false;
        }
        if (id == null) {
            return true;
        }
        boolean result = this.config_view.selectSection(id);
        if (!result && !has_rebuilt) {
            this.config.dispose();
            if (this.config_view != null) {
                throw new RuntimeException("something has gone wrong");
            }
            return this.showConfig(id);
        }
        return result;
    }

    protected void showConsole() {
        if (this.console == null) {
            this.console = this.mainTabSet.createTabItem(new LoggerView(this.events), true);
            this.mainTabSet.getView(this.console).getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.console = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.console);
            this.refreshIconBar();
            this.refreshTorrentMenu();
        }
    }

    protected void showStats() {
        if (this.stats_tab == null) {
            this.stats_tab = this.mainTabSet.createTabItem(new StatsView(this.globalManager, this.azureus_core), true);
            this.mainTabSet.getView(this.stats_tab).getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.stats_tab = null;
                }
            });
        } else {
            this.mainTabSet.setFocus(this.stats_tab);
            this.refreshIconBar();
            this.refreshTorrentMenu();
        }
    }

    protected void showStatsDHT() {
        this.showStats();
        if (this.stats_tab == null) {
            return;
        }
        IView view = this.mainTabSet.getView(this.stats_tab);
        if (view instanceof StatsView) {
            ((StatsView)view).showDHT();
        }
    }

    protected void showStatsTransfers() {
        this.showStats();
        if (this.stats_tab == null) {
            return;
        }
        IView view = this.mainTabSet.getView(this.stats_tab);
        if (view instanceof StatsView) {
            ((StatsView)view).showTransfers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedLanguageItem() {
        try {
            this.this_mon.enter();
            Messages.updateLanguageForControl((Widget)this.shell);
            if (this.systemTraySWT != null) {
                this.systemTraySWT.updateLanguage();
            }
            if (this.mainStatusBar != null) {
                this.mainStatusBar.refreshStatusText();
            }
            if (this.folder != null) {
                this.folder.update();
            }
            if (this.downloadBasket != null) {
                this.downloadBasket.updateLanguage();
            }
            this.mainTabSet.updateLanguage();
            if (this.mainStatusBar != null) {
                this.mainStatusBar.updateStatusText();
            }
            if (this.mainMenu != null) {
                MenuFactory.updateMenuText(this.mainMenu.getMenu("menu.bar"));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public MainMenu getMenu() {
        return (MainMenu)this.mainMenu;
    }

    public void setMenu(MainMenu menu) {
        this.mainMenu = menu;
    }

    public IMainMenu getMainMenu() {
        return this.mainMenu;
    }

    public void setMainMenu(IMainMenu menu) {
        this.mainMenu = menu;
    }

    protected AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("SWT UI");
        try {
            writer.indent();
            this.mainTabSet.generateDiagnostics(writer);
            TableColumnManager.getInstance().generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
        }
    }

    private void checkForWhatsNewWindow() {
        String CONFIG_LASTSHOWN = "welcome.version.lastshown";
        try {
            int latestDisplayed;
            String lastShown = "";
            boolean bIsStringParam = true;
            try {
                lastShown = COConfigurationManager.getStringParameter("welcome.version.lastshown", "");
            }
            catch (Exception e) {
                bIsStringParam = false;
            }
            if (lastShown.length() == 0 && (latestDisplayed = COConfigurationManager.getIntParameter("welcome.version.lastshown", 0)) > 0) {
                bIsStringParam = false;
                String s = "" + latestDisplayed;
                for (int i = 0; i < s.length(); ++i) {
                    if (i != 0) {
                        lastShown = lastShown + ".";
                    }
                    lastShown = lastShown + s.charAt(i);
                }
            }
            if (Constants.compareVersions(lastShown, Constants.getBaseVersion()) < 0) {
                new WelcomeWindow(this.shell);
                if (!bIsStringParam) {
                    COConfigurationManager.removeParameter("welcome.version.lastshown");
                }
                COConfigurationManager.setParameter("welcome.version.lastshown", Constants.getBaseVersion());
                COConfigurationManager.save();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    protected UISWTInstanceImpl getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    protected void setStatusText(String string) {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.setStatusText(string);
        }
    }

    protected void setStatusText(int statustype, String string, UIStatusTextClickListener l) {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.setStatusText(statustype, string, l);
        }
    }

    protected SystemTraySWT getSystemTraySWT() {
        return this.systemTraySWT;
    }

    protected MainStatusBar getMainStatusBar() {
        return this.mainStatusBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image generateObfusticatedImage() {
        IView[] allViews = this.mainTabSet.getAllViews();
        for (int i = 0; i < allViews.length; ++i) {
            IView view = allViews[i];
            if (!(view instanceof ObfusticateTab)) continue;
            Item tab = this.mainTabSet.getTab(view);
            tab.setText(((ObfusticateTab)((Object)view)).getObfusticatedHeader());
            this.folder.update();
        }
        Rectangle clientArea = this.shell.getClientArea();
        Image image = new Image((Device)this.display, clientArea.width, clientArea.height);
        GC gc = new GC((Drawable)this.shell);
        try {
            gc.copyArea(image, clientArea.x, clientArea.y);
        }
        finally {
            gc.dispose();
        }
        IView currentView = this.getCurrentView();
        if (currentView instanceof ObfusticateImage) {
            Point ofs = this.shell.toDisplay(clientArea.x, clientArea.y);
            try {
                ((ObfusticateImage)((Object)currentView)).obfusticatedImage(image, ofs);
            }
            catch (Exception e) {
                Debug.out("Obfusticating " + currentView, e);
            }
        }
        for (int i = 0; i < allViews.length; ++i) {
            IView view = allViews[i];
            if (!(view instanceof ObfusticateTab)) continue;
            view.refresh();
        }
        return image;
    }

    private static Point getStoredWindowSize() {
        String[] values;
        Display current;
        Point size = null;
        boolean isMaximized = COConfigurationManager.getBooleanParameter("window.maximized", false);
        if (isMaximized && (current = Display.getCurrent()) != null) {
            Rectangle clientArea = current.getClientArea();
            size = new Point(clientArea.width, clientArea.height);
            return size;
        }
        String windowRectangle = COConfigurationManager.getStringParameter("window.rectangle", null);
        if (windowRectangle != null && (values = windowRectangle.split(",")).length == 4) {
            try {
                size = new Point(Integer.parseInt(values[2]), Integer.parseInt(values[3]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return size;
    }

    public static void addToVersionCheckMessage(final Map map) {
        try {
            if (window == null || MainWindow.window.shell == null || MainWindow.window.shell.isDisposed()) {
                Point size = MainWindow.getStoredWindowSize();
                if (size == null) {
                    return;
                }
                map.put("mainwindow.w", new Long(size.x));
                map.put("mainwindow.h", new Long(size.y));
                return;
            }
            Utils.execSWTThread((Runnable)new AERunnable(){

                public void runSupport() {
                    Shell shell;
                    Point size = null;
                    if (window != null && (shell = window.getShell()) != null && !shell.isDisposed() && !shell.getMinimized()) {
                        size = shell.getSize();
                    }
                    if (size == null && (size = MainWindow.getStoredWindowSize()) == null) {
                        return;
                    }
                    map.put("mainwindow.w", new Long(size.x));
                    map.put("mainwindow.h", new Long(size.y));
                }
            }, false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public UIFunctionsSWT getUIFunctions() {
        return this.uiFunctions;
    }

    public boolean isVisible(int windowElement) {
        if (windowElement == 2) {
            return this.bIconBarEnabled;
        }
        if (windowElement == 3 || windowElement == 1) {
            // empty if block
        }
        return true;
    }

    public void setVisible(int windowElement, boolean value) {
        if (windowElement == 2) {
            this.setIconBarEnabled(value);
        } else if (windowElement == 3 || windowElement == 1) {
            // empty if block
        }
    }

    public Rectangle getMetrics(int windowElement) {
        if (windowElement == 2) {
            if (null != this.iconBar && null != this.iconBar.getComposite()) {
                return this.iconBar.getComposite().getBounds();
            }
        } else {
            if (windowElement == 3) {
                return this.mainStatusBar.getBounds();
            }
            if (windowElement != 4 && windowElement != 5) {
                if (windowElement == 6) {
                    return this.shell.getClientArea();
                }
                if (windowElement == 7) {
                    Rectangle r = this.shell.getClientArea();
                    r.x += this.iconBar.getComposite().getBounds().x;
                    r.height -= this.iconBar.getComposite().getBounds().height;
                    r.height -= this.mainStatusBar.getBounds().height;
                    return r;
                }
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void closeAllDetails() {
        if (this.mainTabSet != null) {
            this.mainTabSet.closeAllDetails();
        }
    }

    public boolean hasDetailViews() {
        if (this.mainTabSet != null) {
            this.mainTabSet.hasDetails();
        }
        return false;
    }

    public Tab getMainTabSet() {
        return this.mainTabSet;
    }

    static {
        isAlreadyDead = false;
        isDisposeFromListener = false;
    }
}

