/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.IUIIntializer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;

public class SWTThread {
    private static final int FREQ_PER_SEC_LIMIT = 10;
    private static SWTThread instance;
    Display display;
    private boolean sleak;
    private boolean terminated;
    private Thread runner;
    private final IUIIntializer initializer;
    private Map freq_map = new HashMap();

    public static SWTThread getInstance() {
        return instance;
    }

    public static void createInstance(IUIIntializer initializer) throws SWTThreadAlreadyInstanciatedException {
        if (instance != null) {
            throw new SWTThreadAlreadyInstanciatedException();
        }
        boolean bGTKTableBug_default = SWT.getPlatform().equals("gtk");
        COConfigurationManager.setBooleanDefault("SWT_bGTKTableBug", bGTKTableBug_default);
        new SWTThread(initializer);
    }

    private SWTThread(final IUIIntializer app) {
        this.initializer = app;
        instance = this;
        try {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = new Display();
                this.sleak = false;
            } else {
                this.sleak = true;
            }
        }
        catch (Exception e) {
            this.display = new Display();
            this.sleak = false;
        }
        catch (UnsatisfiedLinkError ue) {
            String sMin = "3.4";
            try {
                sMin = "" + (double)(SWT.getVersion() / 100) / 10.0;
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String tempDir = System.getProperty("swt.library.path");
                if (tempDir == null) {
                    System.getProperty("java.io.tmpdir");
                }
                Debug.out("Loading SWT Libraries failed. Typical causes:\n\n(1) swt.jar is not for your os architecture (" + System.getProperty("os.arch") + ").  " + "You can get a new swt.jar (Min Version: " + sMin + ") " + "from http://eclipse.org/swt" + "\n\n" + "(2) No write access to '" + tempDir + "'. SWT will extract libraries contained in the swt.jar to this dir.\n", ue);
                if (!this.terminated) {
                    app.stopIt(false, false);
                    this.terminated = true;
                }
                PlatformManagerFactory.getPlatformManager().dispose();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        Display.setAppName((String)Constants.APP_NAME);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(IndentWriter writer) {
                writer.println("SWT");
                try {
                    writer.indent();
                    writer.println("SWT Version:" + SWT.getVersion() + "/" + SWT.getPlatform());
                    writer.println("org.eclipse.swt.browser.XULRunnerPath: " + System.getProperty("org.eclipse.swt.browser.XULRunnerPath", ""));
                    writer.println("MOZILLA_FIVE_HOME: " + SystemProperties.getEnvironmentalVariable("MOZILLA_FIVE_HOME"));
                }
                finally {
                    writer.exdent();
                }
            }
        });
        if (Constants.isOSX) {
            try {
                Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                Constructor<?> constructor = ehancerClass.getConstructor(new Class[0]);
                constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        if (app != null) {
            this.runner = new Thread((Runnable)new AERunnable(){

                public void runSupport() {
                    app.run();
                }
            }, "Main Thread");
            this.runner.start();
        }
        if (!this.sleak) {
            while (!this.display.isDisposed() && !this.terminated) {
                try {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
                catch (Throwable e) {
                    if (Constants.isOSX && e instanceof SWTException && e.getMessage().endsWith(" is disposed") && (this.terminated || Debug.getStackTrace(e).indexOf("DropTarget") > 0)) {
                        Logger.log(new LogEvent(LogIDs.GUI, "Weird non-critical display disposal in readAndDispatch"));
                        continue;
                    }
                    if (SWT.getVersion() < 3119) {
                        e.printStackTrace();
                    }
                    if (!Constants.isCVSVersion()) continue;
                    Logger.log(new LogAlert(false, MessageText.getString("SWT.alert.erroringuithread"), e));
                }
            }
            if (!this.terminated) {
                if (app != null) {
                    app.stopIt(false, false);
                }
                this.terminated = true;
            }
            try {
                if (!this.display.isDisposed()) {
                    this.display.dispose();
                }
            }
            catch (Throwable t) {
                if (SWT.getVersion() < 3119) {
                    t.printStackTrace();
                }
                Debug.printStackTrace(t);
            }
            PlatformManagerFactory.getPlatformManager().dispose();
        }
    }

    public void terminate() {
        this.terminated = true;
        if (!this.display.isDisposed()) {
            try {
                Shell[] shells = this.display.getShells();
                for (int i = 0; i < shells.length; ++i) {
                    try {
                        Shell shell = shells[i];
                        shell.dispose();
                        continue;
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                    }
                }
            }
            catch (Throwable t) {
                Debug.out(t);
            }
            this.display.dispose();
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public IUIIntializer getInitializer() {
        return this.initializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limitFrequencyAsyncExec(Object owner, Display display, AERunnable target) {
        if (display.isDisposed()) {
            return;
        }
        int now = (int)(SystemTime.getCurrentTime() / 1000L);
        boolean do_it = true;
        Map map = this.freq_map;
        synchronized (map) {
            if (this.freq_map.size() > 1024) {
                Debug.out("Frequency map is overloaded - check your logic!!!!");
            } else {
                int[] data = (int[])this.freq_map.get(owner);
                if (data == null) {
                    data = new int[]{now, 0};
                    this.freq_map.put(owner, data);
                }
                if (data[0] == now) {
                    data[1] = data[1] + 1;
                    if (data[1] > 10) {
                        do_it = false;
                        Debug.out("SWT frequency limit exceeded for " + owner.getClass());
                    }
                } else {
                    data[0] = now;
                    data[1] = 1;
                }
            }
        }
        if (do_it) {
            display.asyncExec((Runnable)target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLimitedFrequencyOwner(Object owner) {
        Map map = this.freq_map;
        synchronized (map) {
            this.freq_map.remove(owner);
        }
    }
}

