/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.maketorrent.DirectoryPanel;
import org.gudy.azureus2.ui.swt.maketorrent.ModePanel;
import org.gudy.azureus2.ui.swt.maketorrent.SingleFilePanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class NewTorrentWizard
extends Wizard {
    static final int TT_LOCAL = 1;
    static final int TT_EXTERNAL = 2;
    static final int TT_DECENTRAL = 3;
    static final String TT_EXTERNAL_DEFAULT = "http://";
    static final String TT_DECENTRAL_DEFAULT = TorrentUtils.getDecentralisedEmptyURL().toString();
    private static String default_open_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.open", "");
    private static String default_save_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.save", "");
    private static String comment = COConfigurationManager.getStringParameter("CreateTorrent.default.comment", "");
    private static int tracker_type = COConfigurationManager.getIntParameter("CreateTorrent.default.trackertype", 1);
    boolean create_from_dir;
    String singlePath = "";
    String directoryPath = "";
    String savePath = "";
    String trackerURL = "http://";
    boolean computed_piece_size = true;
    long manual_piece_size;
    boolean useMultiTracker = false;
    boolean useWebSeed = false;
    private boolean addOtherHashes = COConfigurationManager.getBooleanParameter("CreateTorrent.default.addhashes", false);
    String multiTrackerConfig = "";
    List trackers = new ArrayList();
    String webSeedConfig = "";
    Map webseeds = new HashMap();
    boolean autoOpen = false;
    boolean autoHost = false;
    boolean permitDHT = true;
    boolean privateTorrent = false;
    TOTorrentCreator creator = null;

    public NewTorrentWizard(AzureusCore azureus_core, Display display) {
        super(azureus_core, "wizard.title");
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (NewTorrentWizard.this.creator != null) {
                    NewTorrentWizard.this.creator.cancel();
                }
            }
        });
        this.trackers.add(new ArrayList());
        this.trackerURL = Utils.getLinkFromClipboard(display, false);
        ModePanel panel = new ModePanel(this, null);
        this.createDropTarget((Control)this.getWizardWindow());
        this.setFirstPanel(panel);
    }

    protected int getTrackerType() {
        return tracker_type;
    }

    protected void setTrackerType(int type) {
        tracker_type = type;
        COConfigurationManager.setParameter("CreateTorrent.default.trackertype", tracker_type);
    }

    protected String getDefaultOpenDir() {
        return default_open_dir;
    }

    protected void setDefaultOpenDir(String d) {
        default_open_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.open", default_open_dir);
    }

    protected String getDefaultSaveDir() {
        return default_save_dir;
    }

    protected void setDefaultSaveDir(String d) {
        default_save_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.save", default_save_dir);
    }

    void setComment(String s) {
        comment = s;
        COConfigurationManager.setParameter("CreateTorrent.default.comment", comment);
    }

    String getComment() {
        return comment;
    }

    private void createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event2) {
                if (URLTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                    event2.detail = NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel ? 4 : 0;
                }
            }

            public void drop(DropTargetEvent event2) {
                if (event2.data instanceof String[]) {
                    String[] sourceNames = (String[])event2.data;
                    if (sourceNames == null || sourceNames.length != 1) {
                        event2.detail = 0;
                    }
                    if (event2.detail == 0) {
                        return;
                    }
                    File droppedFile = new File(sourceNames[0]);
                    if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) {
                        if (droppedFile.isFile()) {
                            NewTorrentWizard.this.singlePath = droppedFile.getAbsolutePath();
                            ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).activateMode(true);
                        } else if (droppedFile.isDirectory()) {
                            NewTorrentWizard.this.directoryPath = droppedFile.getAbsolutePath();
                            ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).activateMode(false);
                        }
                    } else if (NewTorrentWizard.this.getCurrentPanel() instanceof DirectoryPanel) {
                        if (droppedFile.isDirectory()) {
                            ((DirectoryPanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                        }
                    } else if (NewTorrentWizard.this.getCurrentPanel() instanceof SingleFilePanel && droppedFile.isFile()) {
                        ((SingleFilePanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                    }
                } else if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) {
                    NewTorrentWizard.this.trackerURL = ((URLTransfer.URLType)event2.data).linkURL;
                    ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).updateTrackerURL();
                }
            }
        });
    }

    protected void setPieceSizeComputed() {
        this.computed_piece_size = true;
    }

    public boolean getPieceSizeComputed() {
        return this.computed_piece_size;
    }

    protected void setPieceSizeManual(long _value) {
        this.computed_piece_size = false;
        this.manual_piece_size = _value;
    }

    protected long getPieceSizeManual() {
        return this.manual_piece_size;
    }

    protected void setAddOtherHashes(boolean o) {
        this.addOtherHashes = o;
        COConfigurationManager.setParameter("CreateTorrent.default.addhashes", this.addOtherHashes);
    }

    protected boolean getAddOtherHashes() {
        return this.addOtherHashes;
    }

    static {
        if (default_save_dir.length() == 0) {
            default_save_dir = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory", "");
        }
    }
}

