/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class SimpleBrowserWindow {
    private Shell shell;
    private Browser browser;

    public SimpleBrowserWindow(Shell parent, String url, double wPct, double hPct, boolean allowResize, boolean isModal) {
        if (parent == null) {
            this.init(parent, url, 0, 0, allowResize, isModal);
        } else {
            Rectangle clientArea = parent.getClientArea();
            this.init(parent, url, (int)((double)clientArea.width * wPct), (int)((double)clientArea.height * hPct), allowResize, isModal);
        }
    }

    public SimpleBrowserWindow(Shell parent, String url, int w, int h, boolean allowResize, boolean isModal) {
        this.init(parent, url, w, h, allowResize, isModal);
    }

    private void init(Shell parent, String url, int w, int h, boolean allowResize, boolean isModal) {
        if (parent == null) {
            parent = Utils.findAnyShell();
        }
        int style = 2144;
        if (allowResize) {
            style |= 0x10;
        }
        if (isModal) {
            style |= 0x10000;
        }
        this.shell = ShellFactory.createShell(parent, style);
        this.shell.setLayout((Layout)new FillLayout());
        Utils.setShellIcon(this.shell);
        try {
            this.browser = new Browser((Composite)this.shell, Utils.getInitialBrowserStyle(0));
            this.shell.addListener(21, new Listener(){

                public void handleEvent(Event arg0) {
                    try {
                        if (SimpleBrowserWindow.this.browser != null) {
                            SimpleBrowserWindow.this.browser.setUrl("about:blank");
                            SimpleBrowserWindow.this.browser.setVisible(false);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Throwable t) {
            this.shell.dispose();
            return;
        }
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event2) {
                SimpleBrowserWindow.this.shell.open();
            }

            public void changed(ProgressEvent event2) {
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event2) {
                SimpleBrowserWindow.this.shell.dispose();
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                SimpleBrowserWindow.this.shell.setText(event2.title);
            }
        });
        if (w > 0 && h > 0) {
            this.shell.setSize(w, h);
        }
        Utils.centerWindowRelativeTo(this.shell, (Control)parent);
        this.browser.setUrl(url);
        this.browser.setData("StartURL", (Object)url);
    }

    public void waitUntilClosed() {
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 2144);
        shell.setSize(800, 600);
        new SimpleBrowserWindow(shell, "http://google.com", 0.8, 0.5, true, false);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

