/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.TypeItem;

public class MySharesView
extends TableViewTab
implements ShareManagerListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableSelectionListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TypeItem(), new CategoryItem()};
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private AzureusCore azureus_core;
    private GlobalManager global_manager;
    private Menu menuCategory;
    private TableViewSWTImpl tv = new TableViewSWTImpl("MyShares", "MySharesView", basicItems, "name", 268503042);
    private boolean start;
    private boolean stop;
    private boolean remove;

    public MySharesView() {
        this(AzureusCoreFactory.getSingleton());
    }

    public MySharesView(AzureusCore _azureus_core) {
        this.setTableView(this.tv);
        this.azureus_core = _azureus_core;
        this.global_manager = this.azureus_core.getGlobalManager();
        this.tv.addSelectionListener(new TableSelectionAdapter(){

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                MySharesView.this.defaultSelected(rows);
            }
        }, false);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
        this.tv.addSelectionListener(this, false);
    }

    private void defaultSelected(TableRowCore[] rows) {
        ShareResource share = (ShareResource)this.tv.getFirstSelectedDataSource();
        if (share == null) {
            return;
        }
        List dms = this.global_manager.getDownloadManagers();
        for (int i = 0; i < dms.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager dm = (org.gudy.azureus2.core3.download.DownloadManager)dms.get(i);
            try {
                byte[] share_hash = null;
                if (share.getType() == 2) {
                    share_hash = ((ShareResourceDir)share).getItem().getTorrent().getHash();
                } else if (share.getType() == 1) {
                    share_hash = ((ShareResourceFile)share).getItem().getTorrent().getHash();
                }
                if (!Arrays.equals(share_hash, dm.getTorrent().getHash())) continue;
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions == null) break;
                uiFunctions.openView(5, dm);
                break;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void tableViewInitialized() {
        this.createRows();
    }

    public void tableViewDestroyed() {
        try {
            this.azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager().removeListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    private void createRows() {
        try {
            ShareManager sm = this.azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager();
            ShareResource[] shares = sm.getShares();
            for (int i = 0; i < shares.length; ++i) {
                this.resourceAdded(shares[i]);
            }
            sm.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    public void fillMenu(Menu menu) {
        Shell shell = menu.getShell();
        this.menuCategory = new Menu((Decorations)shell, 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] shares = this.tv.getSelectedDataSources();
        itemRemove.setEnabled(shares.length > 0);
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MySharesView.this.removeSelectedShares();
            }
        });
        new MenuItem(menu, 2);
    }

    public void resourceAdded(ShareResource resource) {
        this.tv.addDataSource(resource);
    }

    public void resourceModified(ShareResource resource) {
    }

    public void resourceDeleted(ShareResource resource) {
        this.tv.removeDataSource(resource);
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(String task_description) {
    }

    public void tableRefresh() {
        this.computePossibleActions();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    private void addCategorySubMenu() {
        int i;
        MenuItem[] items = this.menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(this.menuCategory, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MySharesView.this.addCategory();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(Display.getDefault());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(final Category category) {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                String value = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                ((ShareResource)row.getDataSource(true)).setAttribute(category_attribute, value);
            }
        });
    }

    private void computePossibleActions() {
        this.remove = false;
        this.stop = false;
        this.start = false;
        List items = this.getSelectedItems();
        if (items.size() > 0) {
            PluginInterface pi = this.azureus_core.getPluginManager().getDefaultPluginInterface();
            DownloadManager dm = pi.getDownloadManager();
            this.remove = true;
            for (int i = 0; i < items.size(); ++i) {
                ShareItem item = (ShareItem)items.get(i);
                try {
                    int dl_state;
                    Torrent t = item.getTorrent();
                    Download download = dm.getDownload(t);
                    if (download == null || (dl_state = download.getState()) == 8) continue;
                    if (dl_state != 7) {
                        this.stop = true;
                        continue;
                    }
                    this.start = true;
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        return super.isEnabled(itemKey);
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("remove")) {
            this.removeSelectedShares();
            return;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedShares();
            return;
        }
        if (itemKey.equals("start")) {
            this.startSelectedShares();
            return;
        }
        super.itemActivated(itemKey);
    }

    private List getSelectedItems() {
        Object[] shares = this.tv.getSelectedDataSources();
        ArrayList<ShareItem> items = new ArrayList<ShareItem>();
        if (shares.length > 0) {
            for (int i = 0; i < shares.length; ++i) {
                ShareResource sr;
                ShareResource share = (ShareResource)shares[i];
                int type = share.getType();
                if (type == 2) {
                    sr = (ShareResourceDir)share;
                    items.add(sr.getItem());
                    continue;
                }
                if (type == 1) {
                    sr = (ShareResourceFile)share;
                    items.add(sr.getItem());
                    continue;
                }
                ShareResourceDirContents cont = (ShareResourceDirContents)share;
                ArrayList entries = new ArrayList();
                this.getEntries(entries, cont);
                for (int j = 0; j < entries.size(); ++j) {
                    ShareResource sr2;
                    share = (ShareResource)entries.get(j);
                    type = share.getType();
                    if (type == 2) {
                        sr2 = (ShareResourceDir)share;
                        items.add(sr2.getItem());
                        continue;
                    }
                    if (type != 1) continue;
                    sr2 = (ShareResourceFile)share;
                    items.add(sr2.getItem());
                }
            }
        }
        return items;
    }

    private void getEntries(List entries, ShareResourceDirContents cont) {
        ShareResource[] kids = cont.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            ShareResource share = kids[i];
            int type = share.getType();
            if (type == 3) {
                this.getEntries(entries, (ShareResourceDirContents)share);
                continue;
            }
            entries.add(share);
        }
    }

    private void startStopSelectedShares(boolean do_stop) {
        List items = this.getSelectedItems();
        PluginInterface pi = this.azureus_core.getPluginManager().getDefaultPluginInterface();
        DownloadManager dm = pi.getDownloadManager();
        Tracker tracker = pi.getTracker();
        for (int i = 0; i < items.size(); ++i) {
            ShareItem item = (ShareItem)items.get(i);
            try {
                int dl_state;
                Torrent t = item.getTorrent();
                TrackerTorrent tracker_torrent = tracker.getTorrent(t);
                Download download = dm.getDownload(t);
                if (tracker_torrent == null || download == null || (dl_state = download.getState()) == 8) continue;
                if (dl_state != 7) {
                    if (!do_stop) continue;
                    try {
                        download.stop();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        tracker_torrent.stop();
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (do_stop) continue;
                try {
                    download.restart();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    tracker_torrent.start();
                }
                catch (Throwable e) {}
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void startSelectedShares() {
        this.startStopSelectedShares(false);
    }

    private void stopSelectedShares() {
        this.startStopSelectedShares(true);
    }

    private void removeSelectedShares() {
        this.stopSelectedShares();
        Object[] shares = this.tv.getSelectedDataSources();
        for (int i = 0; i < shares.length; ++i) {
            try {
                ((ShareResource)shares[i]).delete();
                continue;
            }
            catch (Throwable e) {
                Alerts.showErrorMessageBoxUsingResourceString(new Object[]{shares[i]}, "globalmanager.download.remove.veto", e, 0);
            }
        }
    }

    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    public void defaultSelected(TableRowCore[] rows, int stateMask) {
    }

    public void deselected(TableRowCore[] rows) {
        this.computePossibleActions();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    public void focusChanged(TableRowCore focus) {
        this.computePossibleActions();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    public void mouseEnter(TableRowCore row) {
    }

    public void mouseExit(TableRowCore row) {
    }

    public void selected(TableRowCore[] row) {
        this.computePossibleActions();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }
}

