/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.applet.Applet;
import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ButtonParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;

public class ConfigSectionInterfaceAlerts
implements UISWTConfigSection {
    private static final String INTERFACE_PREFIX = "ConfigView.section.interface.";
    private static final String LBLKEY_PREFIX = "ConfigView.label.";
    private static final String STYLE_PREFIX = "ConfigView.section.style.";
    private final int REQUIRED_MODE = 0;

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "interface.alerts";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(final Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        cSection.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 0) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 0 < modeKeys.length ? MessageText.getString(modeKeys[0]) : String.valueOf(0);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        Composite cArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        BooleanParameter d_play_sound = new BooleanParameter(cArea, "Play Download Finished", "ConfigView.label.playdownloadfinished");
        if (Constants.isOSX) {
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 0;
            gridData.heightHint = 0;
            Composite d_filler = new Composite(cArea, 0);
            d_filler.setSize(0, 0);
            d_filler.setLayoutData((Object)gridData);
            BooleanParameter d_speechEnabledParameter = new BooleanParameter(cArea, "Play Download Finished Announcement", "ConfigView.label.playdownloadspeech");
            StringParameter d_speechParameter = new StringParameter(cArea, "Play Download Finished Announcement Text");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 150;
            d_speechParameter.setLayoutData(gridData);
            ((Text)d_speechParameter.getControl()).setTextLimit(40);
            d_speechEnabledParameter.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(d_speechParameter.getControls()));
            Label d_speechInfo = new Label(cArea, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalIndent = 24;
            d_speechInfo.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)d_speechInfo, "ConfigView.label.playdownloadspeech.info");
        }
        if (!Constants.isOSX) {
            Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
            gridData = new GridData(768);
            final StringParameter d_pathParameter = new StringParameter(cArea, "Play Download Finished File", "");
            if (d_pathParameter.getValue().length() == 0) {
                d_pathParameter.setValue("<default>");
            }
            d_pathParameter.setLayoutData(gridData);
            Button d_browse = new Button(cArea, 8);
            d_browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(d_browse.getBackground());
            d_browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            d_browse.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                    dialog.setFilterExtensions(new String[]{"*.wav"});
                    dialog.setFilterNames(new String[]{"*.wav"});
                    dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                    final String path = dialog.open();
                    if (path != null) {
                        d_pathParameter.setValue(path);
                        new AEThread("SoundTest"){

                            public void runSupport() {
                                try {
                                    Applet.newAudioClip(new File(path).toURL()).play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
            });
            Label d_sound_info = new Label(cArea, 64);
            Messages.setLanguageText((Widget)d_sound_info, "ConfigView.section.interface.wavlocation.info");
            gridData = new GridData(768);
            gridData.widthHint = 100;
            d_sound_info.setLayoutData((Object)gridData);
            d_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(d_pathParameter.getControls()));
            d_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{d_browse, d_sound_info}));
        }
        BooleanParameter f_play_sound = new BooleanParameter(cArea, "Play File Finished", "ConfigView.label.playfilefinished");
        if (Constants.isOSX) {
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 0;
            gridData.heightHint = 0;
            Composite f_filler = new Composite(cArea, 0);
            f_filler.setSize(0, 0);
            f_filler.setLayoutData((Object)gridData);
            BooleanParameter f_speechEnabledParameter = new BooleanParameter(cArea, "Play File Finished Announcement", "ConfigView.label.playfilespeech");
            StringParameter f_speechParameter = new StringParameter(cArea, "Play File Finished Announcement Text");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 150;
            f_speechParameter.setLayoutData(gridData);
            ((Text)f_speechParameter.getControl()).setTextLimit(40);
            f_speechEnabledParameter.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(f_speechParameter.getControls()));
            Label speechInfo = new Label(cArea, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalIndent = 24;
            speechInfo.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)speechInfo, "ConfigView.label.playfilespeech.info");
        }
        if (!Constants.isOSX) {
            Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
            gridData = new GridData(768);
            final StringParameter f_pathParameter = new StringParameter(cArea, "Play File Finished File", "");
            if (f_pathParameter.getValue().length() == 0) {
                f_pathParameter.setValue("<default>");
            }
            f_pathParameter.setLayoutData(gridData);
            Button f_browse = new Button(cArea, 8);
            f_browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(f_browse.getBackground());
            f_browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            f_browse.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                    dialog.setFilterExtensions(new String[]{"*.wav"});
                    dialog.setFilterNames(new String[]{"*.wav"});
                    dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                    final String path = dialog.open();
                    if (path != null) {
                        f_pathParameter.setValue(path);
                        new AEThread("SoundTest"){

                            public void runSupport() {
                                try {
                                    Applet.newAudioClip(new File(path).toURL()).play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
            });
            Label f_sound_info = new Label(cArea, 64);
            Messages.setLanguageText((Widget)f_sound_info, "ConfigView.section.interface.wavlocation.info");
            gridData = new GridData(768);
            gridData.widthHint = 100;
            f_sound_info.setLayoutData((Object)gridData);
            f_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(f_pathParameter.getControls()));
            f_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{f_browse, f_sound_info}));
        }
        cArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        BooleanParameter popup_dl_added = new BooleanParameter(cArea, "Popup Download Added", "ConfigView.label.popupdownloadadded");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_dl_added.setLayoutData(gridData);
        BooleanParameter popup_dl_completed = new BooleanParameter(cArea, "Popup Download Finished", "ConfigView.label.popupdownloadfinished");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_dl_completed.setLayoutData(gridData);
        BooleanParameter popup_file_completed = new BooleanParameter(cArea, "Popup File Finished", "ConfigView.label.popupfilefinished");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_file_completed.setLayoutData(gridData);
        BooleanParameter disable_sliding = new BooleanParameter(cArea, "GUI_SWT_DisableAlertSliding", "ConfigView.section.style.disableAlertSliding");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        disable_sliding.setLayoutData(gridData);
        BooleanParameter show_alert_timestamps = new BooleanParameter(cArea, "Show Timestamp For Alerts", "ConfigView.label.popup.timestamp");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        show_alert_timestamps.setLayoutData(gridData);
        Label label = new Label(cArea, 64);
        Messages.setLanguageText((Widget)label, "ConfigView.label.popup.autohide");
        label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 0));
        IntParameter auto_hide_alert = new IntParameter(cArea, "Message Popup Autoclose in Seconds", 0, 86400);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 30;
        auto_hide_alert.setLayoutData(gridData);
        BooleanParameter use_popup_boxes = new BooleanParameter(cArea, "Use Message Box For Popups", "ConfigView.label.popup.use_message_boxes");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        use_popup_boxes.setLayoutData(gridData);
        BooleanParameter suppress_alerts = new BooleanParameter(cArea, "Suppress Alerts", "ConfigView.label.popup.suppress_alerts");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        suppress_alerts.setLayoutData(gridData);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.popup.show");
        ButtonParameter show_alerts = new ButtonParameter(cArea, "ConfigView.label.popup.show.button");
        show_alerts.addChangeListener(new ParameterChangeAdapter(){

            public void parameterChanged(Parameter p, boolean b) {
                Display display = parent.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                MessageSlideShell.displayLastMessage(display, true);
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 60;
        show_alerts.setLayoutData(gridData);
        return cSection;
    }
}

