/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCoreCreationListener;

public class TableColumnManager {
    private static final String CONFIG_FILE = "tables.config";
    private static TableColumnManager instance;
    private static AEMonitor class_mon;
    private Map items;
    private AEMonitor items_mon = new AEMonitor("TableColumnManager:items");
    private Map autoHideOrder = new LightHashMap();
    private Map mapTablesConfig;
    private static Comparator orderComparator;
    private Map mapColumnIDsToListener = new LightHashMap();
    private Map mapDataSourceTypeToColumnIDs = new LightHashMap();

    private TableColumnManager() {
        this.items = new HashMap();
        this.mapTablesConfig = FileUtil.readResilientConfigFile(CONFIG_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableColumnManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TableColumnManager();
            }
            TableColumnManager tableColumnManager = instance;
            return tableColumnManager;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumns(TableColumnCore[] itemsToAdd) {
        try {
            this.items_mon.enter();
            for (int i = 0; i < itemsToAdd.length; ++i) {
                TableColumnCore item = itemsToAdd[i];
                String name = item.getName();
                String sTableID = item.getTableID();
                LinkedHashMap<String, TableColumnCore> mTypes = (LinkedHashMap<String, TableColumnCore>)this.items.get(sTableID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, TableColumnCore>();
                    this.items.put(sTableID, mTypes);
                }
                if (!mTypes.containsKey(name)) {
                    mTypes.put(name, item);
                    Map mapColumnConfig = this.getTableConfigMap(sTableID);
                    this.mapTablesConfig.put("Table." + sTableID, mapColumnConfig);
                    item.loadSettings(mapColumnConfig);
                }
                if (item.getColumnAdded()) continue;
                item.setColumnAdded(true);
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Table Column Extension");
            Debug.printStackTrace(e);
        }
        finally {
            this.items_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTableColumnsAsMap(Class forDataSourceType, String sTableID) {
        try {
            this.items_mon.enter();
            LinkedHashMap mReturn = new LinkedHashMap();
            Map mTypes = this.getAllTableColumnCore(forDataSourceType, sTableID);
            if (mTypes != null) {
                mReturn.putAll(mTypes);
            }
            LinkedHashMap linkedHashMap = mReturn;
            return linkedHashMap;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public int getTableColumnCount(String sTableID) {
        Map mTypes = (Map)this.items.get(sTableID);
        if (mTypes == null) {
            return 0;
        }
        return mTypes.size();
    }

    public TableColumnCore[] getAllTableColumnCoreAsArray(Class forDataSourceType, String tableID) {
        Map mTypes = this.getAllTableColumnCore(forDataSourceType, tableID);
        return mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAllTableColumnCore(Class forDataSourceType, String tableID) {
        String[] dstColumnIDs = new String[]{};
        if (forDataSourceType != null) {
            List listDST = (List)this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
            if (listDST != null) {
                dstColumnIDs = listDST.toArray(new String[0]);
            }
            if (forDataSourceType.equals(DownloadTypeComplete.class) || forDataSourceType.equals(DownloadTypeIncomplete.class)) {
                listDST = (List)this.mapDataSourceTypeToColumnIDs.get(Download.class);
                if (listDST != null && listDST.size() > 0) {
                    String[] ids1 = listDST.toArray(new String[0]);
                    String[] ids2 = dstColumnIDs;
                    dstColumnIDs = new String[ids2.length + ids1.length];
                    System.arraycopy(ids2, 0, dstColumnIDs, 0, ids2.length);
                    System.arraycopy(ids1, 0, dstColumnIDs, ids2.length, ids1.length);
                }
            } else if (forDataSourceType.equals(Download.class)) {
                String[] ids;
                listDST = (List)this.mapDataSourceTypeToColumnIDs.get(DownloadTypeComplete.class);
                if (listDST != null && listDST.size() > 0) {
                    ids = listDST.toArray(new String[listDST.size()]);
                    dstColumnIDs = this.appendLists(ids, dstColumnIDs);
                }
                if ((listDST = (List)this.mapDataSourceTypeToColumnIDs.get(DownloadTypeIncomplete.class)) != null && listDST.size() > 0) {
                    ids = listDST.toArray(new String[listDST.size()]);
                    dstColumnIDs = this.appendLists(ids, dstColumnIDs);
                }
            }
        }
        try {
            this.items_mon.enter();
            LinkedHashMap mTypes = (LinkedHashMap)this.items.get(tableID);
            if (mTypes == null) {
                mTypes = new LinkedHashMap();
                this.items.put(tableID, mTypes);
            }
            for (int i = 0; i < dstColumnIDs.length; ++i) {
                String columnID = dstColumnIDs[i];
                if (mTypes.containsKey(columnID)) continue;
                try {
                    TableColumnCreationListener l = (TableColumnCreationListener)this.mapColumnIDsToListener.get(columnID);
                    TableColumnCore tc = null;
                    if (l instanceof TableColumnCoreCreationListener) {
                        tc = ((TableColumnCoreCreationListener)l).createTableColumnCore(tableID, columnID);
                    }
                    if (tc == null) {
                        tc = new TableColumnImpl(tableID, columnID);
                    }
                    l.tableColumnCreated(tc);
                    this.addColumns(new TableColumnCore[]{tc});
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            LinkedHashMap linkedHashMap = mTypes;
            return linkedHashMap;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public String[] appendLists(String[] list1, String[] list2) {
        int size = list1.length + list2.length;
        String[] list = new String[size];
        System.arraycopy(list1, 0, list, 0, list1.length);
        System.arraycopy(list2, 0, list, list1.length, list2.length);
        return list;
    }

    public TableColumnCore getTableColumnCore(String sTableID, String sColumnName) {
        Map mTypes = (Map)this.items.get(sTableID);
        if (mTypes == null) {
            return null;
        }
        return (TableColumnCore)mTypes.get(sColumnName);
    }

    public void ensureIntegrety(String sTableID) {
        Map mTypes = (Map)this.items.get(sTableID);
        if (mTypes == null) {
            return;
        }
        TableColumnCore[] tableColumns = mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
        Arrays.sort(tableColumns, TableColumnManager.getTableColumnOrderComparator());
        int iPos = 0;
        for (int i = 0; i < tableColumns.length; ++i) {
            int iCurPos = tableColumns[i].getPosition();
            if (iCurPos == -1) {
                tableColumns[i].setVisible(false);
                continue;
            }
            tableColumns[i].setPositionNoShift(iPos++);
        }
    }

    public String getDefaultSortColumnName(String tableID) {
        Map mapTableConfig = this.getTableConfigMap(tableID);
        Object object = mapTableConfig.get("SortColumn");
        if (object instanceof byte[]) {
            object = new String((byte[])object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        String s = COConfigurationManager.getStringParameter(tableID + ".sortColumn");
        if (s != null) {
            COConfigurationManager.removeParameter(tableID + ".sortColumn");
            COConfigurationManager.removeParameter(tableID + ".sortAsc");
        }
        return s;
    }

    public void setDefaultSortColumnName(String tableID, String columnName) {
        Map mapTableConfig = this.getTableConfigMap(tableID);
        mapTableConfig.put("SortColumn", columnName);
        FileUtil.writeResilientConfigFile(CONFIG_FILE, this.mapTablesConfig);
    }

    public void saveTableColumns(Class forDataSourceType, String sTableID) {
        try {
            Map mapTableConfig = this.getTableConfigMap(sTableID);
            TableColumnCore[] tcs = this.getAllTableColumnCoreAsArray(forDataSourceType, sTableID);
            for (int i = 0; i < tcs.length; ++i) {
                if (tcs[i] == null) continue;
                tcs[i].saveSettings(mapTableConfig);
            }
            FileUtil.writeResilientConfigFile(CONFIG_FILE, this.mapTablesConfig);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public boolean loadTableColumnSettings(Class forDataSourceType, String sTableID) {
        try {
            Map mapTableConfig = this.getTableConfigMap(sTableID);
            if (mapTableConfig.isEmpty()) {
                return false;
            }
            TableColumnCore[] tcs = this.getAllTableColumnCoreAsArray(forDataSourceType, sTableID);
            for (int i = 0; i < tcs.length; ++i) {
                if (tcs[i] == null) continue;
                tcs[i].loadSettings(mapTableConfig);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return true;
    }

    public Map getTableConfigMap(String sTableID) {
        HashMap mapTableConfig = (HashMap)this.mapTablesConfig.get("Table." + sTableID);
        if (mapTableConfig == null) {
            mapTableConfig = new HashMap();
            this.mapTablesConfig.put("Table." + sTableID, mapTableConfig);
        }
        return mapTableConfig;
    }

    public void setAutoHideOrder(String sTableID, String[] autoHideOrderColumnIDs) {
        ArrayList<TableColumnCore> autoHideOrderList = new ArrayList<TableColumnCore>(autoHideOrderColumnIDs.length);
        for (int i = 0; i < autoHideOrderColumnIDs.length; ++i) {
            String sColumnID = autoHideOrderColumnIDs[i];
            TableColumnCore column = this.getTableColumnCore(sTableID, sColumnID);
            if (column == null) continue;
            autoHideOrderList.add(column);
        }
        this.autoHideOrder.put(sTableID, autoHideOrderList);
    }

    public List getAutoHideOrder(String sTableID) {
        List list = (List)this.autoHideOrder.get(sTableID);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiagnostics(IndentWriter writer) {
        try {
            this.items_mon.enter();
            writer.println("TableColumns");
            for (String sTableID : this.items.keySet()) {
                Map mTypes = (Map)this.items.get(sTableID);
                writer.indent();
                writer.println(sTableID + ": " + mTypes.size() + " columns:");
                writer.indent();
                for (TableColumnCore tc : mTypes.values()) {
                    tc.generateDiagnostics(writer);
                }
                writer.exdent();
                writer.exdent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.items_mon.exit();
        }
    }

    public static Comparator getTableColumnOrderComparator() {
        return orderComparator;
    }

    public void registerColumn(Class forDataSourceType, String cellID, TableColumnCreationListener listener) {
        this.mapColumnIDsToListener.put(cellID, listener);
        ArrayList<String> list = (ArrayList<String>)this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.mapDataSourceTypeToColumnIDs.put(forDataSourceType, list);
        }
        list.add(cellID);
    }

    static {
        class_mon = new AEMonitor("TableColumnManager");
        orderComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg1 instanceof TableColumn && arg0 instanceof TableColumn) {
                    int iPositionB;
                    int iPositionA = ((TableColumn)arg0).getPosition();
                    if (iPositionA < 0) {
                        iPositionA = 65535 + iPositionA;
                    }
                    if ((iPositionB = ((TableColumn)arg1).getPosition()) < 0) {
                        iPositionB = 65535 + iPositionB;
                    }
                    return iPositionA - iPositionB;
                }
                return 0;
            }
        };
    }
}

