/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ShareRatioItem
extends CoreTableColumn
implements TableCellRefreshListener,
ParameterListener {
    private static final String CONFIG_ID = "StartStopManager_iFirstPriority_ShareRatio";
    public static final String COLUMN_ID = "shareRatio";
    private int iMinShareRatio;
    private boolean changeFG = true;

    public ShareRatioItem(String sTableID) {
        super(COLUMN_ID, 2, -2, 70, sTableID);
        this.setType(1);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.setPosition(-2);
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        COConfigurationManager.addParameterListener(CONFIG_ID, (ParameterListener)this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CONFIG_ID, this);
    }

    public void refresh(TableCell cell) {
        int sr;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int n = sr = dm == null ? 0 : dm.getStats().getShareRatio();
        if (sr == -1) {
            sr = 31536000;
        }
        if (!cell.setSortValue(sr) && cell.isValid()) {
            return;
        }
        String shareRatio = "";
        if (sr == 31536000) {
            shareRatio = "\u221e";
        } else {
            String partial = String.valueOf(sr % 1000);
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            shareRatio = "" + sr / 1000 + DisplayFormatters.getDecimalSeparator() + partial;
        }
        if (cell.setText(shareRatio) && this.changeFG) {
            Color color = sr < this.iMinShareRatio ? Colors.colorWarning : null;
            cell.setForeground(Utils.colorToIntArray(color));
        }
    }

    public void parameterChanged(String parameterName) {
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        this.invalidateCells();
    }

    public boolean isChangeFG() {
        return this.changeFG;
    }

    public void setChangeFG(boolean changeFG) {
        this.changeFG = changeFG;
    }
}

