/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class SizeItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "size";
    private static boolean DO_MULTILINE = true;

    public SizeItem(String sTableID) {
        super(COLUMN_ID, 2, -2, 70, sTableID);
        this.setRefreshInterval(-1);
        this.setMinWidthAuto(true);
    }

    public void refresh(TableCell cell) {
        sizeitemsort value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        sizeitemsort sizeitemsort2 = value = dm == null ? new sizeitemsort(0L, 0L) : new sizeitemsort(dm.getSize(), dm.getStats().getRemaining());
        if (value.compareTo(cell.getSortValue()) == 0 && cell.isValid()) {
            return;
        }
        cell.setSortValue(value);
        String s = DisplayFormatters.formatByteCountToKiBEtc(value.size);
        if (DO_MULTILINE && cell.getMaxLines() > 1 && value.remaining > 0L) {
            s = s + "\n" + DisplayFormatters.formatByteCountToKiBEtc(value.remaining, false, false, 0) + " to go";
        }
        cell.setText(s);
    }

    private class sizeitemsort
    implements Comparable {
        private final long size;
        private final long remaining;

        public sizeitemsort(long size, long remaining) {
            this.size = size;
            this.remaining = remaining;
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof sizeitemsort)) {
                return 1;
            }
            sizeitemsort otherObj = (sizeitemsort)arg0;
            if (this.size == otherObj.size) {
                return this.remaining == otherObj.remaining ? 0 : (this.remaining > otherObj.remaining ? 1 : -1);
            }
            return this.size > otherObj.size ? 1 : -1;
        }
    }
}

