/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class StatusItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "status";
    private boolean changeRowFG;
    private boolean changeCellFG = true;

    public StatusItem(String sTableID, boolean changeRowFG) {
        super(COLUMN_ID, -2, 80, sTableID);
        this.changeRowFG = changeRowFG;
        this.setRefreshInterval(-2);
    }

    public StatusItem(String sTableID) {
        this(sTableID, true);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (cell.setText(dm == null ? "" : DisplayFormatters.formatDownloadStatus(dm)) || !cell.isValid()) {
            if (!this.changeCellFG && !this.changeRowFG) {
                return;
            }
            TableRow row = cell.getTableRow();
            if (row != null && dm != null) {
                int state = dm.getState();
                Object color = null;
                color = state == 60 ? Colors.blues[7] : (state == 100 ? Colors.colorError : null);
                if (this.changeRowFG) {
                    row.setForeground(Utils.colorToIntArray(color));
                } else if (this.changeCellFG) {
                    cell.setForeground(Utils.colorToIntArray(color));
                }
            }
        }
    }

    public boolean isChangeRowFG() {
        return this.changeRowFG;
    }

    public void setChangeRowFG(boolean changeRowFG) {
        this.changeRowFG = changeRowFG;
    }

    public boolean isChangeCellFG() {
        return this.changeCellFG;
    }

    public void setChangeCellFG(boolean changeCellFG) {
        this.changeCellFG = changeCellFG;
    }
}

