/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ClientIdentificationItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public ClientIdentificationItem(String table_id) {
        super("client_identification", -1, 200, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            cell.setText("");
            return;
        }
        String peer_id_name = peer.getClientNameFromPeerID();
        String peer_handshake_name = peer.getClientNameFromExtensionHandshake();
        if (peer_id_name == null) {
            peer_id_name = "";
        }
        if (peer_handshake_name == null) {
            peer_handshake_name = "";
        }
        if (peer_id_name.equals("") && peer_handshake_name.equals("")) {
            cell.setText("");
            return;
        }
        String result = peer_id_name;
        if (!peer_handshake_name.equals("")) {
            result = result + " / " + peer_handshake_name;
        }
        cell.setText(result);
    }
}

