/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class DownItem
extends CoreTableColumn
implements TableCellRefreshListener {
    protected static boolean separate_prot_data_stats;
    protected static boolean data_stats_only;

    public DownItem(String table_id) {
        super("download", 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long sort_value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long data_value = 0L;
        long prot_value = 0L;
        if (peer != null) {
            data_value = peer.getStats().getTotalDataBytesReceived();
            prot_value = peer.getStats().getTotalProtocolBytesReceived();
        }
        if (!cell.setSortValue(sort_value = separate_prot_data_stats ? (data_value << 24) + prot_value : (data_stats_only ? data_value : data_value + prot_value)) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatDataProtByteCountToKiBEtc(data_value, prot_value));
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"config.style.dataStatsOnly", "config.style.separateProtDataStats"}, new ParameterListener(){

            public void parameterChanged(String x) {
                separate_prot_data_stats = COConfigurationManager.getBooleanParameter("config.style.separateProtDataStats");
                data_stats_only = COConfigurationManager.getBooleanParameter("config.style.dataStatsOnly");
            }
        });
    }
}

