/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PeerByteIDItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PeerByteIDItem(String table_id) {
        super("peer_byte_id", -1, 100, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            cell.setText("");
            return;
        }
        byte[] peer_id = peer.getId();
        if (peer_id == null) {
            cell.setText("");
            return;
        }
        cell.setText(ByteFormatter.nicePrint(peer_id));
    }
}

