/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PiecesItem
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener,
DiskManagerListener {
    private static final int INDEX_COLOR_FADEDSTARTS = 10;
    private static final int borderHorizontalSize = 1;
    private static final int borderVerticalSize = 1;
    private static final int borderSplit = 1;
    private static final int completionHeight = 2;
    private List listDMs = new ArrayList(1);
    private AEMonitor listDM_mon = new AEMonitor("piecesitem");

    public PiecesItem(String table_id) {
        super("pieces", table_id);
        this.initializeAsGraphic(-2, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellAdded(TableCell cell) {
        PEPeer peer;
        DiskManager diskmanager;
        cell.setFillCell(true);
        Object ds = cell.getDataSource();
        if (ds instanceof PEPeer && (diskmanager = (peer = (PEPeer)ds).getManager().getDiskManager()) != null) {
            try {
                this.listDM_mon.enter();
                if (!this.listDMs.contains(diskmanager)) {
                    diskmanager.addListener(this);
                    this.listDMs.add(diskmanager);
                }
            }
            finally {
                this.listDM_mon.exit();
            }
        }
    }

    public void dispose(TableCell cell) {
        PEPeer infoObj = (PEPeer)cell.getDataSource();
        if (infoObj == null) {
            return;
        }
        Image img = (Image)infoObj.getData("PiecesImage");
        if (img != null && !img.isDisposed()) {
            img.dispose();
        }
        infoObj.setData("PiecesImageBuffer", null);
        infoObj.setData("PiecesImage", null);
    }

    public void refresh(TableCell cell) {
        boolean established;
        GC gcImage;
        Rectangle imageBounds;
        boolean bImageChanged;
        long lCompleted;
        PEPeer infoObj = (PEPeer)cell.getDataSource();
        long l = lCompleted = infoObj == null ? 0L : (long)infoObj.getPercentDoneInThousandNotation();
        if (!cell.setSortValue(lCompleted) && cell.isValid()) {
            return;
        }
        if (infoObj == null) {
            return;
        }
        int newWidth = cell.getWidth();
        if (newWidth <= 0) {
            return;
        }
        int newHeight = cell.getHeight();
        int x0 = 1;
        int x1 = newWidth - 1 - 1;
        int y0 = 4;
        int y1 = newHeight - 1 - 1;
        int drawWidth = x1 - x0 + 1;
        if (drawWidth < 10 || y1 < 3) {
            return;
        }
        int[] imageBuffer = (int[])infoObj.getData("PiecesImageBuffer");
        boolean bImageBufferValid = imageBuffer != null && imageBuffer.length == drawWidth;
        Image image = (Image)infoObj.getData("PiecesImage");
        if (image == null || image.isDisposed()) {
            bImageChanged = true;
        } else {
            imageBounds = image.getBounds();
            boolean bl = bImageChanged = imageBounds.width != newWidth || imageBounds.height != newHeight;
        }
        if (bImageChanged) {
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            image = new Image((Device)SWTThread.getInstance().getDisplay(), newWidth, newHeight);
            imageBounds = image.getBounds();
            bImageBufferValid = false;
            gcImage = new GC((Drawable)image);
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
            gcImage.setForeground(Colors.white);
            gcImage.drawLine(x0, 3, x1, 3);
        } else {
            gcImage = new GC((Drawable)image);
        }
        BitFlags peerHave = infoObj.getAvailable();
        boolean bl = established = ((PEPeerTransport)infoObj).getConnectionState() == 4;
        if (established && peerHave != null && peerHave.flags.length > 0) {
            if (imageBuffer == null || imageBuffer.length != drawWidth) {
                imageBuffer = new int[drawWidth];
            }
            boolean[] available = peerHave.flags;
            try {
                int limit;
                int nbComplete = 0;
                int nbPieces = available.length;
                DiskManager disk_manager = infoObj.getManager().getDiskManager();
                DiskManagerPiece[] pieces = disk_manager == null ? null : disk_manager.getPieces();
                int a1 = 0;
                for (int i = 0; i < drawWidth; ++i) {
                    int index;
                    int a0;
                    if (i == 0) {
                        a0 = 0;
                        a1 = nbPieces / drawWidth;
                        if (a1 == 0) {
                            a1 = 1;
                        }
                    } else {
                        a0 = a1;
                        a1 = (i + 1) * nbPieces / drawWidth;
                    }
                    int nbNeeded = 0;
                    if (a1 <= a0) {
                        index = imageBuffer[i - 1];
                    } else {
                        int nbAvailable = 0;
                        for (int j = a0; j < a1; ++j) {
                            if (!available[j]) continue;
                            if (pieces == null || !pieces[j].isDone()) {
                                ++nbNeeded;
                            }
                            ++nbAvailable;
                        }
                        nbComplete += nbAvailable;
                        index = nbAvailable * 9 / (a1 - a0);
                        if (nbNeeded <= nbAvailable / 2) {
                            index += 10;
                        }
                    }
                    if (imageBuffer[i] == index) continue;
                    imageBuffer[i] = index;
                    if (!bImageBufferValid) continue;
                    bImageChanged = true;
                    if (imageBuffer[i] >= 10) {
                        gcImage.setForeground(Colors.faded[index - 10]);
                    } else {
                        gcImage.setForeground(Colors.blues[index]);
                    }
                    gcImage.drawLine(i + x0, y0, i + x0, y1);
                }
                if (!bImageBufferValid && established) {
                    int iLastIndex = imageBuffer[0];
                    int iWidth = 1;
                    for (int i = 1; i < drawWidth; ++i) {
                        if (iLastIndex == imageBuffer[i]) {
                            ++iWidth;
                            continue;
                        }
                        if (iLastIndex >= 10) {
                            gcImage.setBackground(Colors.faded[iLastIndex - 10]);
                        } else {
                            gcImage.setBackground(Colors.blues[iLastIndex]);
                        }
                        gcImage.fillRectangle(i - iWidth + x0, y0, iWidth, y1 - y0 + 1);
                        iWidth = 1;
                        iLastIndex = imageBuffer[i];
                    }
                    if (iLastIndex >= 10) {
                        gcImage.setBackground(Colors.faded[iLastIndex - 10]);
                    } else {
                        gcImage.setBackground(Colors.blues[iLastIndex]);
                    }
                    gcImage.fillRectangle(x1 - iWidth + 1, y0, iWidth, y1 - y0 + 1);
                    bImageChanged = true;
                }
                if ((limit = drawWidth * nbComplete / nbPieces) < drawWidth) {
                    gcImage.setBackground(Colors.blues[0]);
                    gcImage.fillRectangle(limit + x0, 1, x1 - limit, 2);
                }
                gcImage.setBackground(Colors.colorProgressBar);
                gcImage.fillRectangle(x0, 1, limit, 2);
            }
            catch (Exception e) {
                System.out.println("Error Drawing PiecesItem");
                Debug.printStackTrace(e);
            }
        } else {
            gcImage.setForeground(Colors.grey);
            gcImage.setBackground(Colors.grey);
            gcImage.fillRectangle(x0, y0, newWidth, y1);
        }
        gcImage.dispose();
        Image oldImage = null;
        Graphic graphic = cell.getGraphic();
        if (graphic instanceof UISWTGraphic) {
            oldImage = ((UISWTGraphic)graphic).getImage();
        }
        if (bImageChanged || image != oldImage || !cell.isValid()) {
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).setGraphic(image);
            } else {
                cell.setGraphic(new UISWTGraphicImpl(image));
            }
            if (bImageChanged || image != oldImage) {
                cell.invalidate();
            }
            infoObj.setData("PiecesImage", image);
            infoObj.setData("PiecesImageBuffer", imageBuffer);
        }
    }

    public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
    }

    public void filePriorityChanged(DiskManagerFileInfo file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pieceDoneChanged(DiskManagerPiece piece) {
        this.invalidateCells();
        DiskManager diskmanager = piece.getManager();
        if (diskmanager.getRemaining() == 0L) {
            diskmanager.removeListener(this);
            try {
                this.listDM_mon.enter();
                this.listDMs.remove(diskmanager);
            }
            finally {
                this.listDM_mon.exit();
            }
        }
    }

    public void stateChanged(int oldState, int newState) {
    }
}

