/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class TimeToSendPieceItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public TimeToSendPieceItem(String table_id) {
        super("timetosend", 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        long value = peer == null ? 0L : (long)peer.getUploadHint();
        Comparable sortValue = cell.getSortValue();
        long oldValue = 0L;
        if (sortValue instanceof Number) {
            oldValue = ((Number)((Object)sortValue)).longValue();
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        String text = TimeFormatter.format(value / 1000L);
        if (oldValue > 0L) {
            text = text + ", " + TimeFormatter.format(oldValue / 1000L);
        }
        cell.setText(text);
    }
}

