/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginInterface;

public class UpdaterUtils {
    protected static String AZUPDATER_PLUGIN_ID = "azupdater";
    protected static String AZUPNPAV_PLUGIN_ID = "azupnpav";

    public static boolean disableNativeCode(String version) {
        try {
            File plugin_dir = null;
            File shared_plugin_dir = FileUtil.getApplicationFile("plugins");
            File shared_updater_plugin = new File(shared_plugin_dir, AZUPDATER_PLUGIN_ID);
            if (shared_updater_plugin.exists()) {
                plugin_dir = shared_updater_plugin;
            }
            if (plugin_dir == null) {
                return false;
            }
            return new File(plugin_dir, "disnat" + version).exists();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void checkBootstrapPlugins() {
        try {
            File target_props = UpdaterUtils.getPropsIfNotPresent(AZUPDATER_PLUGIN_ID, true);
            if (target_props != null) {
                UpdaterUtils.writePluginProperties(target_props, new String[]{"plugin.class=org.gudy.azureus2.update.UpdaterUpdateChecker;org.gudy.azureus2.update.UpdaterPatcher", "plugin.name=Azureus Update Support;Azureus Updater Support Patcher"});
            }
            if ((target_props = UpdaterUtils.getPropsIfNotPresent(AZUPNPAV_PLUGIN_ID, false)) != null) {
                UpdaterUtils.writePluginProperties(target_props, new String[]{"plugin.class=com.aelitis.azureus.plugins.upnpmediaserver.UPnPMediaServer", "plugin.name=UPnP Media Server", "plugin.id=azupnpav"});
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean ensurePluginPresent(String id, String cla, String name) {
        File target_props = UpdaterUtils.getPropsIfNotPresent(id, false);
        if (target_props != null) {
            UpdaterUtils.writePluginProperties(target_props, new String[]{"plugin.class=" + cla, "plugin.name=" + name, "plugin.id=" + id});
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writePluginProperties(File target, String[] lines) {
        try {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(target));
                for (int i = 0; i < lines.length; ++i) {
                    pw.println(lines[i]);
                }
                pw.println("plugin.install_if_missing=yes");
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
            if (!target.exists()) {
                throw new Exception("Failed to write '" + target.toString() + "'");
            }
        }
        catch (Throwable e) {
            Logger.log(new LogAlert(false, "Plugin bootstrap: initialisation error for " + target, e));
        }
    }

    protected static File getPropsIfNotPresent(String id, boolean use_shared) {
        File user_plugin_dir = FileUtil.getUserFile("plugins");
        File user_plugin = new File(user_plugin_dir, id);
        File user_props = new File(user_plugin, "plugin.properties");
        if (user_props.exists()) {
            return null;
        }
        File shared_plugin_dir = FileUtil.getApplicationFile("plugins");
        File shared_plugin = new File(shared_plugin_dir, id);
        File shared_props = new File(shared_plugin, "plugin.properties");
        if (shared_props.exists()) {
            return null;
        }
        if (use_shared) {
            FileUtil.mkdirs(shared_plugin);
            return shared_props;
        }
        FileUtil.mkdirs(user_plugin);
        return user_props;
    }

    public static String getUpdaterPluginVersion() {
        try {
            String version;
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(AZUPDATER_PLUGIN_ID, false);
            if (pi != null && (version = pi.getPluginVersion()) != null) {
                return version;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "0";
    }
}

