/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.AppFileLocProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.DownloadFactory;
import org.eclipse.swt.browser.DownloadFactory_1_8;
import org.eclipse.swt.browser.FilePickerFactory;
import org.eclipse.swt.browser.FilePickerFactory_1_8;
import org.eclipse.swt.browser.HelperAppLauncherDialogFactory;
import org.eclipse.swt.browser.InputStream;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.MozillaDelegate;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.PromptService2Factory;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowCreator2;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.mozilla.GREVersionRange;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMInit;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsIAppShell;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsICategoryManager;
import org.eclipse.swt.internal.mozilla.nsIComponentManager;
import org.eclipse.swt.internal.mozilla.nsIComponentRegistrar;
import org.eclipse.swt.internal.mozilla.nsIContextMenuListener;
import org.eclipse.swt.internal.mozilla.nsICookie;
import org.eclipse.swt.internal.mozilla.nsICookieManager;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDOMEvent;
import org.eclipse.swt.internal.mozilla.nsIDOMEventTarget;
import org.eclipse.swt.internal.mozilla.nsIDOMKeyEvent;
import org.eclipse.swt.internal.mozilla.nsIDOMMouseEvent;
import org.eclipse.swt.internal.mozilla.nsIDOMSerializer;
import org.eclipse.swt.internal.mozilla.nsIDOMSerializer_1_7;
import org.eclipse.swt.internal.mozilla.nsIDOMWindow;
import org.eclipse.swt.internal.mozilla.nsIDOMWindowCollection;
import org.eclipse.swt.internal.mozilla.nsIDirectoryService;
import org.eclipse.swt.internal.mozilla.nsIDocShell;
import org.eclipse.swt.internal.mozilla.nsIDocShell_1_8;
import org.eclipse.swt.internal.mozilla.nsIDocShell_1_9;
import org.eclipse.swt.internal.mozilla.nsIEmbeddingSiteWindow;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsIIOService;
import org.eclipse.swt.internal.mozilla.nsIInterfaceRequestor;
import org.eclipse.swt.internal.mozilla.nsIJSContextStack;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsIObserverService;
import org.eclipse.swt.internal.mozilla.nsIPrefBranch;
import org.eclipse.swt.internal.mozilla.nsIPrefLocalizedString;
import org.eclipse.swt.internal.mozilla.nsIPrefService;
import org.eclipse.swt.internal.mozilla.nsIProperties;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISimpleEnumerator;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipse.swt.internal.mozilla.nsITooltipListener;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIURIContentListener;
import org.eclipse.swt.internal.mozilla.nsIWeakReference;
import org.eclipse.swt.internal.mozilla.nsIWebBrowser;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChromeFocus;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserFocus;
import org.eclipse.swt.internal.mozilla.nsIWebNavigation;
import org.eclipse.swt.internal.mozilla.nsIWebNavigationInfo;
import org.eclipse.swt.internal.mozilla.nsIWebProgress;
import org.eclipse.swt.internal.mozilla.nsIWebProgressListener;
import org.eclipse.swt.internal.mozilla.nsIWindowWatcher;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

class Mozilla
extends WebBrowser {
    int embedHandle;
    nsIWebBrowser webBrowser;
    Object webBrowserObject;
    MozillaDelegate delegate;
    XPCOMObject supports;
    XPCOMObject weakReference;
    XPCOMObject webProgressListener;
    XPCOMObject webBrowserChrome;
    XPCOMObject webBrowserChromeFocus;
    XPCOMObject embeddingSiteWindow;
    XPCOMObject interfaceRequestor;
    XPCOMObject supportsWeakReference;
    XPCOMObject contextMenuListener;
    XPCOMObject uriContentListener;
    XPCOMObject tooltipListener;
    XPCOMObject domEventListener;
    int chromeFlags = 1;
    int refCount;
    int lastKeyCode;
    int lastCharCode;
    int request;
    Point location;
    Point size;
    boolean visible;
    boolean isChild;
    boolean ignoreDispose;
    Shell tip = null;
    Listener listener;
    Vector unhookedDOMWindows = new Vector();
    static nsIAppShell AppShell;
    static AppFileLocProvider LocationProvider;
    static WindowCreator2 WindowCreator;
    static int BrowserCount;
    static boolean Initialized;
    static boolean IsPre_1_8;
    static boolean PerformedVersionCheck;
    static boolean XPCOMWasGlued;
    static boolean XPCOMInitWasGlued;
    static final String GRERANGE_LOWER = "1.8.1.2";
    static final String GRERANGE_LOWER_FALLBACK = "1.8";
    static final boolean LowerRangeInclusive = true;
    static final String GRERANGE_UPPER = "1.9.*";
    static final boolean UpperRangeInclusive = true;
    static final int MAX_PORT = 65535;
    static final String SEPARATOR_OS;
    static final String ABOUT_BLANK = "about:blank";
    static final String DISPOSE_LISTENER_HOOKED = "org.eclipse.swt.browser.Mozilla.disposeListenerHooked";
    static final String PREFERENCE_CHARSET = "intl.charset.default";
    static final String PREFERENCE_DISABLEOPENDURINGLOAD = "dom.disable_open_during_load";
    static final String PREFERENCE_DISABLEWINDOWSTATUSCHANGE = "dom.disable_window_status_change";
    static final String PREFERENCE_LANGUAGES = "intl.accept_languages";
    static final String PREFERENCE_PROXYHOST_FTP = "network.proxy.ftp";
    static final String PREFERENCE_PROXYPORT_FTP = "network.proxy.ftp_port";
    static final String PREFERENCE_PROXYHOST_HTTP = "network.proxy.http";
    static final String PREFERENCE_PROXYPORT_HTTP = "network.proxy.http_port";
    static final String PREFERENCE_PROXYHOST_SSL = "network.proxy.ssl";
    static final String PREFERENCE_PROXYPORT_SSL = "network.proxy.ssl_port";
    static final String PREFERENCE_PROXYTYPE = "network.proxy.type";
    static final String PROFILE_AFTER_CHANGE = "profile-after-change";
    static final String PROFILE_BEFORE_CHANGE = "profile-before-change";
    static final String PROFILE_DIR;
    static final String PROFILE_DO_CHANGE = "profile-do-change";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String SEPARATOR_LOCALE = "-";
    static final String SHUTDOWN_PERSIST = "shutdown-persist";
    static final String STARTUP = "startup";
    static final String TOKENIZER_LOCALE = ",";
    static final String URI_FROMMEMORY = "file:///";
    static final String GRE_INITIALIZED = "org.eclipse.swt.browser.XULRunnerInitialized";
    static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath";
    static /* synthetic */ Class class$0;

    static {
        SEPARATOR_OS = System.getProperty("file.separator");
        PROFILE_DIR = String.valueOf(SEPARATOR_OS) + "eclipse" + SEPARATOR_OS;
        MozillaClearSessions = new Runnable(){

            public void run() {
                if (!Initialized) {
                    return;
                }
                int[] result = new int[1];
                int rc = XPCOM.NS_GetServiceManager(result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
                result[0] = 0;
                byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/cookiemanager;1", true);
                rc = serviceManager.GetServiceByContractID(aContractID, nsICookieManager.NS_ICOOKIEMANAGER_IID, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                serviceManager.Release();
                nsICookieManager manager = new nsICookieManager(result[0]);
                result[0] = 0;
                rc = manager.GetEnumerator(result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                manager.Release();
                nsISimpleEnumerator enumerator = new nsISimpleEnumerator(result[0]);
                boolean[] moreElements = new boolean[1];
                rc = enumerator.HasMoreElements(moreElements);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                while (moreElements[0]) {
                    result[0] = 0;
                    rc = enumerator.GetNext(result);
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    nsICookie cookie = new nsICookie(result[0]);
                    long[] expires = new long[1];
                    rc = cookie.GetExpires(expires);
                    if (expires[0] == 0L) {
                        int domain = XPCOM.nsEmbedCString_new();
                        int name = XPCOM.nsEmbedCString_new();
                        int path = XPCOM.nsEmbedCString_new();
                        cookie.GetHost(domain);
                        cookie.GetName(name);
                        cookie.GetPath(path);
                        rc = manager.Remove(domain, name, path, false);
                        XPCOM.nsEmbedCString_delete(domain);
                        XPCOM.nsEmbedCString_delete(name);
                        XPCOM.nsEmbedCString_delete(path);
                        if (rc != 0) {
                            Mozilla.error(rc);
                        }
                    }
                    cookie.Release();
                    rc = enumerator.HasMoreElements(moreElements);
                    if (rc == 0) continue;
                    Mozilla.error(rc);
                }
                enumerator.Release();
            }
        };
    }

    Mozilla() {
    }

    public void create(Composite parent, int style) {
        this.delegate = new MozillaDelegate(this.browser);
        Display display = parent.getDisplay();
        int[] result = new int[1];
        if (!Initialized) {
            int length;
            int rc;
            String mozillaPath;
            boolean initLoaded = false;
            boolean IsXULRunner = false;
            String greInitialized = System.getProperty(GRE_INITIALIZED);
            if ("true".equals(greInitialized)) {
                Initialized = true;
            }
            if ((mozillaPath = System.getProperty(XULRUNNER_PATH)) == null) {
                try {
                    String libName = this.delegate.getSWTInitLibraryName();
                    Library.loadLibrary(libName);
                    initLoaded = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            } else {
                mozillaPath = String.valueOf(mozillaPath) + SEPARATOR_OS + this.delegate.getLibraryName();
                IsXULRunner = true;
            }
            if (initLoaded) {
                GREVersionRange range = new GREVersionRange();
                byte[] bytes = MozillaDelegate.wcsToMbcs(null, GRERANGE_LOWER, true);
                int lower = C.malloc(bytes.length);
                C.memmove(lower, bytes, bytes.length);
                range.lower = lower;
                range.lowerInclusive = true;
                bytes = MozillaDelegate.wcsToMbcs(null, GRERANGE_UPPER, true);
                int upper = C.malloc(bytes.length);
                C.memmove(upper, bytes, bytes.length);
                range.upper = upper;
                range.upperInclusive = true;
                int length2 = 4096;
                int greBuffer = C.malloc(length2);
                int propertiesPtr = C.malloc(2 * C.PTR_SIZEOF);
                int rc2 = XPCOMInit.GRE_GetGREPathWithProperties(range, 1, propertiesPtr, 0, greBuffer, length2);
                if (rc2 != 0) {
                    C.free(lower);
                    bytes = MozillaDelegate.wcsToMbcs(null, GRERANGE_LOWER_FALLBACK, true);
                    lower = C.malloc(bytes.length);
                    C.memmove(lower, bytes, bytes.length);
                    range.lower = lower;
                    rc2 = XPCOMInit.GRE_GetGREPathWithProperties(range, 1, propertiesPtr, 0, greBuffer, length2);
                }
                C.free(lower);
                C.free(upper);
                C.free(propertiesPtr);
                if (rc2 == 0) {
                    length2 = C.strlen(greBuffer);
                    bytes = new byte[length2];
                    C.memmove(bytes, greBuffer, length2);
                    mozillaPath = new String(MozillaDelegate.mbcsToWcs(null, bytes));
                    boolean bl = IsXULRunner = mozillaPath.length() > 0;
                    if (IsXULRunner) {
                        byte[] path = MozillaDelegate.wcsToMbcs(null, mozillaPath, true);
                        rc2 = XPCOMInit.XPCOMGlueStartup(path);
                        if (rc2 != 0) {
                            IsXULRunner = false;
                            mozillaPath = mozillaPath.substring(0, mozillaPath.lastIndexOf(SEPARATOR_OS));
                            if (Device.DEBUG) {
                                System.out.println("cannot use detected XULRunner: " + mozillaPath);
                            }
                        } else {
                            XPCOMInitWasGlued = true;
                        }
                    }
                }
                C.free(greBuffer);
            }
            if (IsXULRunner) {
                if (Device.DEBUG) {
                    System.out.println("XULRunner path: " + mozillaPath);
                }
                try {
                    Library.loadLibrary("swt-xulrunner");
                }
                catch (UnsatisfiedLinkError e) {
                    SWT.error(2, e);
                }
                byte[] path = MozillaDelegate.wcsToMbcs(null, mozillaPath, true);
                int rc3 = XPCOM.XPCOMGlueStartup(path);
                if (rc3 != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc3);
                }
                XPCOMWasGlued = true;
                mozillaPath = mozillaPath.substring(0, mozillaPath.lastIndexOf(SEPARATOR_OS));
            } else {
                int ptr;
                if ((style & 0x8000) != 0) {
                    this.browser.dispose();
                    String errorString = mozillaPath != null && mozillaPath.length() > 0 ? " [Failed to use detected XULRunner: " + mozillaPath + "]" : " [Could not detect registered XULRunner to use]";
                    SWT.error(2, null, errorString);
                }
                if ((ptr = C.getenv(MozillaDelegate.wcsToMbcs(null, "MOZILLA_FIVE_HOME", true))) != 0) {
                    int length3 = C.strlen(ptr);
                    byte[] buffer = new byte[length3];
                    C.memmove(buffer, ptr, length3);
                    mozillaPath = new String(MozillaDelegate.mbcsToWcs(null, buffer));
                } else {
                    this.browser.dispose();
                    SWT.error(2, null, " [Unknown Mozilla path (MOZILLA_FIVE_HOME not set)]");
                }
                if (Device.DEBUG) {
                    System.out.println("Mozilla path: " + mozillaPath);
                }
                if (Compatibility.fileExists(mozillaPath, "components/libwidget_gtk.so")) {
                    this.browser.dispose();
                    SWT.error(2, null, " [Mozilla GTK2 required (GTK1.2 detected)]");
                }
                try {
                    Library.loadLibrary("swt-mozilla");
                }
                catch (UnsatisfiedLinkError e) {
                    try {
                        Library.loadLibrary("swt-mozilla-gcc3");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        this.browser.dispose();
                        SWT.error(2, e);
                    }
                }
            }
            if (!Initialized) {
                int[] retVal = new int[1];
                nsEmbedString pathString = new nsEmbedString(mozillaPath);
                int rc4 = XPCOM.NS_NewLocalFile(pathString.getAddress(), true, retVal);
                pathString.dispose();
                if (rc4 != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc4);
                }
                if (retVal[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467261);
                }
                LocationProvider = new AppFileLocProvider(mozillaPath);
                LocationProvider.AddRef();
                nsILocalFile localFile = new nsILocalFile(retVal[0]);
                rc4 = XPCOM.NS_InitXPCOM2(0, localFile.getAddress(), LocationProvider.getAddress());
                localFile.Release();
                if (rc4 != 0) {
                    this.browser.dispose();
                    SWT.error(2, null, " [MOZILLA_FIVE_HOME may not point at an embeddable GRE] [NS_InitEmbedding " + mozillaPath + " error " + rc4 + "]");
                }
                System.setProperty(GRE_INITIALIZED, "true");
                if (IsXULRunner) {
                    System.setProperty(XULRUNNER_PATH, mozillaPath);
                }
            }
            if (IsXULRunner) {
                try {
                    Class<?> clazz = Class.forName("org.mozilla.xpcom.Mozilla");
                    Method method = clazz.getMethod("getInstance", new Class[0]);
                    Object mozilla = method.invoke(null, new Object[0]);
                    method = clazz.getMethod("getComponentManager", new Class[0]);
                    try {
                        method.invoke(mozilla, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Class<?> fileClass = Class.forName("java.io.File");
                        method = clazz.getMethod("initialize", fileClass);
                        Class[] classArray = new Class[1];
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz2;
                        Constructor<?> constructor = fileClass.getDeclaredConstructor(classArray);
                        Object argument = constructor.newInstance(mozillaPath);
                        method.invoke(mozilla, argument);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InstantiationException instantiationException) {}
            }
            if ((rc = XPCOM.NS_GetComponentManager(result)) != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                this.browser.dispose();
                Mozilla.error(-2147467262);
            }
            nsIComponentManager componentManager = new nsIComponentManager(result[0]);
            result[0] = 0;
            if (this.delegate.needsSpinup()) {
                rc = componentManager.CreateInstance(XPCOM.NS_APPSHELL_CID, 0, nsIAppShell.NS_IAPPSHELL_IID, result);
                if (rc != -2147467262) {
                    if (rc != 0) {
                        this.browser.dispose();
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0) {
                        this.browser.dispose();
                        Mozilla.error(-2147467262);
                    }
                    if ((rc = (AppShell = new nsIAppShell(result[0])).Create(0, null)) != 0) {
                        this.browser.dispose();
                        Mozilla.error(rc);
                    }
                    if ((rc = AppShell.Spinup()) != 0) {
                        this.browser.dispose();
                        Mozilla.error(rc);
                    }
                }
                result[0] = 0;
            }
            WindowCreator = new WindowCreator2();
            WindowCreator.AddRef();
            rc = XPCOM.NS_GetServiceManager(result);
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                this.browser.dispose();
                Mozilla.error(-2147467262);
            }
            nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
            result[0] = 0;
            byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/embedcomp/window-watcher;1", true);
            rc = serviceManager.GetServiceByContractID(aContractID, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, result);
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                this.browser.dispose();
                Mozilla.error(-2147467262);
            }
            nsIWindowWatcher windowWatcher = new nsIWindowWatcher(result[0]);
            result[0] = 0;
            rc = windowWatcher.SetWindowCreator(WindowCreator.getAddress());
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            windowWatcher.Release();
            if (LocationProvider != null) {
                byte[] buffer = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/file/directory_service;1", true);
                rc = serviceManager.GetServiceByContractID(buffer, nsIDirectoryService.NS_IDIRECTORYSERVICE_IID, result);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                nsIDirectoryService directoryService = new nsIDirectoryService(result[0]);
                result[0] = 0;
                rc = directoryService.QueryInterface(nsIProperties.NS_IPROPERTIES_IID, result);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                directoryService.Release();
                nsIProperties properties = new nsIProperties(result[0]);
                result[0] = 0;
                buffer = MozillaDelegate.wcsToMbcs(null, "AppRegD", true);
                rc = properties.Get(buffer, nsIFile.NS_IFILE_IID, result);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                properties.Release();
                nsIFile profileDir = new nsIFile(result[0]);
                result[0] = 0;
                int path = XPCOM.nsEmbedCString_new();
                rc = profileDir.GetNativePath(path);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                length = XPCOM.nsEmbedCString_Length(path);
                int ptr = XPCOM.nsEmbedCString_get(path);
                buffer = new byte[length];
                XPCOM.memmove(buffer, ptr, length);
                String profilePath = String.valueOf(new String(MozillaDelegate.mbcsToWcs(null, buffer))) + PROFILE_DIR;
                LocationProvider.setProfilePath(profilePath);
                XPCOM.nsEmbedCString_delete(path);
                profileDir.Release();
                buffer = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/observer-service;1", true);
                rc = serviceManager.GetServiceByContractID(buffer, nsIObserverService.NS_IOBSERVERSERVICE_IID, result);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                nsIObserverService observerService = new nsIObserverService(result[0]);
                result[0] = 0;
                buffer = MozillaDelegate.wcsToMbcs(null, PROFILE_DO_CHANGE, true);
                length = STARTUP.length();
                char[] chars = new char[length + 1];
                STARTUP.getChars(0, length, chars, 0);
                rc = observerService.NotifyObservers(0, buffer, chars);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if ((rc = observerService.NotifyObservers(0, buffer = MozillaDelegate.wcsToMbcs(null, PROFILE_AFTER_CHANGE, true), chars)) != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                observerService.Release();
            }
            aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/preferences-service;1", true);
            rc = serviceManager.GetServiceByContractID(aContractID, nsIPrefService.NS_IPREFSERVICE_IID, result);
            serviceManager.Release();
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                this.browser.dispose();
                Mozilla.error(-2147467262);
            }
            nsIPrefService prefService = new nsIPrefService(result[0]);
            result[0] = 0;
            byte[] buffer = new byte[1];
            rc = prefService.GetBranch(buffer, result);
            prefService.Release();
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                this.browser.dispose();
                Mozilla.error(-2147467262);
            }
            nsIPrefBranch prefBranch = new nsIPrefBranch(result[0]);
            result[0] = 0;
            String prefLocales = null;
            nsIPrefLocalizedString localizedString = null;
            buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_LANGUAGES, true);
            rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
            if (rc != 0) {
                prefLocales = "en-us,en,";
            } else {
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                localizedString = new nsIPrefLocalizedString(result[0]);
                result[0] = 0;
                rc = localizedString.ToString(result);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                length = XPCOM.strlen_PRUnichar(result[0]);
                char[] dest = new char[length];
                XPCOM.memmove(dest, result[0], length * 2);
                prefLocales = String.valueOf(new String(dest)) + TOKENIZER_LOCALE;
            }
            result[0] = 0;
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            StringBuffer stringBuffer = new StringBuffer(language);
            stringBuffer.append(SEPARATOR_LOCALE);
            stringBuffer.append(country.toLowerCase());
            stringBuffer.append(TOKENIZER_LOCALE);
            stringBuffer.append(language);
            stringBuffer.append(TOKENIZER_LOCALE);
            String newLocales = stringBuffer.toString();
            int end = -1;
            do {
                int start;
                String token = (end = prefLocales.indexOf(TOKENIZER_LOCALE, start = end + 1)) == -1 ? prefLocales.substring(start) : prefLocales.substring(start, end);
                if (token.length() <= 0 || newLocales.indexOf(token = (String.valueOf(token) + TOKENIZER_LOCALE).trim()) != -1) continue;
                stringBuffer.append(token);
            } while (end != -1);
            newLocales = stringBuffer.toString();
            if (!newLocales.equals(prefLocales)) {
                newLocales = newLocales.substring(0, newLocales.length() - TOKENIZER_LOCALE.length());
                int length4 = newLocales.length();
                char[] charBuffer = new char[length4 + 1];
                newLocales.getChars(0, length4, charBuffer, 0);
                if (localizedString == null) {
                    byte[] contractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/pref-localizedstring;1", true);
                    rc = componentManager.CreateInstanceByContractID(contractID, 0, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
                    if (rc != 0) {
                        this.browser.dispose();
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0) {
                        this.browser.dispose();
                        Mozilla.error(-2147467262);
                    }
                    localizedString = new nsIPrefLocalizedString(result[0]);
                    result[0] = 0;
                }
                localizedString.SetDataWithLength(length4, charBuffer);
                rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
            }
            if (localizedString != null) {
                localizedString.Release();
                localizedString = null;
            }
            String prefCharset = null;
            buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_CHARSET, true);
            rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
            if (rc != 0) {
                prefCharset = "ISO-8859-1";
            } else {
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                localizedString = new nsIPrefLocalizedString(result[0]);
                result[0] = 0;
                rc = localizedString.ToString(result);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                int length5 = XPCOM.strlen_PRUnichar(result[0]);
                char[] dest = new char[length5];
                XPCOM.memmove(dest, result[0], length5 * 2);
                prefCharset = new String(dest);
            }
            result[0] = 0;
            String newCharset = System.getProperty("file.encoding");
            if (!newCharset.equals(prefCharset)) {
                int length6 = newCharset.length();
                char[] charBuffer = new char[length6 + 1];
                newCharset.getChars(0, length6, charBuffer, 0);
                if (localizedString == null) {
                    byte[] contractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/pref-localizedstring;1", true);
                    rc = componentManager.CreateInstanceByContractID(contractID, 0, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
                    if (rc != 0) {
                        this.browser.dispose();
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0) {
                        this.browser.dispose();
                        Mozilla.error(-2147467262);
                    }
                    localizedString = new nsIPrefLocalizedString(result[0]);
                    result[0] = 0;
                }
                localizedString.SetDataWithLength(length6, charBuffer);
                rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
            }
            if (localizedString != null) {
                localizedString.Release();
            }
            String proxyHost = System.getProperty(PROPERTY_PROXYHOST);
            String proxyPortString = System.getProperty(PROPERTY_PROXYPORT);
            int port = -1;
            if (proxyPortString != null) {
                try {
                    int value = Integer.valueOf(proxyPortString);
                    if (value >= 0 && value <= 65535) {
                        port = value;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (proxyHost != null) {
                byte[] contractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/pref-localizedstring;1", true);
                rc = componentManager.CreateInstanceByContractID(contractID, 0, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                localizedString = new nsIPrefLocalizedString(result[0]);
                result[0] = 0;
                int length7 = proxyHost.length();
                char[] charBuffer = new char[length7 + 1];
                proxyHost.getChars(0, length7, charBuffer, 0);
                rc = localizedString.SetDataWithLength(length7, charBuffer);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if ((rc = prefBranch.SetComplexValue(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_PROXYHOST_FTP, true), nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress())) != 0) {
                    Mozilla.error(rc);
                }
                if ((rc = prefBranch.SetComplexValue(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_PROXYHOST_HTTP, true), nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress())) != 0) {
                    Mozilla.error(rc);
                }
                if ((rc = prefBranch.SetComplexValue(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_PROXYHOST_SSL, true), nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress())) != 0) {
                    Mozilla.error(rc);
                }
                localizedString.Release();
            }
            if (port != -1) {
                buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_PROXYPORT_FTP, true);
                rc = prefBranch.SetIntPref(buffer, port);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if ((rc = prefBranch.SetIntPref(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_PROXYPORT_HTTP, true), port)) != 0) {
                    Mozilla.error(rc);
                }
                if ((rc = prefBranch.SetIntPref(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_PROXYPORT_SSL, true), port)) != 0) {
                    Mozilla.error(rc);
                }
            }
            if ((proxyHost != null || port != -1) && (rc = prefBranch.SetIntPref(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_PROXYTYPE, true), 1)) != 0) {
                Mozilla.error(rc);
            }
            if ((rc = prefBranch.SetBoolPref(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_DISABLEOPENDURINGLOAD, true), 0)) != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            if ((rc = prefBranch.SetBoolPref(buffer = MozillaDelegate.wcsToMbcs(null, PREFERENCE_DISABLEWINDOWSTATUSCHANGE, true), 0)) != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            prefBranch.Release();
            PromptService2Factory factory = new PromptService2Factory();
            factory.AddRef();
            rc = componentManager.QueryInterface(nsIComponentRegistrar.NS_ICOMPONENTREGISTRAR_IID, result);
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                this.browser.dispose();
                Mozilla.error(-2147467262);
            }
            nsIComponentRegistrar componentRegistrar = new nsIComponentRegistrar(result[0]);
            result[0] = 0;
            aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/embedcomp/prompt-service;1", true);
            byte[] aClassName = MozillaDelegate.wcsToMbcs(null, "Prompt Service", true);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_PROMPTSERVICE_CID, aClassName, aContractID, factory.getAddress());
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            factory.Release();
            HelperAppLauncherDialogFactory dialogFactory = new HelperAppLauncherDialogFactory();
            dialogFactory.AddRef();
            aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/helperapplauncherdialog;1", true);
            aClassName = MozillaDelegate.wcsToMbcs(null, "Helper App Launcher Dialog", true);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_HELPERAPPLAUNCHERDIALOG_CID, aClassName, aContractID, dialogFactory.getAddress());
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            dialogFactory.Release();
            DownloadFactory downloadFactory = new DownloadFactory();
            downloadFactory.AddRef();
            aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/download;1", true);
            aClassName = MozillaDelegate.wcsToMbcs(null, "Download", true);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_DOWNLOAD_CID, aClassName, aContractID, downloadFactory.getAddress());
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            downloadFactory.Release();
            FilePickerFactory pickerFactory = IsXULRunner ? new FilePickerFactory_1_8() : new FilePickerFactory();
            pickerFactory.AddRef();
            aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/filepicker;1", true);
            aClassName = MozillaDelegate.wcsToMbcs(null, "FilePicker", true);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_FILEPICKER_CID, aClassName, aContractID, pickerFactory.getAddress());
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(rc);
            }
            pickerFactory.Release();
            componentRegistrar.Release();
            componentManager.Release();
            Initialized = true;
        }
        if (display.getData(DISPOSE_LISTENER_HOOKED) == null) {
            display.setData(DISPOSE_LISTENER_HOOKED, DISPOSE_LISTENER_HOOKED);
            display.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    if (BrowserCount > 0) {
                        return;
                    }
                    int[] result = new int[1];
                    int rc = XPCOM.NS_GetServiceManager(result);
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0) {
                        Mozilla.error(-2147467262);
                    }
                    nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
                    result[0] = 0;
                    byte[] buffer = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/observer-service;1", true);
                    rc = serviceManager.GetServiceByContractID(buffer, nsIObserverService.NS_IOBSERVERSERVICE_IID, result);
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0) {
                        Mozilla.error(-2147467262);
                    }
                    serviceManager.Release();
                    nsIObserverService observerService = new nsIObserverService(result[0]);
                    result[0] = 0;
                    buffer = MozillaDelegate.wcsToMbcs(null, Mozilla.PROFILE_BEFORE_CHANGE, true);
                    int length = Mozilla.SHUTDOWN_PERSIST.length();
                    char[] chars = new char[length + 1];
                    Mozilla.SHUTDOWN_PERSIST.getChars(0, length, chars, 0);
                    rc = observerService.NotifyObservers(0, buffer, chars);
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    observerService.Release();
                    if (XPCOMWasGlued) {
                        XPCOM.XPCOMGlueShutdown();
                        XPCOMWasGlued = false;
                    }
                    if (XPCOMInitWasGlued) {
                        XPCOMInit.XPCOMGlueShutdown();
                        XPCOMInitWasGlued = false;
                    }
                    Initialized = false;
                }
            });
        }
        ++BrowserCount;
        int rc = XPCOM.NS_GetComponentManager(result);
        if (rc != 0) {
            this.browser.dispose();
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            this.browser.dispose();
            Mozilla.error(-2147467262);
        }
        nsIComponentManager componentManager = new nsIComponentManager(result[0]);
        result[0] = 0;
        nsID NS_IWEBBROWSER_CID = new nsID("F1EAC761-87E9-11d3-AF80-00A024FFC08C");
        rc = componentManager.CreateInstance(NS_IWEBBROWSER_CID, 0, nsIWebBrowser.NS_IWEBBROWSER_IID, result);
        if (rc != 0) {
            this.browser.dispose();
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            this.browser.dispose();
            Mozilla.error(-2147467262);
        }
        this.webBrowser = new nsIWebBrowser(result[0]);
        result[0] = 0;
        this.createCOMInterfaces();
        this.AddRef();
        rc = this.webBrowser.SetContainerWindow(this.webBrowserChrome.getAddress());
        if (rc != 0) {
            this.browser.dispose();
            Mozilla.error(rc);
        }
        if ((rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result)) != 0) {
            this.browser.dispose();
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            this.browser.dispose();
            Mozilla.error(-2147467262);
        }
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        result[0] = 0;
        Rectangle rect = this.browser.getClientArea();
        if (rect.isEmpty()) {
            rect.width = 1;
            rect.height = 1;
        }
        this.embedHandle = this.delegate.getHandle();
        rc = baseWindow.InitWindow(this.embedHandle, 0, 0, 0, rect.width, rect.height);
        if (rc != 0) {
            this.browser.dispose();
            Mozilla.error(-2147467259);
        }
        if ((rc = baseWindow.Create()) != 0) {
            this.browser.dispose();
            Mozilla.error(-2147467259);
        }
        if ((rc = baseWindow.SetVisibility(true)) != 0) {
            this.browser.dispose();
            Mozilla.error(-2147467259);
        }
        baseWindow.Release();
        if (!PerformedVersionCheck) {
            PerformedVersionCheck = true;
            rc = this.webBrowser.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
            if (rc != 0) {
                this.browser.dispose();
                Mozilla.error(-2147467259);
            }
            if (result[0] == 0) {
                this.browser.dispose();
                Mozilla.error(-2147467262);
            }
            nsIInterfaceRequestor interfaceRequestor = new nsIInterfaceRequestor(result[0]);
            result[0] = 0;
            rc = interfaceRequestor.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, result);
            if (rc == 0 && result[0] != 0) {
                IsPre_1_8 = true;
                new nsISupports(result[0]).Release();
            }
            result[0] = 0;
            if (!IsPre_1_8 && (rc = interfaceRequestor.GetInterface(nsIDocShell_1_8.NS_IDOCSHELL_IID, result)) == 0 && result[0] != 0) {
                new nsISupports(result[0]).Release();
                result[0] = 0;
                rc = componentManager.QueryInterface(nsIComponentRegistrar.NS_ICOMPONENTREGISTRAR_IID, result);
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    this.browser.dispose();
                    Mozilla.error(-2147467262);
                }
                nsIComponentRegistrar componentRegistrar = new nsIComponentRegistrar(result[0]);
                DownloadFactory_1_8 downloadFactory_1_8 = new DownloadFactory_1_8();
                downloadFactory_1_8.AddRef();
                byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/transfer;1", true);
                byte[] aClassName = MozillaDelegate.wcsToMbcs(null, "Transfer", true);
                rc = componentRegistrar.RegisterFactory(XPCOM.NS_DOWNLOAD_CID, aClassName, aContractID, downloadFactory_1_8.getAddress());
                if (rc != 0) {
                    this.browser.dispose();
                    Mozilla.error(rc);
                }
                downloadFactory_1_8.Release();
                componentRegistrar.Release();
            }
            result[0] = 0;
            interfaceRequestor.Release();
        }
        componentManager.Release();
        rc = this.webBrowser.AddWebBrowserListener(this.weakReference.getAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
        if (rc != 0) {
            this.browser.dispose();
            Mozilla.error(rc);
        }
        if ((rc = this.webBrowser.SetParentURIContentListener(this.uriContentListener.getAddress())) != 0) {
            this.browser.dispose();
            Mozilla.error(rc);
        }
        this.delegate.init();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (Mozilla.this.ignoreDispose) {
                            Mozilla.this.ignoreDispose = false;
                            break;
                        }
                        Mozilla.this.ignoreDispose = true;
                        Mozilla.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        Mozilla.this.onDispose(event.display);
                        break;
                    }
                    case 11: {
                        Mozilla.this.onResize();
                        break;
                    }
                    case 15: {
                        Mozilla.this.Activate();
                        break;
                    }
                    case 26: {
                        Mozilla.this.Activate();
                        break;
                    }
                    case 27: {
                        Display display = event.display;
                        if (Mozilla.this.browser != display.getFocusControl()) break;
                        Mozilla.this.Deactivate();
                        break;
                    }
                    case 22: {
                        Display display = event.display;
                        display.asyncExec(new Runnable(this){
                            final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (3.access$0(this.this$1).browser.isDisposed()) {
                                    return;
                                }
                                3.access$0(this.this$1).onResize();
                            }
                        });
                    }
                }
            }

            static /* synthetic */ Mozilla access$0(3 var0) {
                return var0.Mozilla.this;
            }
        };
        int[] folderEvents = new int[]{12, 11, 15, 26, 27, 22, 1};
        int i = 0;
        while (i < folderEvents.length) {
            this.browser.addListener(folderEvents[i], this.listener);
            ++i;
        }
    }

    public boolean back() {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.GoBack();
        webNavigation.Release();
        return rc == 0;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.QueryReferent(args[0], args[1]);
            }
        };
        int[] nArray3 = new int[8];
        nArray3[0] = 2;
        nArray3[3] = 4;
        nArray3[4] = 6;
        nArray3[5] = 3;
        nArray3[6] = 4;
        nArray3[7] = 3;
        this.webProgressListener = new XPCOMObject(nArray3){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            public int method4(int[] args) {
                return Mozilla.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public int method5(int[] args) {
                return Mozilla.this.OnLocationChange(args[0], args[1], args[2]);
            }

            public int method6(int[] args) {
                return Mozilla.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            public int method7(int[] args) {
                return Mozilla.this.OnSecurityChange(args[0], args[1], args[2]);
            }
        };
        int[] nArray4 = new int[13];
        nArray4[0] = 2;
        nArray4[3] = 2;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[9] = 2;
        nArray4[11] = 1;
        nArray4[12] = 1;
        this.webBrowserChrome = new XPCOMObject(nArray4){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.SetStatus(args[0], args[1]);
            }

            public int method4(int[] args) {
                return Mozilla.this.GetWebBrowser(args[0]);
            }

            public int method5(int[] args) {
                return Mozilla.this.SetWebBrowser(args[0]);
            }

            public int method6(int[] args) {
                return Mozilla.this.GetChromeFlags(args[0]);
            }

            public int method7(int[] args) {
                return Mozilla.this.SetChromeFlags(args[0]);
            }

            public int method8(int[] args) {
                return Mozilla.this.DestroyBrowserWindow();
            }

            public int method9(int[] args) {
                return Mozilla.this.SizeBrowserTo(args[0], args[1]);
            }

            public int method10(int[] args) {
                return Mozilla.this.ShowAsModal();
            }

            public int method11(int[] args) {
                return Mozilla.this.IsWindowModal(args[0]);
            }

            public int method12(int[] args) {
                return Mozilla.this.ExitModalEventLoop(args[0]);
            }
        };
        int[] nArray5 = new int[5];
        nArray5[0] = 2;
        this.webBrowserChromeFocus = new XPCOMObject(nArray5){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.FocusNextElement();
            }

            public int method4(int[] args) {
                return Mozilla.this.FocusPrevElement();
            }
        };
        int[] nArray6 = new int[11];
        nArray6[0] = 2;
        nArray6[3] = 5;
        nArray6[4] = 5;
        nArray6[6] = 1;
        nArray6[7] = 1;
        nArray6[8] = 1;
        nArray6[9] = 1;
        nArray6[10] = 1;
        this.embeddingSiteWindow = new XPCOMObject(nArray6){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.SetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method4(int[] args) {
                return Mozilla.this.GetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method5(int[] args) {
                return Mozilla.this.SetFocus();
            }

            public int method6(int[] args) {
                return Mozilla.this.GetVisibility(args[0]);
            }

            public int method7(int[] args) {
                return Mozilla.this.SetVisibility(args[0]);
            }

            public int method8(int[] args) {
                return Mozilla.this.GetTitle(args[0]);
            }

            public int method9(int[] args) {
                return Mozilla.this.SetTitle(args[0]);
            }

            public int method10(int[] args) {
                return Mozilla.this.GetSiteWindow(args[0]);
            }
        };
        int[] nArray7 = new int[4];
        nArray7[0] = 2;
        nArray7[3] = 2;
        this.interfaceRequestor = new XPCOMObject(nArray7){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.GetInterface(args[0], args[1]);
            }
        };
        int[] nArray8 = new int[4];
        nArray8[0] = 2;
        nArray8[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray8){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.GetWeakReference(args[0]);
            }
        };
        int[] nArray9 = new int[4];
        nArray9[0] = 2;
        nArray9[3] = 3;
        this.contextMenuListener = new XPCOMObject(nArray9){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.OnShowContextMenu(args[0], args[1], args[2]);
            }
        };
        int[] nArray10 = new int[11];
        nArray10[0] = 2;
        nArray10[3] = 2;
        nArray10[4] = 5;
        nArray10[5] = 3;
        nArray10[6] = 4;
        nArray10[7] = 1;
        nArray10[8] = 1;
        nArray10[9] = 1;
        nArray10[10] = 1;
        this.uriContentListener = new XPCOMObject(nArray10){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.OnStartURIOpen(args[0], args[1]);
            }

            public int method4(int[] args) {
                return Mozilla.this.DoContent(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method5(int[] args) {
                return Mozilla.this.IsPreferred(args[0], args[1], args[2]);
            }

            public int method6(int[] args) {
                return Mozilla.this.CanHandleContent(args[0], args[1], args[2], args[3]);
            }

            public int method7(int[] args) {
                return Mozilla.this.GetLoadCookie(args[0]);
            }

            public int method8(int[] args) {
                return Mozilla.this.SetLoadCookie(args[0]);
            }

            public int method9(int[] args) {
                return Mozilla.this.GetParentContentListener(args[0]);
            }

            public int method10(int[] args) {
                return Mozilla.this.SetParentContentListener(args[0]);
            }
        };
        int[] nArray11 = new int[5];
        nArray11[0] = 2;
        nArray11[3] = 3;
        this.tooltipListener = new XPCOMObject(nArray11){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.OnShowTooltip(args[0], args[1], args[2]);
            }

            public int method4(int[] args) {
                return Mozilla.this.OnHideTooltip();
            }
        };
        int[] nArray12 = new int[4];
        nArray12[0] = 2;
        nArray12[3] = 1;
        this.domEventListener = new XPCOMObject(nArray12){

            public int method0(int[] args) {
                return Mozilla.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Mozilla.this.AddRef();
            }

            public int method2(int[] args) {
                return Mozilla.this.Release();
            }

            public int method3(int[] args) {
                return Mozilla.this.HandleEvent(args[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.webProgressListener != null) {
            this.webProgressListener.dispose();
            this.webProgressListener = null;
        }
        if (this.webBrowserChrome != null) {
            this.webBrowserChrome.dispose();
            this.webBrowserChrome = null;
        }
        if (this.webBrowserChromeFocus != null) {
            this.webBrowserChromeFocus.dispose();
            this.webBrowserChromeFocus = null;
        }
        if (this.embeddingSiteWindow != null) {
            this.embeddingSiteWindow.dispose();
            this.embeddingSiteWindow = null;
        }
        if (this.interfaceRequestor != null) {
            this.interfaceRequestor.dispose();
            this.interfaceRequestor = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
        if (this.contextMenuListener != null) {
            this.contextMenuListener.dispose();
            this.contextMenuListener = null;
        }
        if (this.uriContentListener != null) {
            this.uriContentListener.dispose();
            this.uriContentListener = null;
        }
        if (this.tooltipListener != null) {
            this.tooltipListener.dispose();
            this.tooltipListener = null;
        }
        if (this.domEventListener != null) {
            this.domEventListener.dispose();
            this.domEventListener = null;
        }
    }

    public boolean execute(String script) {
        String LINE_COMMENT = "//";
        int index = script.indexOf(LINE_COMMENT);
        while (index != -1) {
            int endIndex1 = script.indexOf(13, index);
            int endIndex2 = script.indexOf(10, index);
            int endIndex = script.length();
            if (endIndex1 != -1) {
                endIndex = endIndex1;
            }
            if (endIndex2 != -1) {
                endIndex = Math.min(endIndex, endIndex2);
            }
            script = String.valueOf(script.substring(0, index)) + script.substring(endIndex);
            index = script.indexOf(LINE_COMMENT, index);
        }
        String url = "javascript:" + script + ";void(0);";
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        char[] arg = url.toCharArray();
        char[] c = new char[arg.length + 1];
        System.arraycopy(arg, 0, c, 0, arg.length);
        rc = webNavigation.LoadURI(c, 0, 0, 0, 0);
        webNavigation.Release();
        return rc == 0;
    }

    static Browser findBrowser(int handle) {
        return MozillaDelegate.findBrowser(handle);
    }

    public boolean forward() {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.GoForward();
        webNavigation.Release();
        return rc == 0;
    }

    public String getText() {
        int[] result = new int[1];
        int rc = this.webBrowser.GetContentDOMWindow(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMWindow window = new nsIDOMWindow(result[0]);
        result[0] = 0;
        rc = window.GetDocument(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        window.Release();
        int document = result[0];
        result[0] = 0;
        rc = XPCOM.NS_GetComponentManager(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIComponentManager componentManager = new nsIComponentManager(result[0]);
        result[0] = 0;
        byte[] contractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/xmlextras/xmlserializer;1", true);
        char[] chars = null;
        rc = componentManager.CreateInstanceByContractID(contractID, 0, nsIDOMSerializer_1_7.NS_IDOMSERIALIZER_IID, result);
        if (rc == 0) {
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMSerializer_1_7 serializer = new nsIDOMSerializer_1_7(result[0]);
            result[0] = 0;
            int string = XPCOM.nsEmbedString_new();
            rc = serializer.SerializeToString(document, string);
            serializer.Release();
            int length = XPCOM.nsEmbedString_Length(string);
            int buffer = XPCOM.nsEmbedString_get(string);
            chars = new char[length];
            XPCOM.memmove(chars, buffer, length * 2);
            XPCOM.nsEmbedString_delete(string);
        } else {
            rc = componentManager.CreateInstanceByContractID(contractID, 0, nsIDOMSerializer.NS_IDOMSERIALIZER_IID, result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMSerializer serializer = new nsIDOMSerializer(result[0]);
            result[0] = 0;
            rc = serializer.SerializeToString(document, result);
            serializer.Release();
            int length = XPCOM.strlen_PRUnichar(result[0]);
            chars = new char[length];
            XPCOM.memmove(chars, result[0], length * 2);
        }
        componentManager.Release();
        new nsISupports(document).Release();
        return new String(chars);
    }

    public String getUrl() {
        int[] aCurrentURI;
        nsIWebNavigation webNavigation;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (webNavigation = new nsIWebNavigation(result[0])).GetCurrentURI(aCurrentURI = new int[1])) != 0) {
            Mozilla.error(rc);
        }
        webNavigation.Release();
        byte[] dest = null;
        if (aCurrentURI[0] != 0) {
            nsIURI uri = new nsIURI(aCurrentURI[0]);
            int aSpec = XPCOM.nsEmbedCString_new();
            rc = uri.GetSpec(aSpec);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            int length = XPCOM.nsEmbedCString_Length(aSpec);
            int buffer = XPCOM.nsEmbedCString_get(aSpec);
            dest = new byte[length];
            XPCOM.memmove(dest, buffer, length);
            XPCOM.nsEmbedCString_delete(aSpec);
            uri.Release();
        }
        if (dest == null) {
            return "";
        }
        String location = new String(dest);
        if (location.equals(URI_FROMMEMORY)) {
            location = ABOUT_BLANK;
        }
        return location;
    }

    public Object getWebBrowser() {
        if ((this.browser.getStyle() & 0x8000) == 0) {
            return null;
        }
        if (this.webBrowserObject != null) {
            return this.webBrowserObject;
        }
        try {
            Class<?> clazz = Class.forName("org.mozilla.xpcom.Mozilla");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object mozilla = method.invoke(null, new Object[0]);
            Class[] classArray = new Class[2];
            classArray[0] = Long.TYPE;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            method = clazz.getMethod("wrapXPCOMObject", classArray);
            this.webBrowserObject = method.invoke(mozilla, new Long(this.webBrowser.getAddress()), "69e5df00-7b8b-11d3-af61-00a024ffc08c");
            return this.webBrowserObject;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public boolean isBackEnabled() {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        boolean[] aCanGoBack = new boolean[1];
        rc = webNavigation.GetCanGoBack(aCanGoBack);
        webNavigation.Release();
        return aCanGoBack[0];
    }

    public boolean isForwardEnabled() {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        boolean[] aCanGoForward = new boolean[1];
        rc = webNavigation.GetCanGoForward(aCanGoForward);
        webNavigation.Release();
        return aCanGoForward[0];
    }

    static String error(int code) {
        throw new SWTError("XPCOM error " + code);
    }

    void onDispose(Display display) {
        nsIBaseWindow baseWindow;
        int[] result;
        int rc = this.webBrowser.RemoveWebBrowserListener(this.weakReference.getAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if ((rc = this.webBrowser.SetParentURIContentListener(0)) != 0) {
            Mozilla.error(rc);
        }
        this.unhookDOMListeners();
        if (this.listener != null) {
            int[] folderEvents = new int[]{12, 11, 15, 26, 27, 22, 1};
            int i = 0;
            while (i < folderEvents.length) {
                this.browser.removeListener(folderEvents[i], this.listener);
                ++i;
            }
            this.listener = null;
        }
        if ((rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result = new int[1])) != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (baseWindow = new nsIBaseWindow(result[0])).Destroy()) != 0) {
            Mozilla.error(rc);
        }
        baseWindow.Release();
        this.Release();
        this.webBrowser.Release();
        this.webBrowser = null;
        this.webBrowserObject = null;
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
        this.size = null;
        this.location = null;
        Enumeration elements = this.unhookedDOMWindows.elements();
        while (elements.hasMoreElements()) {
            LONG ptrObject = (LONG)elements.nextElement();
            new nsISupports(ptrObject.value).Release();
        }
        this.unhookedDOMWindows = null;
        this.delegate.onDispose(this.embedHandle);
        this.delegate = null;
        this.embedHandle = 0;
        --BrowserCount;
    }

    void Activate() {
        nsIWebBrowserFocus webBrowserFocus;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).Activate()) != 0) {
            Mozilla.error(rc);
        }
        webBrowserFocus.Release();
    }

    void Deactivate() {
        nsIWebBrowserFocus webBrowserFocus;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).Deactivate()) != 0) {
            Mozilla.error(rc);
        }
        webBrowserFocus.Release();
    }

    void onResize() {
        Rectangle rect = this.browser.getClientArea();
        int width = Math.max(1, rect.width);
        int height = Math.max(1, rect.height);
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        this.delegate.setSize(this.embedHandle, width, height);
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        rc = baseWindow.SetPositionAndSize(0, 0, width, height, true);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        baseWindow.Release();
    }

    public void refresh() {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.Reload(0);
        webNavigation.Release();
        if (rc == 0) {
            return;
        }
        if (rc != -2147467261 && rc != -2142109678) {
            Mozilla.error(rc);
        }
    }

    public boolean setText(String html) {
        if (this.browser != this.browser.getDisplay().getFocusControl()) {
            this.Deactivate();
        }
        byte[] data = null;
        try {
            data = html.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        byte[] contentTypeBuffer = MozillaDelegate.wcsToMbcs(null, "text/html", true);
        int aContentType = XPCOM.nsEmbedCString_new(contentTypeBuffer, contentTypeBuffer.length);
        byte[] contentCharsetBuffer = MozillaDelegate.wcsToMbcs(null, "UTF-8", true);
        int aContentCharset = XPCOM.nsEmbedCString_new(contentCharsetBuffer, contentCharsetBuffer.length);
        int[] result = new int[1];
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0;
        rc = serviceManager.GetService(XPCOM.NS_IOSERVICE_CID, nsIIOService.NS_IIOSERVICE_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        serviceManager.Release();
        nsIIOService ioService = new nsIIOService(result[0]);
        result[0] = 0;
        byte[] aString = MozillaDelegate.wcsToMbcs(null, URI_FROMMEMORY, false);
        int aSpec = XPCOM.nsEmbedCString_new(aString, aString.length);
        rc = ioService.NewURI(aSpec, null, 0, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        XPCOM.nsEmbedCString_delete(aSpec);
        ioService.Release();
        nsIURI uri = new nsIURI(result[0]);
        result[0] = 0;
        rc = this.webBrowser.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIInterfaceRequestor interfaceRequestor = new nsIInterfaceRequestor(result[0]);
        result[0] = 0;
        InputStream inputStream = new InputStream(data);
        inputStream.AddRef();
        rc = interfaceRequestor.GetInterface(nsIDocShell_1_9.NS_IDOCSHELL_IID, result);
        if (rc == 0) {
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDocShell_1_9 docShell = new nsIDocShell_1_9(result[0]);
            rc = docShell.LoadStream(inputStream.getAddress(), uri.getAddress(), aContentType, aContentCharset, 0);
            docShell.Release();
        } else {
            result[0] = 0;
            rc = interfaceRequestor.GetInterface(nsIDocShell_1_8.NS_IDOCSHELL_IID, result);
            if (rc == 0) {
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIDocShell_1_8 docShell = new nsIDocShell_1_8(result[0]);
                rc = docShell.LoadStream(inputStream.getAddress(), uri.getAddress(), aContentType, aContentCharset, 0);
                docShell.Release();
            } else {
                result[0] = 0;
                rc = interfaceRequestor.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIDocShell docShell = new nsIDocShell(result[0]);
                rc = docShell.LoadStream(inputStream.getAddress(), uri.getAddress(), aContentType, aContentCharset, 0);
                docShell.Release();
            }
        }
        if (rc != 0) {
            Mozilla.error(rc);
        }
        result[0] = 0;
        inputStream.Release();
        interfaceRequestor.Release();
        uri.Release();
        XPCOM.nsEmbedCString_delete(aContentCharset);
        XPCOM.nsEmbedCString_delete(aContentType);
        return true;
    }

    public boolean setUrl(String url) {
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        char[] uri = new char[url.length() + 1];
        url.getChars(0, url.length(), uri, 0);
        rc = webNavigation.LoadURI(uri, 0, 0, 0, 0);
        webNavigation.Release();
        return rc == 0;
    }

    public void stop() {
        nsIWebNavigation webNavigation;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (webNavigation = new nsIWebNavigation(result[0])).Stop(3)) != 0) {
            Mozilla.error(rc);
        }
        webNavigation.Release();
    }

    void hookDOMListeners() {
        int count;
        int[] result = new int[1];
        int rc = this.webBrowser.GetContentDOMWindow(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMWindow window = new nsIDOMWindow(result[0]);
        result[0] = 0;
        rc = window.QueryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMEventTarget target = new nsIDOMEventTarget(result[0]);
        result[0] = 0;
        this.hookDOMListeners(target, true);
        target.Release();
        rc = window.GetFrames(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMWindowCollection frames = new nsIDOMWindowCollection(result[0]);
        result[0] = 0;
        int[] frameCount = new int[1];
        rc = frames.GetLength(frameCount);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if ((count = frameCount[0]) > 0) {
            int i = 0;
            while (i < count) {
                rc = frames.Item(i, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIDOMWindow frame = new nsIDOMWindow(result[0]);
                result[0] = 0;
                rc = frame.QueryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                target = new nsIDOMEventTarget(result[0]);
                result[0] = 0;
                this.hookDOMListeners(target, false);
                target.Release();
                frame.Release();
                ++i;
            }
        }
        frames.Release();
        window.Release();
    }

    void hookDOMListeners(nsIDOMEventTarget target, boolean isTop) {
        nsEmbedString string = new nsEmbedString("focus");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("unload");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mousedown");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mouseup");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mousemove");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("DOMMouseScroll");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("draggesture");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        if (isTop && this.delegate.hookEnterExit()) {
            string = new nsEmbedString("mouseover");
            target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
            string.dispose();
            string = new nsEmbedString("mouseout");
            target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
            string.dispose();
        }
        string = new nsEmbedString("keydown");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("keypress");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("keyup");
        target.AddEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
    }

    void unhookDOMListeners() {
        int count;
        int[] result = new int[1];
        int rc = this.webBrowser.GetContentDOMWindow(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMWindow window = new nsIDOMWindow(result[0]);
        result[0] = 0;
        rc = window.QueryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMEventTarget target = new nsIDOMEventTarget(result[0]);
        result[0] = 0;
        this.unhookDOMListeners(target);
        target.Release();
        rc = window.GetFrames(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMWindowCollection frames = new nsIDOMWindowCollection(result[0]);
        result[0] = 0;
        int[] frameCount = new int[1];
        rc = frames.GetLength(frameCount);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if ((count = frameCount[0]) > 0) {
            int i = 0;
            while (i < count) {
                rc = frames.Item(i, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIDOMWindow frame = new nsIDOMWindow(result[0]);
                result[0] = 0;
                rc = frame.QueryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                target = new nsIDOMEventTarget(result[0]);
                result[0] = 0;
                this.unhookDOMListeners(target);
                target.Release();
                frame.Release();
                ++i;
            }
        }
        frames.Release();
        window.Release();
    }

    void unhookDOMListeners(nsIDOMEventTarget target) {
        nsEmbedString string = new nsEmbedString("focus");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("unload");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mousedown");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mouseup");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mousemove");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("DOMMouseScroll");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("draggesture");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mouseover");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("mouseout");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("keydown");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("keypress");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
        string = new nsEmbedString("keyup");
        target.RemoveEventListener(string.getAddress(), this.domEventListener.getAddress(), false);
        string.dispose();
    }

    int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.weakReference.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.webProgressListener.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebBrowserChrome.NS_IWEBBROWSERCHROME_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.webBrowserChrome.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebBrowserChromeFocus.NS_IWEBBROWSERCHROMEFOCUS_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.webBrowserChromeFocus.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.embeddingSiteWindow.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.interfaceRequestor.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.supportsWeakReference.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIContextMenuListener.NS_ICONTEXTMENULISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.contextMenuListener.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIURIContentListener.NS_IURICONTENTLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.uriContentListener.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsITooltipListener.NS_ITOOLTIPLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.tooltipListener.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new int[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int QueryReferent(int riid, int ppvObject) {
        return this.QueryInterface(riid, ppvObject);
    }

    int GetInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsIDOMWindow.NS_IDOMWINDOW_IID)) {
            int[] aContentDOMWindow = new int[1];
            int rc = this.webBrowser.GetContentDOMWindow(aContentDOMWindow);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (aContentDOMWindow[0] == 0) {
                Mozilla.error(-2147467262);
            }
            XPCOM.memmove(ppvObject, aContentDOMWindow, C.PTR_SIZEOF);
            return rc;
        }
        return this.QueryInterface(riid, ppvObject);
    }

    int GetWeakReference(int ppvObject) {
        XPCOM.memmove(ppvObject, new int[]{this.weakReference.getAddress()}, C.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int OnStateChange(int aWebProgress, int aRequest, int aStateFlags, int aStatus) {
        if ((aStateFlags & 0x20000) == 0) {
            return 0;
        }
        if ((aStateFlags & 1) != 0) {
            int[] result;
            nsIWebProgress progress;
            int rc;
            if (this.request == 0) {
                this.request = aRequest;
            }
            if ((rc = (progress = new nsIWebProgress(aWebProgress)).GetDOMWindow(result = new int[1])) != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            this.unhookedDOMWindows.addElement(new LONG(result[0]));
        } else if ((aStateFlags & 2) != 0) {
            if (this.request == aRequest) {
                this.request = 0;
            }
        } else if ((aStateFlags & 0x10) != 0) {
            nsIWebProgress progress = new nsIWebProgress(aWebProgress);
            int[] result = new int[1];
            int rc = progress.GetDOMWindow(result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMWindow domWindow = new nsIDOMWindow(result[0]);
            LONG ptrObject = new LONG(result[0]);
            result[0] = 0;
            int index = this.unhookedDOMWindows.indexOf(ptrObject);
            if (index != -1) {
                rc = this.webBrowser.GetContentDOMWindow(result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                boolean isTop = result[0] == domWindow.getAddress();
                new nsISupports(result[0]).Release();
                result[0] = 0;
                rc = domWindow.QueryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIDOMEventTarget target = new nsIDOMEventTarget(result[0]);
                result[0] = 0;
                this.hookDOMListeners(target, isTop);
                target.Release();
                this.unhookedDOMWindows.remove(ptrObject);
                new nsISupports(ptrObject.value).Release();
            }
            domWindow.Release();
            if (this.request == aRequest || this.request == 0) {
                this.request = 0;
                StatusTextEvent event = new StatusTextEvent(this.browser);
                event.display = this.browser.getDisplay();
                event.widget = this.browser;
                event.text = "";
                int i = 0;
                while (i < this.statusTextListeners.length) {
                    this.statusTextListeners[i].changed(event);
                    ++i;
                }
                ProgressEvent event2 = new ProgressEvent(this.browser);
                event2.display = this.browser.getDisplay();
                event2.widget = this.browser;
                int i2 = 0;
                while (i2 < this.progressListeners.length) {
                    this.progressListeners[i2].completed(event2);
                    ++i2;
                }
            }
        } else if ((aStateFlags & 4) != 0) {
            nsIWebProgress progress = new nsIWebProgress(aWebProgress);
            int[] result = new int[1];
            int rc = progress.GetDOMWindow(result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMWindow domWindow = new nsIDOMWindow(result[0]);
            LONG ptrObject = new LONG(result[0]);
            result[0] = 0;
            int index = this.unhookedDOMWindows.indexOf(ptrObject);
            if (index != -1) {
                rc = this.webBrowser.GetContentDOMWindow(result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                boolean isTop = result[0] == domWindow.getAddress();
                new nsISupports(result[0]).Release();
                result[0] = 0;
                rc = domWindow.QueryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID, result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIDOMEventTarget target = new nsIDOMEventTarget(result[0]);
                result[0] = 0;
                this.hookDOMListeners(target, isTop);
                target.Release();
                this.unhookedDOMWindows.remove(ptrObject);
                new nsISupports(ptrObject.value).Release();
            }
            domWindow.Release();
        }
        return 0;
    }

    int OnProgressChange(int aWebProgress, int aRequest, int aCurSelfProgress, int aMaxSelfProgress, int aCurTotalProgress, int aMaxTotalProgress) {
        if (this.progressListeners.length == 0) {
            return 0;
        }
        ProgressEvent event = new ProgressEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.current = aCurTotalProgress;
        event.total = aMaxTotalProgress;
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnLocationChange(int aWebProgress, int aRequest, int aLocation) {
        int[] aTop;
        nsIDOMWindow domWindow;
        if (this.request != 0 && this.request != aRequest) {
            this.request = aRequest;
        }
        if (this.locationListeners.length == 0) {
            return 0;
        }
        nsIWebProgress webProgress = new nsIWebProgress(aWebProgress);
        int[] aDOMWindow = new int[1];
        int rc = webProgress.GetDOMWindow(aDOMWindow);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (aDOMWindow[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (domWindow = new nsIDOMWindow(aDOMWindow[0])).GetTop(aTop = new int[1])) != 0) {
            Mozilla.error(rc);
        }
        if (aTop[0] == 0) {
            Mozilla.error(-2147467262);
        }
        domWindow.Release();
        nsIDOMWindow topWindow = new nsIDOMWindow(aTop[0]);
        topWindow.Release();
        nsIURI location = new nsIURI(aLocation);
        int aSpec = XPCOM.nsEmbedCString_new();
        location.GetSpec(aSpec);
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        int buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        String url = new String(dest);
        if (!IsPre_1_8 && aRequest == 0 && url.startsWith(ABOUT_BLANK)) {
            return 0;
        }
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = url;
        if (event.location.equals(URI_FROMMEMORY)) {
            event.location = ABOUT_BLANK;
        }
        event.top = aTop[0] == aDOMWindow[0];
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnStatusChange(int aWebProgress, int aRequest, int aStatus, int aMessage) {
        if (this.statusTextListeners.length == 0) {
            return 0;
        }
        StatusTextEvent event = new StatusTextEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        int length = XPCOM.strlen_PRUnichar(aMessage);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aMessage, length * 2);
        event.text = new String(dest);
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnSecurityChange(int aWebProgress, int aRequest, int state) {
        return 0;
    }

    int SetStatus(int statusType, int status) {
        String string;
        StatusTextEvent event = new StatusTextEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        int length = XPCOM.strlen_PRUnichar(status);
        char[] dest = new char[length];
        XPCOM.memmove(dest, status, length * 2);
        event.text = string = new String(dest);
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int GetWebBrowser(int aWebBrowser) {
        int[] ret = new int[1];
        if (this.webBrowser != null) {
            this.webBrowser.AddRef();
            ret[0] = this.webBrowser.getAddress();
        }
        XPCOM.memmove(aWebBrowser, ret, C.PTR_SIZEOF);
        return 0;
    }

    int SetWebBrowser(int aWebBrowser) {
        if (this.webBrowser != null) {
            this.webBrowser.Release();
        }
        this.webBrowser = aWebBrowser != 0 ? new nsIWebBrowser(aWebBrowser) : null;
        return 0;
    }

    int GetChromeFlags(int aChromeFlags) {
        int[] ret = new int[]{this.chromeFlags};
        XPCOM.memmove(aChromeFlags, ret, 4);
        return 0;
    }

    int SetChromeFlags(int aChromeFlags) {
        this.chromeFlags = aChromeFlags;
        return 0;
    }

    int DestroyBrowserWindow() {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.browser.dispose();
        return 0;
    }

    int SizeBrowserTo(int aCX, int aCY) {
        boolean isChrome;
        this.size = new Point(aCX, aCY);
        boolean bl = isChrome = (this.chromeFlags & Integer.MIN_VALUE) != 0;
        if (isChrome) {
            Shell shell = this.browser.getShell();
            shell.setSize(shell.computeSize(this.size.x, this.size.y));
        }
        return 0;
    }

    int ShowAsModal() {
        int[] result = new int[1];
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0;
        byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/js/xpc/ContextStack;1", true);
        rc = serviceManager.GetServiceByContractID(aContractID, nsIJSContextStack.NS_IJSCONTEXTSTACK_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        serviceManager.Release();
        nsIJSContextStack stack = new nsIJSContextStack(result[0]);
        result[0] = 0;
        rc = stack.Push(0);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        Shell shell = this.browser.getShell();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        rc = stack.Pop(result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        stack.Release();
        return 0;
    }

    int IsWindowModal(int retval) {
        int result = (this.chromeFlags & 0x20000000) != 0 ? 1 : 0;
        XPCOM.memmove(retval, new int[]{result}, 4);
        return 0;
    }

    int ExitModalEventLoop(int aStatus) {
        return 0;
    }

    int SetDimensions(int flags, int x, int y, int cx, int cy) {
        if ((flags & 1) != 0) {
            this.location = new Point(x, y);
            this.browser.getShell().setLocation(x, y);
        }
        if ((flags & 2) != 0) {
            this.browser.setSize(cx, cy);
        }
        if ((flags & 4) != 0) {
            this.browser.getShell().setSize(cx, cy);
        }
        return 0;
    }

    int GetDimensions(int flags, int x, int y, int cx, int cy) {
        Point size;
        if ((flags & 1) != 0) {
            Point location = this.browser.getShell().getLocation();
            if (x != 0) {
                C.memmove(x, new int[]{location.x}, 4);
            }
            if (y != 0) {
                C.memmove(y, new int[]{location.y}, 4);
            }
        }
        if ((flags & 2) != 0) {
            size = this.browser.getSize();
            if (cx != 0) {
                C.memmove(cx, new int[]{size.x}, 4);
            }
            if (cy != 0) {
                C.memmove(cy, new int[]{size.y}, 4);
            }
        }
        if ((flags & 4) != 0) {
            size = this.browser.getShell().getSize();
            if (cx != 0) {
                C.memmove(cx, new int[]{size.x}, 4);
            }
            if (cy != 0) {
                C.memmove(cy, new int[]{size.y}, 4);
            }
        }
        return 0;
    }

    int SetFocus() {
        nsIBaseWindow baseWindow;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((rc = (baseWindow = new nsIBaseWindow(result[0])).SetFocus()) != 0) {
            Mozilla.error(rc);
        }
        baseWindow.Release();
        return 0;
    }

    int GetVisibility(int aVisibility) {
        XPCOM.memmove(aVisibility, new int[]{this.browser.isVisible() ? 1 : 0}, 4);
        return 0;
    }

    int SetVisibility(int aVisibility) {
        if (this.isChild) {
            WindowEvent event = new WindowEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            if (aVisibility == 1) {
                if (!this.visible) {
                    this.visible = true;
                    event.location = this.location;
                    event.size = this.size;
                    event.addressBar = (this.chromeFlags & 0x40) != 0;
                    event.menuBar = (this.chromeFlags & 0x10) != 0;
                    event.statusBar = (this.chromeFlags & 0x80) != 0;
                    event.toolBar = (this.chromeFlags & 0x20) != 0;
                    int i = 0;
                    while (i < this.visibilityWindowListeners.length) {
                        this.visibilityWindowListeners[i].show(event);
                        ++i;
                    }
                    this.location = null;
                    this.size = null;
                }
            } else {
                this.visible = false;
                int i = 0;
                while (i < this.visibilityWindowListeners.length) {
                    this.visibilityWindowListeners[i].hide(event);
                    ++i;
                }
            }
        } else {
            this.visible = aVisibility != 0;
        }
        return 0;
    }

    int GetTitle(int aTitle) {
        return 0;
    }

    int SetTitle(int aTitle) {
        if (this.titleListeners.length == 0) {
            return 0;
        }
        TitleEvent event = new TitleEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        int length = XPCOM.strlen_PRUnichar(aTitle);
        if (length > 0) {
            char[] dest = new char[length];
            XPCOM.memmove(dest, aTitle, length * 2);
            event.title = new String(dest);
        } else {
            event.title = this.getUrl();
        }
        int i = 0;
        while (i < this.titleListeners.length) {
            this.titleListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int GetSiteWindow(int aSiteWindow) {
        XPCOM.memmove(aSiteWindow, new int[]{this.embedHandle}, C.PTR_SIZEOF);
        return 0;
    }

    int FocusNextElement() {
        this.browser.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Mozilla.this.browser.traverse(16);
            }
        });
        return 0;
    }

    int FocusPrevElement() {
        this.browser.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Mozilla.this.browser.traverse(8);
            }
        });
        return 0;
    }

    int OnShowContextMenu(int aContextFlags, int aEvent, int aNode) {
        nsIDOMEvent domEvent = new nsIDOMEvent(aEvent);
        int[] result = new int[1];
        int rc = domEvent.QueryInterface(nsIDOMMouseEvent.NS_IDOMMOUSEEVENT_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMMouseEvent domMouseEvent = new nsIDOMMouseEvent(result[0]);
        int[] aScreenX = new int[1];
        int[] aScreenY = new int[1];
        rc = domMouseEvent.GetScreenX(aScreenX);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if ((rc = domMouseEvent.GetScreenY(aScreenY)) != 0) {
            Mozilla.error(rc);
        }
        domMouseEvent.Release();
        Event event = new Event();
        event.x = aScreenX[0];
        event.y = aScreenY[0];
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (aScreenX[0] != event.x || aScreenY[0] != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
        }
        return 0;
    }

    int OnStartURIOpen(int aURI, int retval) {
        nsIURI location = new nsIURI(aURI);
        int aSpec = XPCOM.nsEmbedCString_new();
        location.GetSpec(aSpec);
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        int buffer = XPCOM.nsEmbedCString_get(aSpec);
        buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        String value = new String(dest);
        if (this.locationListeners.length == 0) {
            XPCOM.memmove(retval, new int[1], 4);
            return 0;
        }
        boolean doit = true;
        if (this.request == 0) {
            LocationEvent event = new LocationEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            event.location = value;
            if (event.location.equals(URI_FROMMEMORY)) {
                event.location = ABOUT_BLANK;
            }
            event.doit = doit;
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(event);
                ++i;
            }
            doit = event.doit;
        }
        XPCOM.memmove(retval, new int[]{doit ? 0 : 1}, 4);
        return 0;
    }

    int DoContent(int aContentType, int aIsContentPreferred, int aRequest, int aContentHandler, int retval) {
        return -2147467263;
    }

    int IsPreferred(int aContentType, int aDesiredContentType, int retval) {
        boolean preferred = false;
        int size = XPCOM.strlen(aContentType);
        if (size > 0) {
            byte[] typeBytes = new byte[size + 1];
            XPCOM.memmove(typeBytes, aContentType, size);
            String contentType = new String(typeBytes, 0, size);
            if (!contentType.equals("application/x-vnd.mozilla.maybe-text") && !contentType.equals("multipart/x-mixed-replace")) {
                int[] result = new int[1];
                int rc = XPCOM.NS_GetServiceManager(result);
                if (rc != 0) {
                    Mozilla.error(rc);
                }
                if (result[0] == 0) {
                    Mozilla.error(-2147467262);
                }
                nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
                result[0] = 0;
                byte[] aContractID = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/webnavigation-info;1", true);
                rc = serviceManager.GetServiceByContractID(aContractID, nsIWebNavigationInfo.NS_IWEBNAVIGATIONINFO_IID, result);
                if (rc == 0) {
                    byte[] bytes = MozillaDelegate.wcsToMbcs(null, contentType, true);
                    int typePtr = XPCOM.nsEmbedCString_new(bytes, bytes.length);
                    nsIWebNavigationInfo info = new nsIWebNavigationInfo(result[0]);
                    result[0] = 0;
                    int[] isSupportedResult = new int[1];
                    rc = info.IsTypeSupported(typePtr, 0, isSupportedResult);
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    info.Release();
                    XPCOM.nsEmbedCString_delete(typePtr);
                    preferred = isSupportedResult[0] != 0;
                } else {
                    result[0] = 0;
                    rc = serviceManager.GetService(XPCOM.NS_CATEGORYMANAGER_CID, nsICategoryManager.NS_ICATEGORYMANAGER_IID, result);
                    if (rc != 0) {
                        Mozilla.error(rc);
                    }
                    if (result[0] == 0) {
                        Mozilla.error(-2147467262);
                    }
                    nsICategoryManager categoryManager = new nsICategoryManager(result[0]);
                    result[0] = 0;
                    byte[] categoryBytes = MozillaDelegate.wcsToMbcs(null, "Gecko-Content-Viewers", true);
                    rc = categoryManager.GetCategoryEntry(categoryBytes, typeBytes, result);
                    categoryManager.Release();
                    preferred = rc == 0;
                }
                serviceManager.Release();
            }
        }
        XPCOM.memmove(retval, new int[]{preferred ? 1 : 0}, 4);
        if (preferred) {
            XPCOM.memmove(aDesiredContentType, new int[1], C.PTR_SIZEOF);
        }
        return 0;
    }

    int CanHandleContent(int aContentType, int aIsContentPreferred, int aDesiredContentType, int retval) {
        return -2147467263;
    }

    int GetLoadCookie(int aLoadCookie) {
        return -2147467263;
    }

    int SetLoadCookie(int aLoadCookie) {
        return -2147467263;
    }

    int GetParentContentListener(int aParentContentListener) {
        return -2147467263;
    }

    int SetParentContentListener(int aParentContentListener) {
        return -2147467263;
    }

    int OnShowTooltip(int aXCoords, int aYCoords, int aTipText) {
        int length = XPCOM.strlen_PRUnichar(aTipText);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aTipText, length * 2);
        String text = new String(dest);
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        Display display = this.browser.getDisplay();
        Shell parent = this.browser.getShell();
        this.tip = new Shell(parent, 16384);
        this.tip.setLayout(new FillLayout());
        Label label = new Label(this.tip, 0x1000000);
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setText(text);
        Point point = display.getCursorLocation();
        point.y += 21;
        this.tip.setLocation(point);
        this.tip.pack();
        this.tip.setVisible(true);
        return 0;
    }

    int OnHideTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
        return 0;
    }

    int HandleEvent(int event) {
        short[] aButton;
        nsIDOMEvent domEvent = new nsIDOMEvent(event);
        int type = XPCOM.nsEmbedString_new();
        int rc = domEvent.GetType(type);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        int length = XPCOM.nsEmbedString_Length(type);
        int buffer = XPCOM.nsEmbedString_get(type);
        char[] chars = new char[length];
        XPCOM.memmove(chars, buffer, length * 2);
        String typeString = new String(chars);
        XPCOM.nsEmbedString_delete(type);
        if ("unload".equals(typeString)) {
            int[] result = new int[1];
            rc = domEvent.GetCurrentTarget(result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMEventTarget target = new nsIDOMEventTarget(result[0]);
            this.unhookDOMListeners(target);
            target.Release();
            return 0;
        }
        if ("focus".equals(typeString)) {
            this.delegate.handleFocus();
            return 0;
        }
        if ("keydown".equals(typeString)) {
            int keyCode;
            int[] result = new int[1];
            rc = domEvent.QueryInterface(nsIDOMKeyEvent.NS_IDOMKEYEVENT_IID, result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMKeyEvent domKeyEvent = new nsIDOMKeyEvent(result[0]);
            result[0] = 0;
            int[] aKeyCode = new int[1];
            rc = domKeyEvent.GetKeyCode(aKeyCode);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if ((keyCode = this.translateKey(aKeyCode[0])) != this.lastKeyCode) {
                this.lastKeyCode = keyCode;
                switch (keyCode) {
                    case 65536: 
                    case 131072: 
                    case 262144: 
                    case 0x400000: 
                    case 16777298: 
                    case 16777299: 
                    case 16777300: {
                        boolean[] aAltKey = new boolean[1];
                        boolean[] aCtrlKey = new boolean[1];
                        boolean[] aShiftKey = new boolean[1];
                        boolean[] aMetaKey = new boolean[1];
                        rc = domKeyEvent.GetAltKey(aAltKey);
                        if (rc != 0) {
                            Mozilla.error(rc);
                        }
                        if ((rc = domKeyEvent.GetCtrlKey(aCtrlKey)) != 0) {
                            Mozilla.error(rc);
                        }
                        if ((rc = domKeyEvent.GetShiftKey(aShiftKey)) != 0) {
                            Mozilla.error(rc);
                        }
                        if ((rc = domKeyEvent.GetMetaKey(aMetaKey)) != 0) {
                            Mozilla.error(rc);
                        }
                        Event keyEvent = new Event();
                        keyEvent.widget = this.browser;
                        keyEvent.type = 1;
                        keyEvent.keyCode = keyCode;
                        keyEvent.stateMask = (aAltKey[0] ? 65536 : 0) | (aCtrlKey[0] ? 262144 : 0) | (aShiftKey[0] ? 131072 : 0) | (aMetaKey[0] ? 0x400000 : 0);
                        keyEvent.stateMask &= ~keyCode;
                        this.browser.notifyListeners(keyEvent.type, keyEvent);
                        if (keyEvent.doit) break;
                        domEvent.PreventDefault();
                        break;
                    }
                    default: {
                        boolean[] aMetaKey = new boolean[1];
                        rc = domKeyEvent.GetMetaKey(aMetaKey);
                        if (rc != 0) {
                            Mozilla.error(rc);
                        }
                        if (!aMetaKey[0]) break;
                        boolean[] aCtrlKey = new boolean[1];
                        rc = domKeyEvent.GetCtrlKey(aCtrlKey);
                        if (rc != 0) {
                            Mozilla.error(rc);
                        }
                        if (aCtrlKey[0]) break;
                        boolean[] aAltKey = new boolean[1];
                        boolean[] aShiftKey = new boolean[1];
                        rc = domKeyEvent.GetAltKey(aAltKey);
                        if (rc != 0) {
                            Mozilla.error(rc);
                        }
                        if ((rc = domKeyEvent.GetShiftKey(aShiftKey)) != 0) {
                            Mozilla.error(rc);
                        }
                        Event keyEvent = new Event();
                        keyEvent.widget = this.browser;
                        keyEvent.type = 1;
                        keyEvent.keyCode = this.lastKeyCode;
                        keyEvent.stateMask = (aAltKey[0] ? 65536 : 0) | (aCtrlKey[0] ? 262144 : 0) | (aShiftKey[0] ? 131072 : 0) | (aMetaKey[0] ? 0x400000 : 0);
                        this.browser.notifyListeners(keyEvent.type, keyEvent);
                        if (keyEvent.doit) break;
                        domEvent.PreventDefault();
                    }
                }
            }
            domKeyEvent.Release();
            return 0;
        }
        if ("keypress".equals(typeString)) {
            if (this.lastKeyCode == 0) {
                return 0;
            }
            switch (this.lastKeyCode) {
                case 16777298: 
                case 16777299: 
                case 16777300: {
                    return 0;
                }
            }
            int[] result = new int[1];
            rc = domEvent.QueryInterface(nsIDOMKeyEvent.NS_IDOMKEYEVENT_IID, result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMKeyEvent domKeyEvent = new nsIDOMKeyEvent(result[0]);
            result[0] = 0;
            boolean[] aAltKey = new boolean[1];
            boolean[] aCtrlKey = new boolean[1];
            boolean[] aShiftKey = new boolean[1];
            boolean[] aMetaKey = new boolean[1];
            rc = domKeyEvent.GetAltKey(aAltKey);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if ((rc = domKeyEvent.GetCtrlKey(aCtrlKey)) != 0) {
                Mozilla.error(rc);
            }
            if ((rc = domKeyEvent.GetShiftKey(aShiftKey)) != 0) {
                Mozilla.error(rc);
            }
            if ((rc = domKeyEvent.GetMetaKey(aMetaKey)) != 0) {
                Mozilla.error(rc);
            }
            domKeyEvent.Release();
            int[] aCharCode = new int[1];
            rc = domKeyEvent.GetCharCode(aCharCode);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            this.lastCharCode = aCharCode[0];
            if (this.lastCharCode == 0) {
                switch (this.lastKeyCode) {
                    case 9: {
                        this.lastCharCode = 9;
                        break;
                    }
                    case 13: {
                        this.lastCharCode = 13;
                        break;
                    }
                    case 8: {
                        this.lastCharCode = 8;
                        break;
                    }
                    case 27: {
                        this.lastCharCode = 27;
                        break;
                    }
                    case 127: {
                        this.lastCharCode = 127;
                    }
                }
            }
            if (aCtrlKey[0] && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 1;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = (aAltKey[0] ? 65536 : 0) | (aCtrlKey[0] ? 262144 : 0) | (aShiftKey[0] ? 131072 : 0) | (aMetaKey[0] ? 0x400000 : 0);
            this.browser.notifyListeners(keyEvent.type, keyEvent);
            if (!keyEvent.doit) {
                domEvent.PreventDefault();
            }
            return 0;
        }
        if ("keyup".equals(typeString)) {
            int keyCode;
            int[] result = new int[1];
            rc = domEvent.QueryInterface(nsIDOMKeyEvent.NS_IDOMKEYEVENT_IID, result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0) {
                Mozilla.error(-2147467262);
            }
            nsIDOMKeyEvent domKeyEvent = new nsIDOMKeyEvent(result[0]);
            result[0] = 0;
            int[] aKeyCode = new int[1];
            rc = domKeyEvent.GetKeyCode(aKeyCode);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if ((keyCode = this.translateKey(aKeyCode[0])) == 0) {
                domKeyEvent.Release();
                return 0;
            }
            if (keyCode != this.lastKeyCode) {
                this.lastKeyCode = keyCode;
                this.lastCharCode = 0;
            }
            boolean[] aAltKey = new boolean[1];
            boolean[] aCtrlKey = new boolean[1];
            boolean[] aShiftKey = new boolean[1];
            boolean[] aMetaKey = new boolean[1];
            rc = domKeyEvent.GetAltKey(aAltKey);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if ((rc = domKeyEvent.GetCtrlKey(aCtrlKey)) != 0) {
                Mozilla.error(rc);
            }
            if ((rc = domKeyEvent.GetShiftKey(aShiftKey)) != 0) {
                Mozilla.error(rc);
            }
            if ((rc = domKeyEvent.GetMetaKey(aMetaKey)) != 0) {
                Mozilla.error(rc);
            }
            domKeyEvent.Release();
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 2;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = (aAltKey[0] ? 65536 : 0) | (aCtrlKey[0] ? 262144 : 0) | (aShiftKey[0] ? 131072 : 0) | (aMetaKey[0] ? 0x400000 : 0);
            switch (this.lastKeyCode) {
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: {
                    keyEvent.stateMask |= this.lastKeyCode;
                }
            }
            this.browser.notifyListeners(keyEvent.type, keyEvent);
            if (!keyEvent.doit) {
                domEvent.PreventDefault();
            }
            this.lastCharCode = 0;
            this.lastKeyCode = 0;
            return 0;
        }
        int[] result = new int[1];
        rc = domEvent.QueryInterface(nsIDOMMouseEvent.NS_IDOMMOUSEEVENT_IID, result);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if (result[0] == 0) {
            Mozilla.error(-2147467262);
        }
        nsIDOMMouseEvent domMouseEvent = new nsIDOMMouseEvent(result[0]);
        result[0] = 0;
        if ("mouseover".equals(typeString) || "mouseout".equals(typeString)) {
            rc = domMouseEvent.GetRelatedTarget(result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] != 0) {
                domMouseEvent.Release();
                return 0;
            }
        }
        int[] aClientX = new int[1];
        int[] aClientY = new int[1];
        int[] aDetail = new int[1];
        rc = domMouseEvent.GetClientX(aClientX);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if ((rc = domMouseEvent.GetClientY(aClientY)) != 0) {
            Mozilla.error(rc);
        }
        if ((rc = domMouseEvent.GetDetail(aDetail)) != 0) {
            Mozilla.error(rc);
        }
        if ((rc = domMouseEvent.GetButton(aButton = new short[1])) != 0) {
            Mozilla.error(rc);
        }
        boolean[] aAltKey = new boolean[1];
        boolean[] aCtrlKey = new boolean[1];
        boolean[] aShiftKey = new boolean[1];
        boolean[] aMetaKey = new boolean[1];
        rc = domMouseEvent.GetAltKey(aAltKey);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        if ((rc = domMouseEvent.GetCtrlKey(aCtrlKey)) != 0) {
            Mozilla.error(rc);
        }
        if ((rc = domMouseEvent.GetShiftKey(aShiftKey)) != 0) {
            Mozilla.error(rc);
        }
        if ((rc = domMouseEvent.GetMetaKey(aMetaKey)) != 0) {
            Mozilla.error(rc);
        }
        domMouseEvent.Release();
        Event mouseEvent = new Event();
        mouseEvent.widget = this.browser;
        mouseEvent.x = aClientX[0];
        mouseEvent.y = aClientY[0];
        mouseEvent.stateMask = (aAltKey[0] ? 65536 : 0) | (aCtrlKey[0] ? 262144 : 0) | (aShiftKey[0] ? 131072 : 0) | (aMetaKey[0] ? 0x400000 : 0);
        if ("mousedown".equals(typeString)) {
            this.delegate.handleMouseDown();
            mouseEvent.type = 3;
            mouseEvent.button = aButton[0] + 1;
            mouseEvent.count = aDetail[0];
        } else if ("mouseup".equals(typeString)) {
            int button = aButton[0] + 1;
            int count = aDetail[0];
            if (count == 0 && button == 3) {
                return 0;
            }
            mouseEvent.type = 4;
            mouseEvent.button = button;
            mouseEvent.count = count;
        } else if ("mousemove".equals(typeString)) {
            mouseEvent.type = 5;
        } else if ("DOMMouseScroll".equals(typeString)) {
            mouseEvent.type = 37;
            mouseEvent.count = -aDetail[0];
        } else if ("mouseover".equals(typeString)) {
            mouseEvent.type = 6;
        } else if ("mouseout".equals(typeString)) {
            mouseEvent.type = 7;
        } else if ("draggesture".equals(typeString)) {
            mouseEvent.type = 29;
            mouseEvent.button = aButton[0] + 1;
            switch (mouseEvent.button) {
                case 1: {
                    mouseEvent.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    mouseEvent.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    mouseEvent.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    mouseEvent.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    mouseEvent.stateMask |= 0x2000000;
                }
            }
        }
        this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        if (aDetail[0] == 2 && "mousedown".equals(typeString)) {
            mouseEvent = new Event();
            mouseEvent.widget = this.browser;
            mouseEvent.x = aClientX[0];
            mouseEvent.y = aClientY[0];
            mouseEvent.stateMask = (aAltKey[0] ? 65536 : 0) | (aCtrlKey[0] ? 262144 : 0) | (aShiftKey[0] ? 131072 : 0) | (aMetaKey[0] ? 0x400000 : 0);
            mouseEvent.type = 8;
            mouseEvent.button = aButton[0] + 1;
            mouseEvent.count = aDetail[0];
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        }
        return 0;
    }
}

