#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/clamd.conf.new
config etc/freshclam.conf.new

touch var/log/clamd.log
touch var/log/freshclam.log

chroot . <<EOR 2>/dev/null
/usr/sbin/groupadd clamav 2> /dev/null
/usr/sbin/useradd -c "Clamav antivirusr" -g clamav -s "/bin/false" clamav 2> /dev/null

chown clamav usr/sbin/clamav-milter
chmod 4700 usr/sbin/clamav-milter
chown -R clamav:clamav var/run/clamav
chmod 771 var/run/clamav
chown clamav:clamav var/log/{clamd.log,freshclam.log}
chmod 660 var/log/{clamd.log,freshclam.log}
chown -R clamav:clamav usr/share/clamav
chmod -R 770 usr/share/clamav
( cd usr/lib ; rm -rf libclamav.so )
( cd usr/lib ; ln -sf libclamav.so.5.0.4 libclamav.so )
( cd usr/lib ; rm -rf libclamunrar.so )
( cd usr/lib ; ln -sf libclamunrar.so.5.0.4 libclamunrar.so )
( cd usr/lib ; rm -rf libclamunrar_iface.so )
( cd usr/lib ; ln -sf libclamunrar_iface.so.5.0.4 libclamunrar_iface.so )
( cd usr/lib ; rm -rf libclamav.so.5 )
( cd usr/lib ; ln -sf libclamav.so.5.0.4 libclamav.so.5 )
( cd usr/lib ; rm -rf libclamunrar_iface.so.5 )
( cd usr/lib ; ln -sf libclamunrar_iface.so.5.0.4 libclamunrar_iface.so.5 )
( cd usr/lib ; rm -rf libclamunrar.so.5 )
( cd usr/lib ; ln -sf libclamunrar.so.5.0.4 libclamunrar.so.5 )
