#
# details_tab.py
#
# Copyright (C) 2008 Andrew Resch <andrewresch@gmail.com>
#
# Deluge is free software.
#
# You may redistribute it and/or modify it under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 3 of the License, or (at your option)
# any later version.
#
# deluge is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with deluge.    If not, write to:
# 	The Free Software Foundation, Inc.,
# 	51 Franklin Street, Fifth Floor
# 	Boston, MA    02110-1301, USA.
#


import gtk, gtk.glade

from deluge.ui.client import aclient as client
import deluge.component as component
import deluge.common
from deluge.ui.gtkui.torrentdetails import Tab

from deluge.log import LOG as log

class DetailsTab(Tab):
    def __init__(self):
        Tab.__init__(self)
        # Get the labels we need to update.
        # widgetname, modifier function, status keys
        glade = component.get("MainWindow").main_glade

        self._name = "Details"
        self._child_widget = glade.get_widget("details_tab")
        self._tab_label = glade.get_widget("details_tab_label")

        self.label_widgets = [
            (glade.get_widget("summary_name"), None, ("name",)),
            (glade.get_widget("summary_total_size"), deluge.common.fsize, ("total_size",)),
            (glade.get_widget("summary_num_files"), str, ("num_files",)),
            (glade.get_widget("summary_tracker"), None, ("tracker",)),
            (glade.get_widget("summary_torrent_path"), None, ("save_path",)),
            (glade.get_widget("summary_message"), str, ("message",)),
            (glade.get_widget("summary_hash"), str, ("hash",))
        ]

    def update(self):
        # Get the first selected torrent
        selected = component.get("TorrentView").get_selected_torrents()

        # Only use the first torrent in the list or return if None selected
        if len(selected) != 0:
            selected = selected[0]
        else:
            # No torrent is selected in the torrentview
            self.clear()
            return

        # Get the torrent status
        status_keys = ["name", "total_size", "num_files",
            "tracker", "save_path", "message", "hash"]

        client.get_torrent_status(
            self._on_get_torrent_status, selected, status_keys)

    def _on_get_torrent_status(self, status):
        # Check to see if we got valid data from the core
        if status is None:
            return

        # Update all the label widgets
        for widget in self.label_widgets:
            if widget[1] != None:
                args = []
                try:
                    for key in widget[2]:
                        args.append(status[key])
                except Exception, e:
                    log.debug("Unable to get status value: %s", e)
                    continue

                txt = widget[1](*args)
            else:
                txt = status[widget[2][0]]

            if widget[0].get_text() != txt:
                widget[0].set_text(txt)

    def clear(self):
        for widget in self.label_widgets:
            widget[0].set_text("")

