/*
 * File: about.c
 *
 * Copyright (C) 1999-2007 Jorge Arellano Cid <jcid@dillo.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#include <config.h>

/*
 * HTML text for startup screen
 */
const char *AboutSplash=
"<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>\n"
"<html>\n"
"<head>\n"
"<title>Splash screen for dillo-" VERSION "</title>\n"
"</head>\n"
"<body bgcolor='#778899' text='#000000' link='#000000' vlink='#000000'>\n"
"\n"
"\n"
"<!--   the head of the page   -->\n"
"\n"
"<table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
" <tr><td>\n"
"  <table border='1' cellspacing='1' cellpadding='0'>\n"
"   <tr>\n"
"   <td bgcolor='#000000'>\n"
"    <table width='100%' border='0' bgcolor='#ffffff'>\n"
"    <tr>\n"
"     <td valign='top' align='left'>\n"
"      <h1>&nbsp;Welcome to Dillo " VERSION "&nbsp;</h1>\n"
"    </table>\n"
"  </table>\n"
"</table>\n"
"\n"
"<br>\n"
"\n"
"\n"
"<!-- the main layout table, definition -->\n"
"\n"
"<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n"
"<tr><td valign='top' width='150' align='center'>\n"
"\n"
"\n"
"<!--   The navigation bar   -->\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
" <td>\n"
"  <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"  <tr>\n"
"   <td colspan='1' bgcolor='#CCCCCC'>Dillo\n"
"  <tr>\n"
"   <td bgcolor='#FFFFFF'>\n"
"    <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"    <table border='0' cellspacing='0' cellpadding='2'><tr>\n"
"    <td>\n"
"    <td>\n"
"     <a href='http://www.dillo.org/dillo2-help.html'>\n"
"     Help</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.dillo.org/'>Home</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.dillo.org/funding/objectives.html'>\n"
"     Objectives</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://cvs.auriga.wearlab.de/cgi-bin/cvsweb.cgi/dillo2/ChangeLog?rev=HEAD;cvsroot=dillo'>\n"
"     ChangeLog</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.dillo.org/interview.html'>\n"
"       Interview</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.dillo.org/D_authors.html'>\n"
"     Authors</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.dillo.org/donations.html'>\n"
"     Donate</a>\n"
"    </table>\n"
"    </table>\n"
"  </table>\n"
"</table>\n"
"\n"
"<br>\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
" <td>\n"
"  <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"  <tr>\n"
"    <td colspan='1' bgcolor='#CCCCCC'>News\n"
"\n"
"  <tr>\n"
"   <td bgcolor='#FFFFFF'>\n"
"    <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"    <table border='0' cellpadding='2'>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://lwn.net/'>LWN</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://slashdot.org/'>Slashdot</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.linux.org.uk/Portaloo.cs'>Linux.org.uk</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.commondreams.org/'>C.&nbsp;Dreams</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.voltairenet.org/'>VoltaireNet</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td>\n"
"     <a href='http://www.nexusmagazine.com/'>Nexus&nbsp;M.</a>\n"
"    </table>\n"
"    </table>\n"
"  </table>\n"
"</table>\n"
"\n"
"<br>\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
" <td>\n"
"  <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"  <tr>\n"
"   <td colspan='1' bgcolor='#CCCCCC'>Additional Stuff\n"
"\n"
"  <tr>\n"
"   <td bgcolor='#FFFFFF'>\n"
"    <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"    <table border='0' cellpadding='2'><tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td><a href='http://www.google.com/'>Google</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td><a href='http://www.wikipedia.org/'>Wikipedia</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td><a href='http://www.gutenberg.org/'>P.&nbsp;Gutenberg</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td><a href='http://freshmeat.net/'>FreshMeat</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td><a href='http://www.gnu.org/gnu/thegnuproject.html'>GNU\n"
"     project</a>\n"
"    <tr>\n"
"    <td>&nbsp;&nbsp;\n"
"    <td><a href='http://www.linuxfund.org/'>LinuxFund</a>\n"
"    </table>\n"
"    </table>\n"
"  </table>\n"
"</table>\n"
"\n"
"<br>\n"
"\n"
"<table border='0' cellspacing='0' cellpadding='0' width='140' bgcolor='#000000'>\n"
"<tr>\n"
" <td>\n"
"   <table width='100%' border='0' cellspacing='1' cellpadding='3'>\n"
"   <tr>\n"
"    <td colspan='1' bgcolor='#CCCCCC'>Essential Readings\n"
"\n"
"   <tr>\n"
"    <td bgcolor='#FFFFFF'>\n"
"     <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"     <table border='0' cellpadding='2'>\n"
"     <tr><td>&nbsp;&nbsp;\n"
"     <td><a href='http://www.violence.de'>Peace&amp;Violence</a>\n"
"     <tr><td>&nbsp;&nbsp;\n"
"     <td><a href='http://www.gnu.org/philosophy/right-to-read.html'>"
"      Right to Read</a>\n"
"     </table>\n"
"     </table>\n"
"   </table>\n"
"</table>\n"
"\n"
"<table border='0' width='100%' cellpadding='0' cellspacing='0'><tr><td height='10'></table>\n"
"\n"
"\n"
"<!-- the main layout table, a small vertical spacer -->\n"
"\n"
"<td width='20'><td valign='top'>\n"
"\n"
"\n"
"<!--   Main Part of the page   -->\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
" <td bgcolor='#CCCCCC'>\n"
"  <h4>Free Software</h4>\n"
"<tr>\n"
" <td bgcolor='#FFFFFF'>\n"
"  <table border='0' cellspacing='0' cellpadding='5'><tr><td>\n"
"  <p>\n"
"  Dillo is Free Software in the terms of the GPL3.\n"
"  This means you have four basic freedoms:\n"
"  <ul>\n"
"   <li>Freedom to use the program any way you see fit.\n"
"   <li>Freedom to study and modify the source code.\n"
"   <li>Freedom to make backup copies.\n"
"   <li>Freedom to redistribute it.\n"
"  </ul>\n"
"  The <a href='http://www.gnu.org/licenses/gpl.html'>GPL3</a>\n"
"  is the legal mechanism that gives you these freedoms.\n"
"  It also protects them from being taken away: any derivative work\n"
"  based on the program must be under the GPL3.<br>\n"
"  </table>\n"
"</table>\n"
"</table>\n"
"\n"
"<br>\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
" <td bgcolor='#CCCCCC'>\n"
"  <h4>Release overview</h4>\n"
"  October 14, 2008\n"
"<tr>\n"
" <td bgcolor='#FFFFFF'>\n"
"  <table border='0' cellspacing='0' cellpadding='5'>\n"
"  <tr>\n"
"   <td>\n"
"<p>\n"
"This is a rewrite of dillo, using FLTK2, that comes\n"
"with lots of improvements and fixes.\n"
"<p>\n"
"Our users will surely enjoy this new release as it will give them\n"
"the  same  things they're accustomed plus tabbed browsing,\n"
"antialiasing, different\n"
"character  sets,  accepting  compressed pages, control over image\n"
"loading, smaller footprint, fewer dependencies, better table\n"
"rendering, bugfixes, improved GUI, ... In brief, a better dillo.\n"
"<p>\n"
"Remember that dillo project uses a release model where every new\n"
"browser shall be better than the former.\n"
"<EM>Keep up with the latest one!</EM>\n"
"  </table>\n"
"</table>\n"
"</table>\n"
"\n"
"<br>\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
" <td bgcolor='#CCCCCC'>\n"
"  <h4>ChangeLog highlights</h4>\n"
"  (Extracted from the\n"
"  <a href='http://cvs.auriga.wearlab.de/cgi-bin/cvsweb.cgi/dillo2/ChangeLog?rev=HEAD;cvsroot=dillo'>full\n"
"  ChangeLog</a>)\n"
"<tr>\n"
" <td bgcolor='#FFFFFF'>\n"
"  <table border='0' cellspacing='0' cellpadding='5'>\n"
"  <tr>\n"
"   <td>\n"
"<ul>\n"
"<li>Ported Dillo from GTK1 to FLTK2."
"<li>Ported a susbstantial part of the code from C to C++ (FLTK2 is in C++)."
"<li>Wrote a new library: Dlib. With 'Dlib' Dillo doesn't need glib anymore."
"<li>Ported all the code to Dlib."
"<li>Made Dillo's UI Control Panel resizable on-the-fly."
"<li>Implemented a new, simpler, dillorc parser."
"<li>Reimplemented the Concomitant Callback chains into a uniform scheme!"
"<li>Removed threads from IO. Now it only uses select-based watches."
"<li>Simplified http.c by reusing the new non-blocking writes in IO."
"<li>Implemented Stop button to not only stop rendering but also networking."
"<li>Bound Ctrl+Space to toggle fullscreen mode."
"<li>Added a http_referer preference. See details in dillorc."
"<li>CCC: added reentrancy control to the OpEnd and OpAbort operations."
"<li>CCC: enhanced the debug function and implemented OpAbort for dpi."
"<li>Hooked a decoder for text/plain with charset."
"<li>Forbid dpi GET and POST from non dpi-generated urls."
"<li>Implemented tabbed browsing."
"<li>Added a image-loading toggle button to the UI."
"<li>Added line numbers and enabled wrapping in the 'View Source' window."
"<li>Added HTTP-1.1's chunked transfer support!"
"<li>Made the stop button sensitive when loading an image."
"<li>Added support for 'charset' in the HTTP header field for Content-Type."
"<li>Added support for 'charset' in the META element."
"<li>Added the multipart/form-data encoding method to form submission."
"<li>Made zlib a configure requirement, and cleaned up configure.in."
"<li>Enabled the file dpi to look inside gzipped files."
"<li>Added code for optional image loading (nice interface)!"
"<li>Fixed data guesser to detect ASCII, LATIN1, UTF8, KOI8-R, CP-1251 as"
" text."
"<li>Fixed void to int conversions for 64bit-arch."
"<li>Set the url resolver to escape illegal chars instead of stripping."
"<li>Big html.cc cleanup. New classes, form API, source split."
"<li>Added int32_t, EAI_NODATA and iconv tests for FreeBSD."
"<li>Replaced the findtext dialog with an in-window widget!"
"</ul>\n"
"Dw2:<br>\n"
"<ul>\n"
"<li>Enabled clipped redraws (avoids some flickering)."
"<li>Added combination of drawing rectangles into a larger one."
"<li>Made getWidgetAtPoint() a virtual method of widget and implemented a"
"   custom one for TextBlock, reducing CPU usage on pages full of links."
"<li>Set FltkViewBase::draw to intersect with view area for expose."
"<li>Added double buffering for partial redraws!"
"<li>Reduced memory usage in 30% by reusing styles, reducing the size"
"   of struct Content, and not preallocating in SimpleVector. !"
"<li>Moved highlighting information from struct Word into Textblock"
"   to save memory."
"<li>Reduced memory usage 10% with a custom memory handler in Textblock."
"<li>Implemented selection of multibyte glyphs (UTF-8)."
"<li>Fixed a slithery BUG in lout::misc::Stringbuffer."
"<li>Added 'enter' and 'leave' signals into class Resource."
"<li>Enabled mouse wheel scrolling."
"<li>Added setDeleteCallback(DW_Callback_t func, void *data) to widget."
"   This allows to hook a callback when the widget is destroyed."
"<li>Changed the table-apportion algorithms + bug fixes. Big work!"
"</ul>\n"
"  </table>\n"
"</table>\n"
"</table>\n"
"\n"
"<br>\n"
"\n"
"<table border='0' cellpadding='0' cellspacing='0' align='center' bgcolor='#000000' width='100%'><tr><td>\n"
"<table border='0' cellpadding='5' cellspacing='1' width='100%'>\n"
"<tr>\n"
" <td bgcolor='#CCCCCC'>\n"
"  <h4>Notes</h4>\n"
"<tr>\n"
" <td bgcolor='#FFFFFF'>\n"
"  <table border='0' cellspacing='0' cellpadding='5'>\n"
"  <tr>\n"
"   <td>\n"
"<ul>\n"
" <li> There's a\n"
"   <a href='http://www.dillo.org/dillorc'>dillorc</a>\n"
"   (readable  config)  file within the tarball; It is well commented\n"
"   and  has  plenty  of  options to customize dillo, so <STRONG>copy\n"
"   it</STRONG>  to  your  <STRONG>~/.dillo/</STRONG>  directory, and\n"
"   modify to your taste.\n"
" <li> There's documentation for developers in the <CODE>/doc</CODE>\n"
"   dir  within  the  tarball;  you can find directions on everything\n"
"   else at the home page.\n"
" <li> Dillo has context sensitive menus using the\n"
"   right mouse button (available on pages, links, images,\n"
"   the Back and Forward buttons, and bug meter).\n"
" <li> Dillo behaves very nicely when browsing local files, images, and HTML.\n"
"   It's also very good for Internet searching.\n"
" <li> This release is mainly intended <strong>for developers</strong>\n"
"   and <em>advanced users</em>.\n"
" <li> Frames, Java and Javascript are not supported.\n"
"</ul>\n"
"<br>\n"
"  </table>\n"
"</table>\n"
"</table>\n"
"\n"
"<table border='0' width='100%' cellpadding='0' cellspacing='0'><tr><td height='10'></table>\n"
"\n"
"\n"
"<!-- the main layout table, a small vertical spacer -->\n"
"\n"
"<td width='20'>\n"
"\n"
"\n"
"\n"
"<!--   The right column (info)   -->\n"
"<td valign='top' align='center'>\n"
"\n"
"\n"
"\n"
"<!-- end of the main layout table -->\n"
"\n"
"\n"
"</table>\n"
"\n"
"<!--   footnotes   -->\n"
"\n"
"<br><br><center>\n"
"<hr size='2'>\n"
"<hr size='2'>\n"
"</center>\n"
"</body>\n"
"</html>\n";

