#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/dovecot.conf.new

( cd usr/lib/dovecot/lda ; rm -rf lib11_trash_plugin.so )
( cd usr/lib/dovecot/lda ; ln -sf ../lib11_trash_plugin.so lib11_trash_plugin.so )
( cd usr/lib/dovecot/lda ; rm -rf lib10_quota_plugin.so )
( cd usr/lib/dovecot/lda ; ln -sf ../lib10_quota_plugin.so lib10_quota_plugin.so )
( cd usr/lib/dovecot/lda ; rm -rf lib01_acl_plugin.so )
( cd usr/lib/dovecot/lda ; ln -sf ../lib01_acl_plugin.so lib01_acl_plugin.so )
( cd usr/lib/dovecot/lda ; rm -rf lib20_convert_plugin.so )
( cd usr/lib/dovecot/lda ; ln -sf ../lib20_convert_plugin.so lib20_convert_plugin.so )
( cd usr/lib/dovecot/lda ; rm -rf lib20_mail_log_plugin.so )
( cd usr/lib/dovecot/lda ; ln -sf ../lib20_mail_log_plugin.so lib20_mail_log_plugin.so )
( cd usr/lib/dovecot/pop3 ; rm -rf lib10_quota_plugin.so )
( cd usr/lib/dovecot/pop3 ; ln -sf ../lib10_quota_plugin.so lib10_quota_plugin.so )
( cd usr/lib/dovecot/pop3 ; rm -rf lib20_convert_plugin.so )
( cd usr/lib/dovecot/pop3 ; ln -sf ../lib20_convert_plugin.so lib20_convert_plugin.so )
( cd usr/lib/dovecot/pop3 ; rm -rf lib02_lazy_expunge_plugin.so )
( cd usr/lib/dovecot/pop3 ; ln -sf ../lib02_lazy_expunge_plugin.so lib02_lazy_expunge_plugin.so )
( cd usr/lib/dovecot/pop3 ; rm -rf lib20_mail_log_plugin.so )
( cd usr/lib/dovecot/pop3 ; ln -sf ../lib20_mail_log_plugin.so lib20_mail_log_plugin.so )
( cd usr/lib/dovecot/imap ; rm -rf lib11_trash_plugin.so )
( cd usr/lib/dovecot/imap ; ln -sf ../lib11_trash_plugin.so lib11_trash_plugin.so )
( cd usr/lib/dovecot/imap ; rm -rf lib10_quota_plugin.so )
( cd usr/lib/dovecot/imap ; ln -sf ../lib10_quota_plugin.so lib10_quota_plugin.so )
( cd usr/lib/dovecot/imap ; rm -rf lib01_acl_plugin.so )
( cd usr/lib/dovecot/imap ; ln -sf ../lib01_acl_plugin.so lib01_acl_plugin.so )
( cd usr/lib/dovecot/imap ; rm -rf lib20_convert_plugin.so )
( cd usr/lib/dovecot/imap ; ln -sf ../lib20_convert_plugin.so lib20_convert_plugin.so )
( cd usr/lib/dovecot/imap ; rm -rf lib02_lazy_expunge_plugin.so )
( cd usr/lib/dovecot/imap ; ln -sf ../lib02_lazy_expunge_plugin.so lib02_lazy_expunge_plugin.so )
( cd usr/lib/dovecot/imap ; rm -rf lib20_mail_log_plugin.so )
( cd usr/lib/dovecot/imap ; ln -sf ../lib20_mail_log_plugin.so lib20_mail_log_plugin.so )
