/***************************************************************************
 *   Copyright (C) 2005 by Tommaso frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ECIKONTROLCONFIGWIZARD_H
#define ECIKONTROLCONFIGWIZARD_H

#include "eciKontrolConfigWizard.h"

#include <kconfig.h>

#include <qlistbox.h>
#include <qstringlist.h>

class eciKontrolConfigWizard: public frmConfignWizard {
Q_OBJECT
private: 
    KConfig * eciconf;

    void loadDatabaseIntoList(QString database, QListBox* list, int last_params=0, QString selected_start_with="");
    void readBinaries(QString folder);
    QStringList getRecordParams(QString record);
    QString getRecordDesc(QString record);

    virtual void frmConfignWizard_selected(const QString&);
public slots:
    virtual void lstProvider_highlighted(const QString&);
    virtual void btnHowGetIP_released(int);
    virtual void btnSelectPath_clicked();
    virtual void lstModem_highlighted(const QString&);
    virtual void finishButton_clicked();


public:
    eciKontrolConfigWizard(QWidget *parent = 0, const char *name = 0);
};

#endif
