//
// C++ Implementation: $MODULE$
//
// Description: 
//
//
// Author: Tommaso Frazzetto <tommaso.frazzetto@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <qtoolbutton.h>
#include <qtable.h>
#include <qheader.h>
#include <qprocess.h>
#include <qprogressbar.h>
#include <qgroupbox.h>

#include <kglobal.h>
#include <kiconloader.h>

#include <iostream.h>

#include "ecikontroldoctrodialog.h"

eciKontrolDoctroDialog::eciKontrolDoctroDialog(QWidget *parent, const char *name)
    :dlgDoctor(parent, name)
{
    btnClose->setPixmap(KGlobal::iconLoader()->loadIcon("fileclose", KIcon::MainToolbar));
    tblTestResult->setLeftMargin(0);
    tblTestResult->setTopMargin(0);
    tblTestResult->setColumnWidth(0, 180);
    tblTestResult->setColumnWidth(1, 180);

    

    doctor_process = new QProcess();
    QString command("/usr/local/bin/eciadsl-doctor");
    doctor_process->addArgument(command);
    connect( doctor_process, SIGNAL(readyReadStdout()), this, SLOT(doctorReadFromStdout()));
    connect( doctor_process, SIGNAL(processExited()), this, SLOT(doctorExit()));
    doctor_process->start();
    tests_passed = 0;
}

void eciKontrolDoctroDialog::btnClose_clicked()
{
    if (doctor_process->isRunning())
	doctor_process->tryTerminate();

    delete doctor_process;
    hide();
}

void eciKontrolDoctroDialog::doctorReadFromStdout()
{
    while (doctor_process->canReadLineStdout()) {
        QString string = doctor_process->readLineStdout();
        cout<<string;

        if (string.startsWith("You are using linux kernel version")) 
        {
            tblTestResult->setText(0,0, "Kernel Version");
            tblTestResult->setText(0,1, getSubString(string, string.find("version", 0, FALSE), string.length()));
            tblTestResult->setPixmap(0,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
            tblTestResult->setRowHeight(0, 25);
	    tests_passed++;
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("Support for USB") && !string.startsWith("Support for USB is missing")) 
        {
            tblTestResult->setText(1,0, "USB Support");
            QString token = getSubString(string, string.find("USB ", 0, FALSE), string.length());
            tblTestResult->setText(1,1, token);
 
            if (token.endsWith("OK"))
	    {
                tblTestResult->setPixmap(1,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
	    	tests_passed++;
	    }
            else
                tblTestResult->setPixmap(1,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));

            tblTestResult->setRowHeight(1, 25);	    
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("Preliminary USB device filesystem") && !string.startsWith("Preliminary USB device filesystem is missing")) 
        {
            tblTestResult->setText(2,0, "Preliminary USB device filesystem");
            QString token = getSubString(string, string.find("filesystem ", 0, FALSE), string.length());
            tblTestResult->setText(2,1, token);
 
            if (token.endsWith("OK"))
	    {
                tblTestResult->setPixmap(2,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
	    	tests_passed++;
	    }
            else
                tblTestResult->setPixmap(2,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));

            tblTestResult->setRowHeight(2, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("dabusb module") && !string.endsWith("unload!")) 
        {
            tblTestResult->setText(3,0, "dabusb module");
            QString token = getSubString(string, string.find("module ", 0, FALSE), string.length());
            tblTestResult->setText(3,1, token);
 
            if (token.endsWith("OK"))
	    {
                tblTestResult->setPixmap(3,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
	    	tests_passed++;
	    }
            else
                tblTestResult->setPixmap(3,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));

            tblTestResult->setRowHeight(3, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("UHCI support") && !string.startsWith("UHCI support is missing")) 
        {
            tblTestResult->setText(4,0, "UHCI Support");
            QString token = getSubString(string, string.find("support ", 0, FALSE), string.length());
 
            if (token.endsWith("OK")) 
            {
                tblTestResult->setPixmap(4,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(4,1, "Support is OK");
	    	tests_passed++;
            }
            else
            {
                tblTestResult->setPixmap(4,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                tblTestResult->setText(4,1, "Failed to load");
            }
            tblTestResult->setRowHeight(4, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("OHCI support") && !string.startsWith("OHCI support is missing")) 
        {
            tblTestResult->setText(5,0, "OHCI Support");
            QString token = getSubString(string, string.find("support ", 0, FALSE), string.length());
 
            if (token.endsWith("OK")) 
            {
                tblTestResult->setPixmap(5,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(5,1, "Support is OK");
   	    	tests_passed++;
	    }
            else if (token.endsWith("needed")) 
            {
                tblTestResult->setPixmap(5,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(5,1, "Support not needed");
	    	tests_passed++;
            }
            else
            {
                tblTestResult->setPixmap(5,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                tblTestResult->setText(5,1, "Failed to load");
            }
            tblTestResult->setRowHeight(5, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("/dev/ppp")) 
        {
            tblTestResult->setText(6,0, "PPP Device (/dev/ppp)");
            
            QString token = getSubString(string, string.find("ppp", 0, FALSE), string.length());
            

            if (token.endsWith("OK")) 
            {
                tblTestResult->setPixmap(6,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(6,1, "Device is OK");
	    	tests_passed++;
            }
            else
            {
                tblTestResult->setPixmap(6,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                tblTestResult->setText(6,1, "Failed to load (" + token + ")");
            }
            tblTestResult->setRowHeight(6, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("HDLC support") && !string.startsWith("HDLC support is missing")) 
        {
            tblTestResult->setText(7,0, "HDLC Support");
            QString token = getSubString(string, string.find("support ", 0, FALSE), string.length());
 
            if (token.endsWith("OK") || token.endsWith("(no bug)")) 
            {
                tblTestResult->setPixmap(7,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(7,1, "Support is OK");
	    	tests_passed++;
            }
            else
            {
                tblTestResult->setPixmap(7,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                tblTestResult->setText(7,1, "Failed to load");
            }
            tblTestResult->setRowHeight(7, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("You are using pppd version") || string.startsWith("No pppd is intalled")) 
        {
            if (string.startsWith("No pppd is intalled"))
            {
                tblTestResult->setText(8,0, "PPP Daemon Version");
                tblTestResult->setText(8,1, getSubString(string, string.find("not installed", 0, FALSE), string.length()));
                tblTestResult->setPixmap(8,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                tblTestResult->setRowHeight(8, 25);
	    	tests_passed++;
            }
            else
            {
                tblTestResult->setText(8,0, "PPP Daemon Version");
                tblTestResult->setText(8,1, getSubString(string, string.find("version ", 0, FALSE), string.length()));
                tblTestResult->setPixmap(8,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setRowHeight(8, 25);
            }
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("PPP connection")) 
        {
            tblTestResult->setText(9,0, "PPP Connection");
 
            if (string.endsWith("OK")) 
            {
                tblTestResult->setPixmap(9,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(9,1, "OK");
	    	tests_passed++;
            }
            else
            {
                tblTestResult->setPixmap(9,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                tblTestResult->setText(9,1, "Failed to connect (" + string + ")");
            }
            tblTestResult->setRowHeight(9, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }
        else if (string.startsWith("Default route")) 
        {
            tblTestResult->setText(10,0, "PPP Default route");
 
            if (string.endsWith("OK")) 
            {
                tblTestResult->setPixmap(10,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(10,1, "OK");
	    	tests_passed++;
            }
            else
            {
                tblTestResult->setPixmap(10,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                tblTestResult->setText(10,1, "Failed to connect (" + string + ")");
            }

            tblTestResult->setRowHeight(10, 25);
	    pbTesting->setProgress(pbTesting->progress() + 1);
        }

    }
}

void eciKontrolDoctroDialog::doctorExit() {
	gbTestingMessage->hide();
        tblTestResult->setText(12,0, "Final report");

	if (tests_passed >= 11) 
	{
		tblTestResult->setPixmap(12,1, KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
                tblTestResult->setText(12,1, "Everything seems to be OK");
	}
	else
	{
		tblTestResult->setPixmap(12,1, KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
                QString * tests_passed_string = new QString();
		tblTestResult->setText(12,1, "There some problems (" + tests_passed_string->setNum(tests_passed) + "/11)");
		delete tests_passed_string;
	}
}

QString eciKontrolDoctroDialog::getSubString(QString& source, int start, int end) 
{ 
    if (source.isEmpty() || start <= 0 || end <= start)
        return "";
    

    return source.right(source.length() - start).left(end - start);
}

#include "ecikontroldoctrodialog.moc"
