//
// C++ Implementation: $MODULE$
//
// Description: 
//
//
// Author: Tommaso Frazzetto <tommaso.frazzetto@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <qlistbox.h>
#include <qpushbutton.h>

#include <kconfig.h>
#include <kmessagebox.h>

#include "ecikontrolvalidssynchbin.h"

eciKontrolValidsSynchBin::eciKontrolValidsSynchBin(QWidget *parent, const char *name)
    :dlgValidsSynchBin(parent, name)
{
}

eciKontrolValidsSynchBin::~eciKontrolValidsSynchBin()
{
}

void eciKontrolValidsSynchBin::addValidSynchBin(QString &bin) 
{
	lstValids->insertItem(bin);
}

void eciKontrolValidsSynchBin::btnClose_clicked()
{
	close();
}

void eciKontrolValidsSynchBin::lstValids_selected(const QString& item)
{
	btnUse_clicked();
}

void eciKontrolValidsSynchBin::btnUse_clicked()
{
	KConfig * eciconf = new KConfig("/etc/eciadsl/eciadsl.conf");
	eciconf->writeEntry("SYNCH", lstValids->currentText());
	eciconf->sync();
	delete eciconf;

	KMessageBox::information(this, "Now you synchronization binary file is:\n" + lstValids->currentText(), "Synchronization Binary Changed");
}

void eciKontrolValidsSynchBin::lstValids_clicked(QListBoxItem* item,const QPoint& point)
{

}

void eciKontrolValidsSynchBin::lstValids_clicked(QListBoxItem* item)
{
	if (!btnUse->isEnabled())
		btnUse->setEnabled(TRUE);
}








#include "ecikontrolvalidssynchbin.moc"
