// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const HK_CONTRACTID = "@flock.com/housekeeper;1";
const HK_CLASSID    = Components.ID("{e8415493-ab17-463e-837d-8516fce89364}");
const HK_CLASSNAME  = "Flock Housekeeper";

const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockXPCOMUtils.jsm");


const CATEGORY_HOUSEKEEPING = "flockHousekeeping";

const PREF_HOUSEKEEPING_INTERVAL = "flock.housekeeping.interval";


function getObserverService() {
  return CC["@mozilla.org/observer-service;1"]
         .getService(CI.nsIObserverService);
}


function Housekeeper() {
  var obs = getObserverService();

  obs.addObserver(this, "flock-data-ready", false);
  obs.addObserver(this, "flock-shutdown", false);
}

Housekeeper.prototype = new FlockXPCOMUtils.genericComponent(
  HK_CLASSNAME,
  HK_CLASSID,
  HK_CONTRACTID,
  Housekeeper,
  CI.nsIClassInfo.SINGLETON,
  [
    CI.flockIHousekeeper,
    CI.nsITimerCallback,
    CI.nsIObserver
  ]
);

Housekeeper.prototype._xpcom_categories = [
  { category: "flock-startup", service: true }
];

Housekeeper.prototype._start =
function HK__start() {
  this._logger = CC["@flock.com/logger;1"].createInstance(CI.flockILogger);
  this._logger.init("housekeeper");
  this._logger.info("starting up...");

  var prefs = CC["@mozilla.org/preferences-service;1"]
              .getService(CI.nsIPrefBranch);
  var interval = prefs.getIntPref(PREF_HOUSEKEEPING_INTERVAL);

  var tm = CC["@mozilla.org/updates/timer-manager;1"]
           .getService(CI.nsIUpdateTimerManager);
  tm.registerTimer("background-housekeeping-timer", this, interval);
}

Housekeeper.prototype._shutdown =
function HK__shutdown() {
}

Housekeeper.prototype.observe =
function HK_observe(aSubject, aTopic, aState) {
  var obs = getObserverService();

  switch (aTopic) {
    case "flock-data-ready":
      obs.removeObserver(this, "flock-data-ready");
      this._start();
      break;

    case "flock-shutdown":
      obs.removeObserver(this, "flock-shutdown");
      this._shutdown();
      break;
  }
}

Housekeeper.prototype.notify =
function HK_notify(timer) {
  this.doHousekeeping();
}

Housekeeper.prototype.doHousekeeping =
function HK_doHousekeeping() {
  var catman = CC["@mozilla.org/categorymanager;1"]
               .getService(CI.nsICategoryManager);

  var entries = catman.enumerateCategory(CATEGORY_HOUSEKEEPING);
  while (entries.hasMoreElements()) {
    try {
      var entry = entries.getNext().QueryInterface(CI.nsISupportsCString).data;
      var contractID = catman.getCategoryEntry(CATEGORY_HOUSEKEEPING, entry);

      this._logger.info("Running housekeeping: " + contractID);
      var service = CC[contractID].getService(CI.flockIHousekeeping);
      service.runHousekeeping();
    }
    catch (ex) {
      this._logger.error("Error running housekeeping: " + ex);
    }
  }
}

var gComponentsArray = [Housekeeper];

var NSGetModule = FlockXPCOMUtils.generateNSGetModule(HK_CLASSNAME,
                                                      gComponentsArray);
