// BEGIN FLOCK GPL
// 
// Copyright Flock Inc. 2005-2007
// http://flock.com
// 
// This file may be used under the terms of of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
// 
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
// 
// END FLOCK GPL

var EXPORTED_SYMBOLS = ["flockXMLEncode", "flockXMLDecode"];

/**
 * Encode special characters as XML character entities for inclusion in XML.
 */
function flockXMLEncode(aString) {
  // When encoding, do ampersands FIRST.
  return aString.replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;")
                .replace(/\'/g, "&apos;")
                .replace(/\"/g, "&quot;");
}

/**
 * Decode XML character entities for presentation.
 */
function flockXMLDecode(aString) {
  // When decoding, do ampersands LAST.
  return aString.replace(/&lt;/g, "<")
                .replace(/&gt;/g, ">")
                .replace(/&apos;/g, "'")
                .replace(/&quot;/g, '"')
                .replace(/&amp;/g, "&");
}
