// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

/*
 * nsISimpleEnumerator implementation
 */
 
function simpleEnumerator (aArray) {
  this.data = aArray;
}

simpleEnumerator.prototype = {
  hasMoreElements: function () { 
    return this.data.length != 0; 
  },
  getNext: function () { 
    return this.data.shift (); 
  },
  getInterfaces: function (count) {
    var interfaceList = [Components.interfaces.nsISimpleEnumerator, Components.interfaces.nsIClassInfo];
    count.value = interfaceList.length;
    return interfaceList;
  },
  QueryInterface: function (iid) {
    if (!iid.equals(Components.interfaces.nsISimpleEnumerator))
      throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  },
  getHelperForLanguage: function (count) {return null;}
}

/*
 * BlogCategory class: an simple implementation for flockIBlogCategory
 */

function BlogCategory(aId, aLabel) {
  this.id = aId;
  this.label = aLabel;
}

BlogCategory.prototype = {
  getInterfaces: function (count) {
    var interfaceList = [Components.interfaces['flockIBlogCategory'], nsIClassInfo];
    count.value = interfaceList.length;
    return interfaceList;
  },
  QueryInterface: function (iid) {
    if (!iid.equals(Components.interfaces.flockIBlogCategory))
      throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  }
}

/*
 * BlogPost class: an simple implementation for flockIBlogPost
 */

function BlogPost() {
  this.postid = "";
  this.title = "";
  this.description = "";
  this.tags = null;
  this.categories = null;
  this.extra = null;
}

BlogPost.prototype = {
  getInterfaces: function (count) {
    var interfaceList = [Components.interfaces['flockIBlogPost'], nsIClassInfo];
    count.value = interfaceList.length;
    return interfaceList;
  },
  QueryInterface: function (iid) {
    if (!iid.equals(Components.interfaces.flockIBlogPost))
      throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  }
}
