// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

function addTechnoratiTags(tags) {
  if(!tags.hasMore()) return "";

  var localeService = Components.classes["@mozilla.org/intl/nslocaleservice;1"].getService(Components.interfaces.nsILocaleService);
  var stringBundleService = Components.classes["@mozilla.org/intl/stringbundle;1"].getService(Components.interfaces.nsIStringBundleService);
  var stringBundle = stringBundleService.createBundle("chrome://flock/locale/blog/blog.properties", localeService.getApplicationLocale());

  var string = stringBundle.GetStringFromName("flock.blog.tags");

  var tag_html = "";
  tag_html += '<!-- technorati tags begin -->';
  tag_html += '<p style="font-size:10px;text-align:right;">'
           + string+": ";

  while (tags.hasMore()) {
    var tag = tags.getNext();
    if(tag[0]=="\"") tag = tag.substring(1);
    if(tag[tag.length-1]=="\"") tag = tag.substring(tag,tag.length-1);

    tag_html += '<a href="http://technorati.com/tag/';
    tag_html += encodeURIComponent(tag);
    tag_html += '" rel="tag">';
    tag_html += tag;
    tag_html += '</a>';
    if(tags.hasMore()) {
      tag_html += ", ";
    }
  }

  tag_html += '</p>';
  tag_html +="<!-- technorati tags end -->";

  return tag_html;
}


