//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

// the default object definitions for the Favorites datastore
// passed into this environment are Coop (the type) and coop (the instance)

const FLOCK_NS = "http://flock.com/rdf#";
const NSCP_NS = "http://home.netscape.com/NC-rdf#";
const RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
const WEB_NS = "http://home.netscape.com/WEB-rdf#";
const FOAF_NS = "http://xmlns.com/foaf/0.1/";
  
coop.CardinalFavorite = coop.add_type (FLOCK_NS + "Favorite", {
  fields: {
    URL: NSCP_NS + "URL",
    Name: NSCP_NS + "Name",
    favicon: FLOCK_NS + "favicon",
    tags: FLOCK_NS + "tags",
    description: NSCP_NS + "Description",
    LastModifiedDate: WEB_NS + "LastModifiedDate",
    FavoriteAddDate: FLOCK_NS + "FavoriteAddDate",
    rdftype: RDF_NS + "type"
  },
  field_types: {
    LastModifiedDate: Coop.date,
    FavoriteAddDate: Coop.date
   }
});

coop.CardinalCollection = coop.add_type (FLOCK_NS + "Collection", {
  fields: {
    Name: NSCP_NS + "Name",
    toolbar: FLOCK_NS + "toolbar",
    rdftype: RDF_NS + "type"
  },
  field_types: {
    toolbar: Coop.boolean
  },
  container: "Seq"
});

coop.CardinalPhotoPerson = coop.add_type (FLOCK_NS + "PhotoPerson", {
  fields: {
    id: FLOCK_NS + "id",
    iconUrl: FLOCK_NS + "iconUrl",
    apiType: FLOCK_NS + "apiShortName",
    fullname: FLOCK_NS + "fullname",
    fullname: FLOCK_NS + "fullname",
    username: FLOCK_NS + "username",
    Name: NSCP_NS + "Name"
  }
});

coop.CardinalFeed = coop.add_type( FLOCK_NS + "Feed", {
  fields: {
    subscribed: FLOCK_NS + "subscribed",
    title: FLOCK_NS + "title",
    last_refreshed: FLOCK_NS + "last_refreshed",
    type: FLOCK_NS + "type",
    total: FLOCK_NS + "total",
    unread: FLOCK_NS + "unread",
    favicon: FLOCK_NS + "favicon"
  },
  field_types: {
    subscribed: Coop.boolean,
    title: Coop.string,
    last_refreshed: Coop.date,
    type: Coop.string,
    total: Coop.integer,
    unread: Coop.boolean,
    favicon: Coop.string
  }
});
