// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

//@line 18 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/common/src/flockBuildDetails.js"

const BUILD_DETAILS_CLASSNAME = "Flock Build Details";
const BUILD_DETAILS_CLASSID =
  Components.ID("{14464cbd-2ec0-4ad3-996e-6ba88e626783}");
const BUILD_DETAILS_CONTRACTID = "@flock.com/build-details;1";

const INI_FILENAME = "builddetails.ini"
const INI_SECTION = "BuildDetails";


const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockXPCOMUtils.jsm");


function BuildDetails() {
  try {
    var iniFile = CC["@mozilla.org/file/directory_service;1"]
                  .getService(CI.nsIProperties)
                  .get("XCurProcD", CI.nsILocalFile);
    iniFile.append(INI_FILENAME);

    this._ini = CC["@mozilla.org/xpcom/ini-parser-factory;1"]
                .getService(CI.nsIINIParserFactory)
                .createINIParser(iniFile);
  } catch (ex) {
    this._ini = null;
  }
}

BuildDetails.prototype = new FlockXPCOMUtils.genericComponent(
  BUILD_DETAILS_CLASSNAME,
  BUILD_DETAILS_CLASSID,
  BUILD_DETAILS_CONTRACTID,
  BuildDetails,
  CI.nsIClassInfo.SINGLETON,
  [CI.flockIBuildDetails]
);

BuildDetails.prototype._xpcom_categories = [
  { category: "flock-startup", service: true }
];

BuildDetails.prototype.__defineGetter__("buildID",
function BD_getter_buildID() {
  return (this.timestamp / 1000000) + "." + this.scmID;
});

BuildDetails.prototype.__defineGetter__("debugBuild",
function BD_getter_debugBuild() {
//@line 74 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/common/src/flockBuildDetails.js"
  return false;
//@line 76 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/common/src/flockBuildDetails.js"
});

BuildDetails.prototype.__defineGetter__("timestamp",
function BD_getter_timestamp() {
//@line 83 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/common/src/flockBuildDetails.js"
  var timestamp = 0;

  if (this._ini) {
    try {
      timestamp = Number(this._ini.getString(INI_SECTION, "timestamp"));
    } catch (ex) {
      // inherit default
    }
  }
//@line 93 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/common/src/flockBuildDetails.js"

  return Math.round(timestamp) * 1000000;
});

BuildDetails.prototype.__defineGetter__("scmID",
function BD_getter_scmID() {
  var scmID = "unknown";

//@line 102 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/common/src/flockBuildDetails.js"
  if (this._ini) {
    try {
      scmID = this._ini.getString(INI_SECTION, "scmID");
    } catch (ex) {
      // inherit default
    }
  }
//@line 110 "/home/build/tinderbuild_blue/src/flock/mozilla/flock/base/common/src/flockBuildDetails.js"

  return scmID;
});

BuildDetails.prototype.__defineGetter__("baseFirefoxVersion",
function BD_getter_baseFirefoxVersion() {
  return "3.0.4";
});

var gComponentsArray = [BuildDetails];

var NSGetModule = FlockXPCOMUtils.generateNSGetModule(BUILD_DETAILS_CLASSNAME,
                                                      gComponentsArray);
