// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const CC = Components.classes;
const CI = Components.interfaces;
const CU = Components.utils;

const CLASS_ID                = Components.ID("{7214FC64-FDA0-4DCD-B790-146265F8FA42}");
const CLASS_NAME              = "Flock Protocol Handler";
const CONTRACT_ID             = "@mozilla.org/network/protocol;1?name=flock";


function flockFlockHandler()
{
}

flockFlockHandler.prototype = {

  scheme: "flock",
  defaultPort: -1,
  protocolFlags: Components.interfaces.nsIProtocolHandler.URI_NORELATIVE | Components.interfaces.nsIProtocolHandler.URI_NOAUTH,
  
  allowPort: function(port, scheme)
  {
    return false;
  },
  
  newChannel: function(URI)
  {
    var url = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIStandardURL);
    url.init(Components.interfaces.nsIStandardURL.URLTYPE_STANDARD, -1, URI.spec, null, null);
    url.QueryInterface(Components.interfaces.nsIURL);
    
    switch (url.host) {
      case "favorites":
        var chromeURL = "chrome://flock/content/common/streamReader.xhtml";
        break;
      case "preview":
        var chromeURL = "chrome://flock/content/common/streamReader.xhtml";
        break;
      default:
        var chromeURL = "chrome://flock/content/common/streamReader.xhtml";
        break;
    }
    
    var ios = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
    var channel = ios.newChannel(chromeURL, null, null);
    
    //var Channel = Components.Constructor("@flock.com/flock-channel;1", "flockIFlockChannel", "init");
    //var channel = new Channel(URI);
    
    return channel;
  },
  
  newURI: function(spec, originCharset, baseURI)
  {
    var url = Components.classes["@mozilla.org/network/simple-uri;1"].createInstance(Components.interfaces.nsIURI);

    try {
      url.spec = spec;
    } catch (e) {
      try {
        url.spec = this.scheme + ":" + spec;
      } catch (e) {
        url.spec = "javascript:void(0)";
      }
    }

    return url;
  },

  // nsIClassInfo
  getInterfaces: function(aCount)
  {
    var interfaces = [Components.interfaces.nsIProtocolHandler, Components.interfaces.nsIClassInfo];
    aCount.value = interfaces.length;
    return interfaces;
  },

  // nsIClassInfo
  getHelperForLanguage: function(aLanguage)
  {
    return null;
  },

  // nsIClassInfo
  contractID: CONTRACT_ID,

  // nsIClassInfo
  classDescription: CLASS_NAME,

  // nsIClassInfo
  classID: CLASS_ID,

  // nsIClassInfo
  implementationLanguage: Components.interfaces.nsIProgrammingLanguage.JAVASCRIPT,

  // nsIClassInfo
  flags: null,
  
  // nsISupports
  QueryInterface: function(aIID)
  {
    if (aIID.equals(CI.nsISupports) ||
        aIID.equals(CI.nsIProtocolHandler) ||
        aIID.equals(CI.nsIClassInfo))
    {
      return this;
    }
    throw Components.results.NS_ERROR_NO_INTERFACE;
  }
};

/******************************************************************************
 * XPCOM Functions for construction and registration
 ******************************************************************************/
var Module = {
  _firstTime: true,
  registerSelf: function(aCompMgr, aFileSpec, aLocation, aType)
  {
    if (this._firstTime) {
      this._firstTime = false;
      throw Components.results.NS_ERROR_FACTORY_REGISTER_AGAIN;
    }
    aCompMgr = aCompMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.registerFactoryLocation(CLASS_ID, CLASS_NAME, CONTRACT_ID, aFileSpec, aLocation, aType);
  },

  unregisterSelf: function(aCompMgr, aLocation, aType)
  {
    aCompMgr = aCompMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);        
  },
  
  getClassObject: function(aCompMgr, aCID, aIID)
  {
    if (!aIID.equals(Components.interfaces.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
    if (aCID.equals(CLASS_ID))
      return Factory;
    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function(aCompMgr) { return true; }
};

var Factory = {
  createInstance: function(aOuter, aIID)
  {
    if (aOuter != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;
    return (new flockFlockHandler()).QueryInterface(aIID);
  }
};

function NSGetModule(aCompMgr, aFileSpec) { return Module; }
