// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

// This is just a catch all component for miscellaneous migrations that don't
// fit anywhere else

const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockXPCOMUtils.jsm");
CU.import("resource:///modules/FlockStringBundleHelpers.jsm");
CU.import("resource:///modules/FlockPrefsUtils.jsm");

const MIGRATE_MISC_CLASSNAME = "Flock Migrate Miscellaneous";
const MIGRATE_MISC_CLASSID =
  Components.ID("{8d652b97-a0cd-4621-a88e-1667b1106937}");
const MIGRATE_MISC_CONTRACTID = "@flock.com/migrate-miscellaneous;1";

const LOG_FILENAME = "log.txt";

function MigrateMisc() {
  this._logger = CC["@flock.com/logger;1"].createInstance(CI.flockILogger);
  this._logger.init("migrateMisc");
}

MigrateMisc.prototype = new FlockXPCOMUtils.genericComponent(
  MIGRATE_MISC_CLASSNAME,
  MIGRATE_MISC_CLASSID,
  MIGRATE_MISC_CONTRACTID,
  MigrateMisc,
  CI.nsIClassInfo.SINGLETON,
  [CI.flockIMigratable]
);

MigrateMisc.prototype._xpcom_categories = [
  { category: "flockMigratable" }
];

MigrateMisc.prototype.__defineGetter__("migrationName",
function MigrateMisc_getter_migrationName() {
  return flockGetString("common/migrationNames", "migration.name.misc");
});

MigrateMisc.prototype.needsMigration =
function MigrateMisc_needsMigration(aOldVersion) {
  var versionChecker = CC["@mozilla.org/xpcom/version-comparator;1"]
                       .getService(CI.nsIVersionComparator);
  return (versionChecker.compare(aOldVersion, "2.0b4") < 0);
}

MigrateMisc.prototype.startMigration =
function MigrateMisc_startMigration(aOldVersion, aListener) {
  aListener.onUpdate(0, "Miscellaneous clean ups");
  var ctxt = { listener: aListener, oldVersion: aOldVersion };
  return { wrappedJSObject: ctxt };
}

MigrateMisc.prototype.finishMigration =
function MigrateMisc_finishMigration(aWrapper) {
}

MigrateMisc.prototype.doMigrationWork =
function MigrateMisc_doMigrationWork(aWrapper) {
  var ctxt = aWrapper.wrappedJSObject;

  var versionChecker = CC["@mozilla.org/xpcom/version-comparator;1"]
                       .getService(CI.nsIVersionComparator);

  if (versionChecker.compare(ctxt.oldVersion, "1.0") < 0) {
    // Append the myworld to the users home page if it is not already there
    var prefs = CC["@mozilla.org/preferences-service;1"]
                .getService(CI.nsIPrefBranch);
    if (prefs.prefHasUserValue("browser.startup.homepage") &&
        prefs.getPrefType("browser.startup.homepage") == prefs.PREF_STRING)
    {
      var currHomePage = prefs.getCharPref("browser.startup.homepage");
      if (!currHomePage.match(/.*about:myworld.*/)) {
        currHomePage = "about:myworld|" + currHomePage;
        prefs.setCharPref("browser.startup.homepage", currHomePage);
      }
    }
  }

  if (versionChecker.compare(ctxt.oldVersion, "2.0b4") < 0) {
    // Remove old log file, since now it is off by default
    var dirService = CC["@mozilla.org/file/directory_service;1"]
                     .getService(CI.nsIProperties);
    var logFile = dirService.get("ProfD", CI.nsILocalFile);
    logFile.append(LOG_FILENAME);
    try {
      logFile.remove(false);
    } catch (ex) {
      // file doesn't exist, do nothing
    }

    // Just in case the user set these on their own, we will override them.
    // Sub getting started with about:flock (legacy grouse issue)
    FlockPrefsUtils.setCharPref("startup.homepage_welcome_url",
                                "about:flock");

    // Just in case the user set these on their own, we will override them.
    // Getting started in Help menu
    FlockPrefsUtils.setCharPref("flock.tour_page_url",
                                "about:flock");

    // Make sure oobe1 is off
    FlockPrefsUtils.setBoolPref("flock.oobe.dontshow", true);
  }

  return false;
}


var gComponentsArray = [MigrateMisc];

var NSGetModule = FlockXPCOMUtils.generateNSGetModule(MIGRATE_MISC_CLASSNAME,
                                                      gComponentsArray);
