// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockXPCOMUtils.jsm");
CU.import("resource:///modules/FlockStringBundleHelpers.jsm");

const MIGRATE_RDF_CLASSNAME = "Flock Migrate RDF";
const MIGRATE_RDF_CLASSID =
  Components.ID("{152481d4-1db7-4703-ad56-55d2d940e6fb}");
const MIGRATE_RDF_CONTRACTID = "@flock.com/migrate-rdf;1";

const FLOCK_NS = "http://flock.com/rdf#";

var RDFS = null;

const TYPES_TO_DELETE = ["Action", "DragAction", "DragFlavour"];

function MigrateRDF() {
  RDFS = CC["@mozilla.org/rdf/rdf-service;1"]
              .getService(CI.nsIRDFService);
  this._logger = CC["@flock.com/logger;1"].createInstance(CI.flockILogger);
  this._logger.init("migrateRDF");
}

MigrateRDF.prototype = new FlockXPCOMUtils.genericComponent(
  MIGRATE_RDF_CLASSNAME,
  MIGRATE_RDF_CLASSID,
  MIGRATE_RDF_CONTRACTID,
  MigrateRDF,
  CI.nsIClassInfo.SINGLETON,
  [CI.flockIMigratable]
);

MigrateRDF.prototype._xpcom_categories = [
  { category: "flockMigratable" }
];

MigrateRDF.prototype.__defineGetter__("migrationName",
function MigrateRDF_getter_migrationName() {
  return flockGetString("common/migrationNames", "migration.name.RDF");
});

MigrateRDF.prototype.needsMigration =
function MigrateRDF_needsMigration(aOldVersion) {
  return (aOldVersion.substr(0, 3) == "0.9");
}

MigrateRDF.prototype.startMigration =
function MigrateRDF_startMigration(aOldVersion, aListener) {
  this._logger.debug("starting up...");
  aListener.onUpdate(0, "Removing obsolete data");

  var ds = RDFS.GetDataSource("rdf:flock-favorites");
  var ctxt = { listener: aListener, ds: ds };
  return { wrappedJSObject: ctxt };
}

MigrateRDF.prototype.finishMigration =
function MigrateRDF_finishMigration(aWrapper) {
}

MigrateRDF.prototype.doMigrationWork =
function MigrateRDF_doMigrationWork(aWrapper) {
  var ctxt = aWrapper.wrappedJSObject;
  var ds = ctxt.ds;

  var coopType = RDFS.GetResource(FLOCK_NS + "CoopType");

  for each (var type in TYPES_TO_DELETE) {
    var type = RDFS.GetResource(FLOCK_NS + type);
    var resources = [];

    var resourceEnum = ds.GetSources(coopType, type, true);
    while (resourceEnum.hasMoreElements()) {
      var resource = resourceEnum.getNext().QueryInterface(CI.nsIRDFResource);
      resources.push(resource);
    }

    for each (var resource in resources) {
      this._logger.debug("removing " + resource.ValueUTF8);

      ds.Unassert(resource, coopType, type);

      var arcs = ds.ArcLabelsIn(resource);
      while (arcs.hasMoreElements()) {
        var arc = arcs.getNext().QueryInterface(CI.nsIRDFResource);
        var sources = ds.GetSources(arc, resource, true);
        while (sources.hasMoreElements()) {
          var source = sources.getNext().QueryInterface(CI.nsIRDFResource);
          ds.Unassert(source, arc, resource);
        }
      }

      arcs = ds.ArcLabelsOut(resource);
      while (arcs.hasMoreElements()) {
        var arc = arcs.getNext().QueryInterface(CI.nsIRDFResource);
        var targets = ds.GetTargets(resource, arc, true);
        while (targets.hasMoreElements()) {
          var target = targets.getNext().QueryInterface(CI.nsIRDFNode);
          ds.Unassert(resource, arc, target);
        }
      }
    }
  }
}


var gComponentsArray = [MigrateRDF];

var NSGetModule = FlockXPCOMUtils.generateNSGetModule(MIGRATE_RDF_CLASSNAME,
                                                      gComponentsArray);
