// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockXPCOMUtils.jsm");
CU.import("resource:///modules/FlockSvcUtils.jsm");
FlockXPCOMUtils.debug = false;

const MODULE_NAME = "FlockMediaItem";
const CLASS_NAME = "Flock Media Item";
const CLASS_SHORT_NAME = "flockphoto";
const CLASS_ID = Components.ID("{5844743e-41a6-400c-a659-93e0067d1d68}");
const CONTRACT_ID = "@flock.com/photo;1";


/**************************************************************************
 * Component: FlockMediaItem
 **************************************************************************/

function FlockMediaItem() {
  FlockSvcUtils.getLogger(this).init(CLASS_SHORT_NAME);
}

/**************************************************************************
 * FlockMediaItem: XPCOM Component Creation
 **************************************************************************/

FlockMediaItem.prototype = new FlockXPCOMUtils.genericComponent(
  CLASS_NAME,
  CLASS_ID,
  CONTRACT_ID,
  FlockMediaItem,
  0,
  [
    CI.flockIMediaItem
  ]
);

/**************************************************************************
 * FlockMediaItem: flockIMediaItem Implementation
 **************************************************************************/

FlockMediaItem.prototype.svcShortName = "";

FlockMediaItem.prototype.thumbnail = "";
FlockMediaItem.prototype.midSizePhoto = "";
FlockMediaItem.prototype.largeSizePhoto = "";

FlockMediaItem.prototype.embedTag = "";
FlockMediaItem.prototype.has_miniView = "";
FlockMediaItem.prototype.id = "";
FlockMediaItem.prototype.is_public = "";
FlockMediaItem.prototype.is_video = false;
FlockMediaItem.prototype.lastUpdate = "";
FlockMediaItem.prototype.metaData = null;
FlockMediaItem.prototype.icon = "";
FlockMediaItem.prototype.title = "";
FlockMediaItem.prototype.uploadDate = "";
FlockMediaItem.prototype.userid = "";
FlockMediaItem.prototype.username = "";
FlockMediaItem.prototype.webPageUrl = "";

// void init(in AString aSvcShortName, in flockIMediaItemFormatter aFormatter);
FlockMediaItem.prototype.init =
function flockMediaItem_init(aSvcShortName, aFormatter) {
  this._logger.debug(".flockMediaItem_init() for " + aSvcShortName);
  this.svcShortName = aSvcShortName;
  this._formatter = aFormatter;
};

// nsIDOMNode buildTooltip();
FlockMediaItem.prototype.buildTooltip =
function flockMediaItem_buildTooltip() {
  this._logger.debug(".flockMediaItem_buildTooltip() for "
                     + this.svcShortName);

  default xml namespace =
    "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

  var xml = "";
  if (this._formatter && this._formatter.canBuildTooltip) {
    xml = this._formatter.buildTooltip(this);
  } else {
    xml =
      <vbox>
        <hbox>
          <image src={this.midSizePhoto} style="margin-bottom: 2px;" />
          <spacer flex="1" />
        </hbox>
        <hbox>
          <vbox>
            <image src={this.icon} />
            <spacer flex="1" />
          </vbox>
          <vbox anonid="ttInfoContainer">
            <label anonid="ttTitleTxt">{this.title}</label>
            <label anonid="ttUserTxt" class="user">{this.username}</label>
          </vbox>
        </hbox>
      </vbox>;
  }

  var parser = CC["@mozilla.org/xmlextras/domparser;1"]
               .createInstance(CI.nsIDOMParser);
  var doc = parser.parseFromString(xml, "text/xml");
  return doc.documentElement;
};

// AString buildHTML();
FlockMediaItem.prototype.buildHTML =
function flockMediaItem_buildHTML() {
  this._logger.debug(".flockMediaItem_buildHTML() for "
                     + this.svcShortName);

  var html = "";
  if (this._formatter && this._formatter.canBuildHTML) {
    html = this._formatter.buildHTML(this);
  } else {
    if (this.midSizePhoto) {
      // First choice is the mid-size image.
      html =
        <a title={this.title} href={this.webPageUrl}>
          <img src={this.midSizePhoto} border="0" />
        </a>;
    } else if (this.largeSizePhoto) {
      // Mid-size image not present? Try large image.
      html =
        <a title={this.title} href={this.webPageUrl}>
          <img src={this.largeSizePhoto} border="0" />
        </a>;
    } else {
      // No image present? Just show a plain link.
      html = <a href={this.webPageUrl}>{this.title}</a>;
    }
  }
  return html;
};

// AString buildLargeHTML();
FlockMediaItem.prototype.buildLargeHTML =
function flockMediaItem_buildLargeHTML() {
  this._logger.debug(".flockMediaItem_buildLargeHTML() for "
                     + this.svcShortName);

  var html = "";
  if (this._formatter && this._formatter.canBuildLargeHTML) {
    html = this._formatter.buildLargeHTML(this);
  } else {
    if (this.largeSizePhoto) {
      // First choice is the large image.
      html =
        <a title={this.title} href={this.webPageUrl}>
          <img src={this.largeSizePhoto} border="0" />
        </a>;
    } else if (this.midSizePhoto) {
      // Large image not present? Try mid-size image.
      html =
        <a title={this.title} href={this.webPageUrl}>
          <img src={this.midSizePhoto} border="0" />
        </a>;
    } else {
      // No image present? Just show a plain link.
      html = <a href={this.webPageUrl}>{this.title}</a>;
    }
  }
  return html;
};

// AString buildBBCode();
FlockMediaItem.prototype.buildBBCode =
function flockMediaItem_buildBBCode() {
  this._logger.debug(".flockMediaItem_buildBBCode() for "
                     + this.svcShortName);

  var bbCode = "";
  if (this._formatter && this._formatter.canBuildBBCode) {
    bbCode = this._formatter.buildBBCode(this);
  } else {
    if (this.largeSizePhoto) {
      // First choice is the large image.
      bbCode = "[url=" + this.webPageUrl
             + "][img]" + this.largeSizePhoto
             + "[/img][/url]";
    } else if (this.midSizePhoto) {
      // Large image not present? Try mid-size image.
      bbCode = "[url=" + this.webPageUrl
             + "][img]" + this.midSizePhoto
             + "[/img][/url]";
    } else {
      // No image present? Just show a plain link.
      bbCode = "[url=" + this.webPageUrl
             + "]" + this.title
             + "[/url]";
    }
  }
  return bbCode;
};

// AString buildMiniPage();
FlockMediaItem.prototype.buildMiniPage =
function flockMediaItem_buildMiniPage() {
  this._logger.debug(".flockMediaItem_buildMiniPage() for "
                     + this.svcShortName);

  var html = "";
  if (this._formatter && this._formatter.canBuildMiniPage) {
    html = this._formatter.buildMiniPage(this);
  } else {
    html = "<html><head><title>"
         + this.title
         + "("
         + this.username
         + ")</title></head><body><center>"
         + this.buildHTML()
         + "</center></body></html>";
  }
  return html;
};


/**************************************************************************
 * XPCOM Support - Module Construction
 **************************************************************************/

// Create array of components.
var gComponentsArray = [FlockMediaItem];

// Generate a module for XPCOM to find.
var NSGetModule = FlockXPCOMUtils.generateNSGetModule(MODULE_NAME,
                                                      gComponentsArray);

/**************************************************************************
 * END XPCOM Support
 **************************************************************************/
