//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

const FLOCK_PHOTO_ALBUM_CID = Components.ID('{01879f96-3974-41ba-92b8-7e77dbbe5da7}');
const FLOCK_PHOTO_ALBUM_CONTRACTID = '@flock.com/photo-album;1';
const FLOCK_PHOTO_ALBUM_IID = Components.interfaces.flockIPhotoAlbum;


function flockPhotoAlbum() {
}

flockPhotoAlbum.prototype= {
    id: "",
    title: "",
    url: "",

    QueryInterface: function(iid) {
        if (!iid.equals(Components.interfaces.nsISupports) &&
            !iid.equals(FLOCK_PHOTO_ALBUM_IID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        return this;
    }
};


var flockPhotoAlbumModule = {
    registerSelf: function(compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(FLOCK_PHOTO_ALBUM_CID, 
                                        "flockPhotoAlbum JS component", 
                                        FLOCK_PHOTO_ALBUM_CONTRACTID, 
                                        fileSpec, 
                                        location,
                                        type);
    },

    getClassObject: function(compMgr, cid, iid) {
        if (!cid.equals(FLOCK_PHOTO_ALBUM_CID))
            throw Components.results.NS_ERROR_NO_INTERFACE;

        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

        return flockPhotoAlbumFactory;
    },

    canUnload: function(compMgr) { return true; }
};

var flockPhotoAlbumFactory = {
    createInstance: function(outer, iid) {
        if (outer != null)
            throw Components.results.NS_ERROR_NO_AGGREGATION;
    
        if (!iid.equals(FLOCK_PHOTO_ALBUM_IID) &&
            !iid.equals(Components.interfaces.nsISupports))
            throw Components.results.NS_ERROR_INVALID_ARG;

        return new flockPhotoAlbum();
    }
}

/* module initialisation */
function NSGetModule(comMgr, fileSpec) { return flockPhotoAlbumModule; }

