//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

const FLOCK_PHOTO_UPLOAD_CID = Components.ID('{f0189282-1c0c-46a5-a099-e11d5b1ef512}');
const FLOCK_PHOTO_UPLOAD_CONTRACTID = '@flock.com/photo-upload;1';
const FLOCK_PHOTO_UPLOAD_IID = Components.interfaces.flockIPhotoUpload;


function flockPhotoUpload() {
}

flockPhotoUpload.prototype= {
    id: '',
    originalFileSpec: '',
    originalFilePath: '',
    workingFilePath: '',
    previewFileSpec: '',
    previewFilePath: '',
    thumbFileSpec: '',
    thumbFilePath: '',

    title: '',
    tags: '',
    notes: '',
    description: '',
    privacy_use_batch: 'true',
    is_public: '',
    is_friend: '',
    is_family: '',
    album: '',
    state: '',
    /*
     * states:
     *         (blank)
     *         uploading
     *         pending
     */
    rotation: '',
    crop: '',

    QueryInterface: function(iid) {
        if (!iid.equals(Components.interfaces.nsISupports) &&
            !iid.equals(FLOCK_PHOTO_UPLOAD_IID))
            throw Components.results.NS_ERROR_NO_INTERFACE;
        return this;
    }
};


var flockPhotoUploadModule = {
    registerSelf: function(compMgr, fileSpec, location, type) {
        compMgr = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
        compMgr.registerFactoryLocation(FLOCK_PHOTO_UPLOAD_CID, 
                                        "flockPhotoUpload JS component", 
                                        FLOCK_PHOTO_UPLOAD_CONTRACTID, 
                                        fileSpec, 
                                        location,
                                        type);
    },

    getClassObject: function(compMgr, cid, iid) {
        if (!cid.equals(FLOCK_PHOTO_UPLOAD_CID))
            throw Components.results.NS_ERROR_NO_INTERFACE;

        if (!iid.equals(Components.interfaces.nsIFactory))
            throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

        return flockPhotoUploadFactory;
    },

    canUnload: function(compMgr) { return true; }
};

var flockPhotoUploadFactory = {
    createInstance: function(outer, iid) {
        if (outer != null)
            throw Components.results.NS_ERROR_NO_AGGREGATION;
    
        if (!iid.equals(FLOCK_PHOTO_UPLOAD_IID) &&
            !iid.equals(Components.interfaces.nsISupports))
            throw Components.results.NS_ERROR_INVALID_ARG;

        return new flockPhotoUpload();
    }
}

/* module initialisation */
function NSGetModule(comMgr, fileSpec) { return flockPhotoUploadModule; }

