// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

const TVRSS_LIVE_SEARCH_NAME = "tvrss";
const TVRSS_LIVE_SEARCH_CLASSID =
  Components.ID("{6d1177a0-fb92-40cd-8bd8-c6432a1b053a}");

const TVRSS_SEARCH_API_URL = "http://tvrss.net/search/?distribution_group=combined&filename=&date=&quality=&release_group=&mode=rss&show_name=";


const CC = Components.classes;
const CI = Components.interfaces;
const CR = Components.results;
const CU = Components.utils;

CU.import("resource:///modules/FlockLiveSearchProvider.jsm");

function TVRSSLiveSearch() {
  this._init();
}

TVRSSLiveSearch.prototype = FlockLiveSearchProvider.generateComponent(
  TVRSS_LIVE_SEARCH_NAME,
  TVRSS_LIVE_SEARCH_CLASSID,
  TVRSSLiveSearch,
  null,
  "http://tvrss.net/favicon.ico",
  "http://tvrss.net/search/?distribution_group=combined&filename=&date=&quality=&release_group=&mode=simple&show_name="
);

TVRSSLiveSearch.prototype._getQueryURL =
function TVRSS__getQueryURL(aQuery, aNumResults) {
  return TVRSS_SEARCH_API_URL + aQuery;
}

TVRSSLiveSearch.prototype._getResults =
function TVRSS__getResults(aXHR, aMaxResults) {
  var items = aXHR.responseXML.getElementsByTagName("item");

  var maxResults = Math.min(items.length, aMaxResults);

  var results = [];
  for (var i = 0; i < maxResults; i++) {
    var result = items[i];

    var title = result.getElementsByTagName("title")[0].firstChild.nodeValue;
    var url = result.getElementsByTagName("link")[0].firstChild.nodeValue;

    results.push({ title: title, url: url });
  }

  return results;
}

var NSGetModule =
  FlockLiveSearchProvider.generateNSGetModule(TVRSS_LIVE_SEARCH_NAME,
                                              TVRSSLiveSearch);
