//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2008
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

var brandingUtilities = {};

brandingUtilities.buildWebsiteUrl =
function BU_buildWebsiteUrl(aComponent, aRef, aAction, aPartner, aExtra) {
  var params = {
    component: aComponent,
    partner: aPartner,
    ref: aRef,
    distcode: "flock",
    action: aAction
  };

  if (aExtra) {
    for (var key in aExtra) {
      params[key] = aExtra[key]
    }
  }

  var metrics = Components.classes["@flock.com/metrics-service;1"]
                          .getService(Components.interfaces.flockIMetricsService);
  params["User-UUID"] = metrics.getUserUUID();

  var paramList = [];
  for (var key in params) {
    var value = params[key];
    paramList.push(encodeURIComponent(key) + "=" + encodeURIComponent(value));
  }

  return "http://redir.flock.com/redir?" + paramList.join("&");
}
